# Table of Contents

- [Introduction](introduction.md)
- [Quick Start](quick-start.md)
- [Installation](installation/installation.md)
  - [Supported Platforms](installation/supported-platforms.md)
  - [Installing a Binary Distribution](installation/installing-binary.md)
  - [Installing Lix from Source](installation/installing-source.md)
    - [Prerequisites](installation/prerequisites-source.md)
    - [Obtaining a Source Distribution](installation/obtaining-source.md)
    - [Building Lix from Source](installation/building-source.md)
  - [Using Lix within Docker](installation/installing-docker.md)
  - [Security](installation/nix-security.md)
    - [Single-User Mode](installation/single-user.md)
    - [Multi-User Mode](installation/multi-user.md)
  - [Environment Variables](installation/env-variables.md)
  - [Upgrading Lix](installation/upgrading.md)
  - [Uninstalling Lix](installation/uninstall.md)
- [Package Management](package-management/package-management.md)
  - [Basic Package Management](package-management/basic-package-mgmt.md)
  - [Profiles](package-management/profiles.md)
  - [Garbage Collection](package-management/garbage-collection.md)
  - [Sharing Packages Between Machines](package-management/sharing-packages.md)
    - [Serving a Nix store via HTTP](package-management/binary-cache-substituter.md)
    - [Copying Closures via SSH](package-management/copy-closure.md)
    - [Serving a Nix store via SSH](package-management/ssh-substituter.md)
    - [Serving a Nix store via S3](package-management/s3-substituter.md)
- [Nix Language](language/index.md)
  - [Data Types](language/values.md)
  - [Language Constructs](language/constructs.md)
    - [String interpolation](language/string-interpolation.md)
  - [Operators](language/operators.md)
  - [Derivations](language/derivations.md)
    - [Advanced Attributes](language/advanced-attributes.md)
  - [Built-in Constants](language/builtin-constants.md)
  - [Built-in Functions](language/builtins.md)
- [Advanced Topics](advanced-topics/advanced-topics.md)
  - [Remote Builds](advanced-topics/distributed-builds.md)
  - [Tuning Cores and Jobs](advanced-topics/cores-vs-jobs.md)
  - [Verifying Build Reproducibility](advanced-topics/diff-hook.md)
  - [Using the `post-build-hook`](advanced-topics/post-build-hook.md)
  - [Pasta](advanced-topics/pasta.md)
- [Known Issues](known-issues/known-issues.md)
  - [Limitations around non-isolated builds](known-issues/non-isolated-build-limits.md)
- [Command Reference](command-ref/command-ref.md)
  - [Common Options](command-ref/opt-common.md)
  - [Common Environment Variables](command-ref/env-common.md)
  - [Main Commands](command-ref/main-commands.md)
    - [nix-build](command-ref/nix-build.md)
    - [nix-shell](command-ref/nix-shell.md)
    - [nix-store](command-ref/nix-store.md)
      - [nix-store --add-fixed](command-ref/nix-store/add-fixed.md)
      - [nix-store --add](command-ref/nix-store/add.md)
      - [nix-store --delete](command-ref/nix-store/delete.md)
      - [nix-store --dump-db](command-ref/nix-store/dump-db.md)
      - [nix-store --dump](command-ref/nix-store/dump.md)
      - [nix-store --export](command-ref/nix-store/export.md)
      - [nix-store --gc](command-ref/nix-store/gc.md)
      - [nix-store --generate-binary-cache-key](command-ref/nix-store/generate-binary-cache-key.md)
      - [nix-store --import](command-ref/nix-store/import.md)
      - [nix-store --load-db](command-ref/nix-store/load-db.md)
      - [nix-store --optimise](command-ref/nix-store/optimise.md)
      - [nix-store --print-env](command-ref/nix-store/print-env.md)
      - [nix-store --query](command-ref/nix-store/query.md)
      - [nix-store --read-log](command-ref/nix-store/read-log.md)
      - [nix-store --realise](command-ref/nix-store/realise.md)
      - [nix-store --repair-path](command-ref/nix-store/repair-path.md)
      - [nix-store --restore](command-ref/nix-store/restore.md)
      - [nix-store --serve](command-ref/nix-store/serve.md)
      - [nix-store --verify-path](command-ref/nix-store/verify-path.md)
      - [nix-store --verify](command-ref/nix-store/verify.md)
    - [nix-env](command-ref/nix-env.md)
      - [nix-env --delete-generations](command-ref/nix-env/delete-generations.md)
      - [nix-env --install](command-ref/nix-env/install.md)
      - [nix-env --list-generations](command-ref/nix-env/list-generations.md)
      - [nix-env --query](command-ref/nix-env/query.md)
      - [nix-env --rollback](command-ref/nix-env/rollback.md)
      - [nix-env --set-flag](command-ref/nix-env/set-flag.md)
      - [nix-env --set](command-ref/nix-env/set.md)
      - [nix-env --switch-generation](command-ref/nix-env/switch-generation.md)
      - [nix-env --switch-profile](command-ref/nix-env/switch-profile.md)
      - [nix-env --uninstall](command-ref/nix-env/uninstall.md)
      - [nix-env --upgrade](command-ref/nix-env/upgrade.md)
  - [Utilities](command-ref/utilities.md)
    - [nix-channel](command-ref/nix-channel.md)
    - [nix-collect-garbage](command-ref/nix-collect-garbage.md)
    - [nix-copy-closure](command-ref/nix-copy-closure.md)
    - [nix-daemon](command-ref/nix-daemon.md)
    - [nix-hash](command-ref/nix-hash.md)
    - [nix-instantiate](command-ref/nix-instantiate.md)
    - [nix-prefetch-url](command-ref/nix-prefetch-url.md)
  - [Experimental Commands](command-ref/experimental-commands.md)
    - [nix](command-ref/new-cli/nix.md)
    - [nix build](command-ref/new-cli/nix3-build.md)
    - [nix bundle](command-ref/new-cli/nix3-bundle.md)
    - [nix config](command-ref/new-cli/nix3-config.md)
    - [nix config show](command-ref/new-cli/nix3-config-show.md)
    - [nix copy](command-ref/new-cli/nix3-copy.md)
    - [nix daemon](command-ref/new-cli/nix3-daemon.md)
    - [nix derivation](command-ref/new-cli/nix3-derivation.md)
    - [nix derivation add](command-ref/new-cli/nix3-derivation-add.md)
    - [nix derivation show](command-ref/new-cli/nix3-derivation-show.md)
    - [nix develop](command-ref/new-cli/nix3-develop.md)
    - [nix doctor](command-ref/new-cli/nix3-doctor.md)
    - [nix edit](command-ref/new-cli/nix3-edit.md)
    - [nix eval](command-ref/new-cli/nix3-eval.md)
    - [nix flake](command-ref/new-cli/nix3-flake.md)
    - [nix flake archive](command-ref/new-cli/nix3-flake-archive.md)
    - [nix flake check](command-ref/new-cli/nix3-flake-check.md)
    - [nix flake clone](command-ref/new-cli/nix3-flake-clone.md)
    - [nix flake info](command-ref/new-cli/nix3-flake-info.md)
    - [nix flake init](command-ref/new-cli/nix3-flake-init.md)
    - [nix flake lock](command-ref/new-cli/nix3-flake-lock.md)
    - [nix flake metadata](command-ref/new-cli/nix3-flake-metadata.md)
    - [nix flake new](command-ref/new-cli/nix3-flake-new.md)
    - [nix flake prefetch](command-ref/new-cli/nix3-flake-prefetch.md)
    - [nix flake show](command-ref/new-cli/nix3-flake-show.md)
    - [nix flake update](command-ref/new-cli/nix3-flake-update.md)
    - [nix fmt](command-ref/new-cli/nix3-fmt.md)
    - [nix hash](command-ref/new-cli/nix3-hash.md)
    - [nix hash file](command-ref/new-cli/nix3-hash-file.md)
    - [nix hash path](command-ref/new-cli/nix3-hash-path.md)
    - [nix hash to-base16](command-ref/new-cli/nix3-hash-to-base16.md)
    - [nix hash to-base32](command-ref/new-cli/nix3-hash-to-base32.md)
    - [nix hash to-base64](command-ref/new-cli/nix3-hash-to-base64.md)
    - [nix hash to-sri](command-ref/new-cli/nix3-hash-to-sri.md)
    - [nix help](command-ref/new-cli/nix3-help.md)
    - [nix help-stores](command-ref/new-cli/nix3-help-stores.md)
    - [nix key](command-ref/new-cli/nix3-key.md)
    - [nix key convert-secret-to-public](command-ref/new-cli/nix3-key-convert-secret-to-public.md)
    - [nix key generate-secret](command-ref/new-cli/nix3-key-generate-secret.md)
    - [nix log](command-ref/new-cli/nix3-log.md)
    - [nix nar](command-ref/new-cli/nix3-nar.md)
    - [nix nar cat](command-ref/new-cli/nix3-nar-cat.md)
    - [nix nar dump-path](command-ref/new-cli/nix3-nar-dump-path.md)
    - [nix nar ls](command-ref/new-cli/nix3-nar-ls.md)
    - [nix path-info](command-ref/new-cli/nix3-path-info.md)
    - [nix print-dev-env](command-ref/new-cli/nix3-print-dev-env.md)
    - [nix profile](command-ref/new-cli/nix3-profile.md)
    - [nix profile diff-closures](command-ref/new-cli/nix3-profile-diff-closures.md)
    - [nix profile history](command-ref/new-cli/nix3-profile-history.md)
    - [nix profile install](command-ref/new-cli/nix3-profile-install.md)
    - [nix profile list](command-ref/new-cli/nix3-profile-list.md)
    - [nix profile remove](command-ref/new-cli/nix3-profile-remove.md)
    - [nix profile rollback](command-ref/new-cli/nix3-profile-rollback.md)
    - [nix profile upgrade](command-ref/new-cli/nix3-profile-upgrade.md)
    - [nix profile wipe-history](command-ref/new-cli/nix3-profile-wipe-history.md)
    - [nix realisation](command-ref/new-cli/nix3-realisation.md)
    - [nix realisation info](command-ref/new-cli/nix3-realisation-info.md)
    - [nix registry](command-ref/new-cli/nix3-registry.md)
    - [nix registry add](command-ref/new-cli/nix3-registry-add.md)
    - [nix registry list](command-ref/new-cli/nix3-registry-list.md)
    - [nix registry pin](command-ref/new-cli/nix3-registry-pin.md)
    - [nix registry remove](command-ref/new-cli/nix3-registry-remove.md)
    - [nix repl](command-ref/new-cli/nix3-repl.md)
    - [nix run](command-ref/new-cli/nix3-run.md)
    - [nix search](command-ref/new-cli/nix3-search.md)
    - [nix shell](command-ref/new-cli/nix3-shell.md)
    - [nix store](command-ref/new-cli/nix3-store.md)
    - [nix store add-file](command-ref/new-cli/nix3-store-add-file.md)
    - [nix store add-path](command-ref/new-cli/nix3-store-add-path.md)
    - [nix store cat](command-ref/new-cli/nix3-store-cat.md)
    - [nix store copy-log](command-ref/new-cli/nix3-store-copy-log.md)
    - [nix store copy-sigs](command-ref/new-cli/nix3-store-copy-sigs.md)
    - [nix store delete](command-ref/new-cli/nix3-store-delete.md)
    - [nix store diff-closures](command-ref/new-cli/nix3-store-diff-closures.md)
    - [nix store dump-path](command-ref/new-cli/nix3-store-dump-path.md)
    - [nix store gc](command-ref/new-cli/nix3-store-gc.md)
    - [nix store ls](command-ref/new-cli/nix3-store-ls.md)
    - [nix store make-content-addressed](command-ref/new-cli/nix3-store-make-content-addressed.md)
    - [nix store optimise](command-ref/new-cli/nix3-store-optimise.md)
    - [nix store path-from-hash-part](command-ref/new-cli/nix3-store-path-from-hash-part.md)
    - [nix store ping](command-ref/new-cli/nix3-store-ping.md)
    - [nix store prefetch-file](command-ref/new-cli/nix3-store-prefetch-file.md)
    - [nix store repair](command-ref/new-cli/nix3-store-repair.md)
    - [nix store sign](command-ref/new-cli/nix3-store-sign.md)
    - [nix store verify](command-ref/new-cli/nix3-store-verify.md)
    - [nix upgrade-nix](command-ref/new-cli/nix3-upgrade-nix.md)
    - [nix why-depends](command-ref/new-cli/nix3-why-depends.md)
  - [Files](command-ref/files.md)
    - [nix.conf](command-ref/conf-file.md)
    - [Profiles](command-ref/files/profiles.md)
      - [manifest.nix](command-ref/files/manifest.nix.md)
      - [manifest.json](command-ref/files/manifest.json.md)
    - [Channels](command-ref/files/channels.md)
    - [Default Nix expression](command-ref/files/default-nix-expression.md)
- [Architecture and Design](architecture/architecture.md)
  - [File System Object](architecture/file-system-object.md)
- [Protocols](protocols/protocols.md)
  - [Serving Tarball Flakes](protocols/tarball-fetcher.md)
  - [Derivation "ATerm" file format](protocols/derivation-aterm.md)
- [Glossary](glossary.md)
- [Contributing](contributing/contributing.md)
  - [Hacking](contributing/hacking.md)
  - [Testing](contributing/testing.md)
  - [Experimental Features](contributing/experimental-features.md)
  - [Deprecated Features](contributing/deprecated-features.md)
  - [CLI guideline](contributing/cli-guideline.md)
  - [C++ style guide](contributing/cxx.md)
- [Release Notes](release-notes/release-notes.md)
  - [Upcoming release](release-notes/rl-next.md)
    <!-- RELENG-AUTO-INSERTION-MARKER (see releng/release_notes.py) -->
  - [Lix 2.94 (2025-11-17)](release-notes/rl-2.94.md)
  - [Lix 2.93 (2025-05-09)](release-notes/rl-2.93.md)
  - [Lix 2.92 (2025-01-18)](release-notes/rl-2.92.md)
  - [Lix 2.91 (2024-08-12)](release-notes/rl-2.91.md)
  - [Lix 2.90 (2024-07-10)](release-notes/rl-2.90.md)
  - [Nix 2.18 (2023-09-20)](release-notes/rl-2.18.md)
  - [Nix 2.17 (2023-07-24)](release-notes/rl-2.17.md)
  - [Nix 2.16 (2023-05-31)](release-notes/rl-2.16.md)
  - [Nix 2.15 (2023-04-11)](release-notes/rl-2.15.md)
  - [Nix 2.14 (2023-02-28)](release-notes/rl-2.14.md)
  - [Nix 2.13 (2023-01-17)](release-notes/rl-2.13.md)
  - [Nix 2.12 (2022-12-06)](release-notes/rl-2.12.md)
  - [Nix 2.11 (2022-08-25)](release-notes/rl-2.11.md)
  - [Nix 2.10 (2022-07-11)](release-notes/rl-2.10.md)
  - [Nix 2.9 (2022-05-30)](release-notes/rl-2.9.md)
  - [Nix 2.8 (2022-04-19)](release-notes/rl-2.8.md)
  - [Nix 2.7 (2022-03-07)](release-notes/rl-2.7.md)
  - [Nix 2.6 (2022-01-24)](release-notes/rl-2.6.md)
  - [Nix 2.5 (2021-12-13)](release-notes/rl-2.5.md)
  - [Nix 2.4 (2021-11-01)](release-notes/rl-2.4.md)
  - [Nix 2.3 (2019-09-04)](release-notes/rl-2.3.md)
  - [Nix 2.2 (2019-01-11)](release-notes/rl-2.2.md)
  - [Nix 2.1 (2018-09-02)](release-notes/rl-2.1.md)
  - [Nix 2.0 (2018-02-22)](release-notes/rl-2.0.md)
  - [Nix 1.11.10 (2017-06-12)](release-notes/rl-1.11.10.md)
  - [Nix 1.11 (2016-01-19)](release-notes/rl-1.11.md)
  - [Nix 1.10 (2015-09-03)](release-notes/rl-1.10.md)
  - [Nix 1.9 (2015-06-12)](release-notes/rl-1.9.md)
  - [Nix 1.8 (2014-12-14)](release-notes/rl-1.8.md)
  - [Nix 1.7 (2014-04-11)](release-notes/rl-1.7.md)
  - [Nix 1.6.1 (2013-10-28)](release-notes/rl-1.6.1.md)
  - [Nix 1.6 (2013-09-10)](release-notes/rl-1.6.md)
  - [Nix 1.5.2 (2013-05-13)](release-notes/rl-1.5.2.md)
  - [Nix 1.5 (2013-02-27)](release-notes/rl-1.5.md)
  - [Nix 1.4 (2013-02-26)](release-notes/rl-1.4.md)
  - [Nix 1.3 (2013-01-04)](release-notes/rl-1.3.md)
  - [Nix 1.2 (2012-12-06)](release-notes/rl-1.2.md)
  - [Nix 1.1 (2012-07-18)](release-notes/rl-1.1.md)
  - [Nix 1.0 (2012-05-11)](release-notes/rl-1.0.md)
  - [Nix 0.16 (2010-08-17)](release-notes/rl-0.16.md)
  - [Nix 0.15 (2010-03-17)](release-notes/rl-0.15.md)
  - [Nix 0.14 (2010-02-04)](release-notes/rl-0.14.md)
  - [Nix 0.13 (2009-11-05)](release-notes/rl-0.13.md)
  - [Nix 0.12 (2008-11-20)](release-notes/rl-0.12.md)
  - [Nix 0.11 (2007-12-31)](release-notes/rl-0.11.md)
  - [Nix 0.10.1 (2006-10-11)](release-notes/rl-0.10.1.md)
  - [Nix 0.10 (2006-10-06)](release-notes/rl-0.10.md)
  - [Nix 0.9.2 (2005-09-21)](release-notes/rl-0.9.2.md)
  - [Nix 0.9.1 (2005-09-20)](release-notes/rl-0.9.1.md)
  - [Nix 0.9 (2005-09-16)](release-notes/rl-0.9.md)
  - [Nix 0.8.1 (2005-04-13)](release-notes/rl-0.8.1.md)
  - [Nix 0.8 (2005-04-11)](release-notes/rl-0.8.md)
  - [Nix 0.7 (2005-01-12)](release-notes/rl-0.7.md)
  - [Nix 0.6 (2004-11-14)](release-notes/rl-0.6.md)
  - [Nix 0.5 and earlier](release-notes/rl-0.5.md)
