# Contributing to Lix

Welcome and thank you for considering contributing to Lix! We're currently in a soft release phase, and your support means a lot to us.

To ensure a smooth and effective contribution process, here is a summary of our guidelines:

## Getting help?

If you have any question regarding getting started or reporting bugs, feel free
to reach out to us.

On Matrix, we have a space at `#space:lix.systems`, composed of:

- [`#discuss:lix.systems`](https://matrix.to/#/#discuss:lix.systems) for discussions on Lix.
- [`#dev:lix.systems`](https://matrix.to/#/#dev:lix.systems) for the development channel on Lix.

## Report a bug

- Check if your bug has already been reported in the [issue tracker](https://git.lix.systems/lix-project/lix/issues).
- If you can't find the bug or feature, please open a new issue.

We maintain a copy of the upstream Nix bugs. Their organisation can be read about [here](https://wiki.lix.systems/books/lix-contributors/page/bug-tracker-organisation).

## Report a security vulnerability

For security vulnerabilities, reach out by email at `security at lix dot systems`.

## Making changes to Lix

Before diving into making changes, we want to engage with you and your ideas.

We have a few policies in effect; please take the time to familiarize yourself:

- [Style guide on code](https://wiki.lix.systems/books/lix-contributors/page/code)
- [Freeze policy and recommended contributions](https://wiki.lix.systems/books/lix-contributors/page/freezes-and-recommended-contributions)

To avoid duplication of effort, it may be a good idea to check out the list of
[pending pull requests](https://gerrit.lix.systems/q/status:open+-is:wip) (or "change lists", as Gerrit calls them). Once you have
an idea of what you might want to do, we recommend dropping a message on our
Matrix to ensure your contribution fits with our current schedule and plans

When you're ready and your changes are ready to go:

- Submit your code.
  - Submitting a GitHub PR [on our mirror](https://github.com/lix-project/lix) is totally ok if that's easier for you and your change is relatively small (300 lines or so).

    We may ask you to resubmit it as a Gerrit CL if it is necessary for the change you're making.
  - Our primary code review system is [our Gerrit instance](https://gerrit.lix.systems), where you can open a change list (CL).
    If you're new to Gerrit, check out [our wiki page about Gerrit](https://wiki.lix.systems/books/lix-contributors/page/gerrit).
- Make sure to link any related issues.
- If needed, indicate that the change is 'work in progress'.

You can obtain an account on our platforms by clicking "Sign In with GitHub" on the sign-in page.
