// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="introduction.html"><strong aria-hidden="true">1.</strong> Introduction</a></li><li class="chapter-item expanded "><a href="quick-start.html"><strong aria-hidden="true">2.</strong> Quick Start</a></li><li class="chapter-item expanded "><a href="installation/installation.html"><strong aria-hidden="true">3.</strong> Installation</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="installation/supported-platforms.html"><strong aria-hidden="true">3.1.</strong> Supported Platforms</a></li><li class="chapter-item expanded "><a href="installation/installing-binary.html"><strong aria-hidden="true">3.2.</strong> Installing a Binary Distribution</a></li><li class="chapter-item expanded "><a href="installation/installing-source.html"><strong aria-hidden="true">3.3.</strong> Installing Lix from Source</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="installation/prerequisites-source.html"><strong aria-hidden="true">3.3.1.</strong> Prerequisites</a></li><li class="chapter-item expanded "><a href="installation/obtaining-source.html"><strong aria-hidden="true">3.3.2.</strong> Obtaining a Source Distribution</a></li><li class="chapter-item expanded "><a href="installation/building-source.html"><strong aria-hidden="true">3.3.3.</strong> Building Lix from Source</a></li></ol></li><li class="chapter-item expanded "><a href="installation/installing-docker.html"><strong aria-hidden="true">3.4.</strong> Using Lix within Docker</a></li><li class="chapter-item expanded "><a href="installation/nix-security.html"><strong aria-hidden="true">3.5.</strong> Security</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="installation/single-user.html"><strong aria-hidden="true">3.5.1.</strong> Single-User Mode</a></li><li class="chapter-item expanded "><a href="installation/multi-user.html"><strong aria-hidden="true">3.5.2.</strong> Multi-User Mode</a></li></ol></li><li class="chapter-item expanded "><a href="installation/env-variables.html"><strong aria-hidden="true">3.6.</strong> Environment Variables</a></li><li class="chapter-item expanded "><a href="installation/upgrading.html"><strong aria-hidden="true">3.7.</strong> Upgrading Lix</a></li><li class="chapter-item expanded "><a href="installation/uninstall.html"><strong aria-hidden="true">3.8.</strong> Uninstalling Lix</a></li></ol></li><li class="chapter-item expanded "><a href="package-management/package-management.html"><strong aria-hidden="true">4.</strong> Package Management</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="package-management/basic-package-mgmt.html"><strong aria-hidden="true">4.1.</strong> Basic Package Management</a></li><li class="chapter-item expanded "><a href="package-management/profiles.html"><strong aria-hidden="true">4.2.</strong> Profiles</a></li><li class="chapter-item expanded "><a href="package-management/garbage-collection.html"><strong aria-hidden="true">4.3.</strong> Garbage Collection</a></li><li class="chapter-item expanded "><a href="package-management/sharing-packages.html"><strong aria-hidden="true">4.4.</strong> Sharing Packages Between Machines</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="package-management/binary-cache-substituter.html"><strong aria-hidden="true">4.4.1.</strong> Serving a Nix store via HTTP</a></li><li class="chapter-item expanded "><a href="package-management/copy-closure.html"><strong aria-hidden="true">4.4.2.</strong> Copying Closures via SSH</a></li><li class="chapter-item expanded "><a href="package-management/ssh-substituter.html"><strong aria-hidden="true">4.4.3.</strong> Serving a Nix store via SSH</a></li><li class="chapter-item expanded "><a href="package-management/s3-substituter.html"><strong aria-hidden="true">4.4.4.</strong> Serving a Nix store via S3</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="language/index.html"><strong aria-hidden="true">5.</strong> Nix Language</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="language/values.html"><strong aria-hidden="true">5.1.</strong> Data Types</a></li><li class="chapter-item expanded "><a href="language/constructs.html"><strong aria-hidden="true">5.2.</strong> Language Constructs</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="language/string-interpolation.html"><strong aria-hidden="true">5.2.1.</strong> String interpolation</a></li></ol></li><li class="chapter-item expanded "><a href="language/operators.html"><strong aria-hidden="true">5.3.</strong> Operators</a></li><li class="chapter-item expanded "><a href="language/derivations.html"><strong aria-hidden="true">5.4.</strong> Derivations</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="language/advanced-attributes.html"><strong aria-hidden="true">5.4.1.</strong> Advanced Attributes</a></li></ol></li><li class="chapter-item expanded "><a href="language/builtin-constants.html"><strong aria-hidden="true">5.5.</strong> Built-in Constants</a></li><li class="chapter-item expanded "><a href="language/builtins.html"><strong aria-hidden="true">5.6.</strong> Built-in Functions</a></li></ol></li><li class="chapter-item expanded "><a href="advanced-topics/advanced-topics.html"><strong aria-hidden="true">6.</strong> Advanced Topics</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="advanced-topics/distributed-builds.html"><strong aria-hidden="true">6.1.</strong> Remote Builds</a></li><li class="chapter-item expanded "><a href="advanced-topics/cores-vs-jobs.html"><strong aria-hidden="true">6.2.</strong> Tuning Cores and Jobs</a></li><li class="chapter-item expanded "><a href="advanced-topics/diff-hook.html"><strong aria-hidden="true">6.3.</strong> Verifying Build Reproducibility</a></li><li class="chapter-item expanded "><a href="advanced-topics/post-build-hook.html"><strong aria-hidden="true">6.4.</strong> Using the post-build-hook</a></li><li class="chapter-item expanded "><a href="advanced-topics/pasta.html"><strong aria-hidden="true">6.5.</strong> Pasta</a></li></ol></li><li class="chapter-item expanded "><a href="known-issues/known-issues.html"><strong aria-hidden="true">7.</strong> Known Issues</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="known-issues/non-isolated-build-limits.html"><strong aria-hidden="true">7.1.</strong> Limitations around non-isolated builds</a></li></ol></li><li class="chapter-item expanded "><a href="command-ref/command-ref.html"><strong aria-hidden="true">8.</strong> Command Reference</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/opt-common.html"><strong aria-hidden="true">8.1.</strong> Common Options</a></li><li class="chapter-item expanded "><a href="command-ref/env-common.html"><strong aria-hidden="true">8.2.</strong> Common Environment Variables</a></li><li class="chapter-item expanded "><a href="command-ref/main-commands.html"><strong aria-hidden="true">8.3.</strong> Main Commands</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/nix-build.html"><strong aria-hidden="true">8.3.1.</strong> nix-build</a></li><li class="chapter-item expanded "><a href="command-ref/nix-shell.html"><strong aria-hidden="true">8.3.2.</strong> nix-shell</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store.html"><strong aria-hidden="true">8.3.3.</strong> nix-store</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/nix-store/add-fixed.html"><strong aria-hidden="true">8.3.3.1.</strong> nix-store --add-fixed</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/add.html"><strong aria-hidden="true">8.3.3.2.</strong> nix-store --add</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/delete.html"><strong aria-hidden="true">8.3.3.3.</strong> nix-store --delete</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/dump-db.html"><strong aria-hidden="true">8.3.3.4.</strong> nix-store --dump-db</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/dump.html"><strong aria-hidden="true">8.3.3.5.</strong> nix-store --dump</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/export.html"><strong aria-hidden="true">8.3.3.6.</strong> nix-store --export</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/gc.html"><strong aria-hidden="true">8.3.3.7.</strong> nix-store --gc</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/generate-binary-cache-key.html"><strong aria-hidden="true">8.3.3.8.</strong> nix-store --generate-binary-cache-key</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/import.html"><strong aria-hidden="true">8.3.3.9.</strong> nix-store --import</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/load-db.html"><strong aria-hidden="true">8.3.3.10.</strong> nix-store --load-db</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/optimise.html"><strong aria-hidden="true">8.3.3.11.</strong> nix-store --optimise</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/print-env.html"><strong aria-hidden="true">8.3.3.12.</strong> nix-store --print-env</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/query.html"><strong aria-hidden="true">8.3.3.13.</strong> nix-store --query</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/read-log.html"><strong aria-hidden="true">8.3.3.14.</strong> nix-store --read-log</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/realise.html"><strong aria-hidden="true">8.3.3.15.</strong> nix-store --realise</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/repair-path.html"><strong aria-hidden="true">8.3.3.16.</strong> nix-store --repair-path</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/restore.html"><strong aria-hidden="true">8.3.3.17.</strong> nix-store --restore</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/serve.html"><strong aria-hidden="true">8.3.3.18.</strong> nix-store --serve</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/verify-path.html"><strong aria-hidden="true">8.3.3.19.</strong> nix-store --verify-path</a></li><li class="chapter-item expanded "><a href="command-ref/nix-store/verify.html"><strong aria-hidden="true">8.3.3.20.</strong> nix-store --verify</a></li></ol></li><li class="chapter-item expanded "><a href="command-ref/nix-env.html"><strong aria-hidden="true">8.3.4.</strong> nix-env</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/nix-env/delete-generations.html"><strong aria-hidden="true">8.3.4.1.</strong> nix-env --delete-generations</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/install.html"><strong aria-hidden="true">8.3.4.2.</strong> nix-env --install</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/list-generations.html"><strong aria-hidden="true">8.3.4.3.</strong> nix-env --list-generations</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/query.html"><strong aria-hidden="true">8.3.4.4.</strong> nix-env --query</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/rollback.html"><strong aria-hidden="true">8.3.4.5.</strong> nix-env --rollback</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/set-flag.html"><strong aria-hidden="true">8.3.4.6.</strong> nix-env --set-flag</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/set.html"><strong aria-hidden="true">8.3.4.7.</strong> nix-env --set</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/switch-generation.html"><strong aria-hidden="true">8.3.4.8.</strong> nix-env --switch-generation</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/switch-profile.html"><strong aria-hidden="true">8.3.4.9.</strong> nix-env --switch-profile</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/uninstall.html"><strong aria-hidden="true">8.3.4.10.</strong> nix-env --uninstall</a></li><li class="chapter-item expanded "><a href="command-ref/nix-env/upgrade.html"><strong aria-hidden="true">8.3.4.11.</strong> nix-env --upgrade</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="command-ref/utilities.html"><strong aria-hidden="true">8.4.</strong> Utilities</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/nix-channel.html"><strong aria-hidden="true">8.4.1.</strong> nix-channel</a></li><li class="chapter-item expanded "><a href="command-ref/nix-collect-garbage.html"><strong aria-hidden="true">8.4.2.</strong> nix-collect-garbage</a></li><li class="chapter-item expanded "><a href="command-ref/nix-copy-closure.html"><strong aria-hidden="true">8.4.3.</strong> nix-copy-closure</a></li><li class="chapter-item expanded "><a href="command-ref/nix-daemon.html"><strong aria-hidden="true">8.4.4.</strong> nix-daemon</a></li><li class="chapter-item expanded "><a href="command-ref/nix-hash.html"><strong aria-hidden="true">8.4.5.</strong> nix-hash</a></li><li class="chapter-item expanded "><a href="command-ref/nix-instantiate.html"><strong aria-hidden="true">8.4.6.</strong> nix-instantiate</a></li><li class="chapter-item expanded "><a href="command-ref/nix-prefetch-url.html"><strong aria-hidden="true">8.4.7.</strong> nix-prefetch-url</a></li></ol></li><li class="chapter-item expanded "><a href="command-ref/experimental-commands.html"><strong aria-hidden="true">8.5.</strong> Experimental Commands</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/new-cli/nix.html"><strong aria-hidden="true">8.5.1.</strong> nix</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-build.html"><strong aria-hidden="true">8.5.2.</strong> nix build</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-bundle.html"><strong aria-hidden="true">8.5.3.</strong> nix bundle</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-config.html"><strong aria-hidden="true">8.5.4.</strong> nix config</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-config-show.html"><strong aria-hidden="true">8.5.5.</strong> nix config show</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-copy.html"><strong aria-hidden="true">8.5.6.</strong> nix copy</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-daemon.html"><strong aria-hidden="true">8.5.7.</strong> nix daemon</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-derivation.html"><strong aria-hidden="true">8.5.8.</strong> nix derivation</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-derivation-add.html"><strong aria-hidden="true">8.5.9.</strong> nix derivation add</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-derivation-show.html"><strong aria-hidden="true">8.5.10.</strong> nix derivation show</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-develop.html"><strong aria-hidden="true">8.5.11.</strong> nix develop</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-doctor.html"><strong aria-hidden="true">8.5.12.</strong> nix doctor</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-edit.html"><strong aria-hidden="true">8.5.13.</strong> nix edit</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-eval.html"><strong aria-hidden="true">8.5.14.</strong> nix eval</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake.html"><strong aria-hidden="true">8.5.15.</strong> nix flake</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-archive.html"><strong aria-hidden="true">8.5.16.</strong> nix flake archive</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-check.html"><strong aria-hidden="true">8.5.17.</strong> nix flake check</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-clone.html"><strong aria-hidden="true">8.5.18.</strong> nix flake clone</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-info.html"><strong aria-hidden="true">8.5.19.</strong> nix flake info</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-init.html"><strong aria-hidden="true">8.5.20.</strong> nix flake init</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-lock.html"><strong aria-hidden="true">8.5.21.</strong> nix flake lock</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-metadata.html"><strong aria-hidden="true">8.5.22.</strong> nix flake metadata</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-new.html"><strong aria-hidden="true">8.5.23.</strong> nix flake new</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-prefetch.html"><strong aria-hidden="true">8.5.24.</strong> nix flake prefetch</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-show.html"><strong aria-hidden="true">8.5.25.</strong> nix flake show</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-flake-update.html"><strong aria-hidden="true">8.5.26.</strong> nix flake update</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-fmt.html"><strong aria-hidden="true">8.5.27.</strong> nix fmt</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash.html"><strong aria-hidden="true">8.5.28.</strong> nix hash</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-file.html"><strong aria-hidden="true">8.5.29.</strong> nix hash file</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-path.html"><strong aria-hidden="true">8.5.30.</strong> nix hash path</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-to-base16.html"><strong aria-hidden="true">8.5.31.</strong> nix hash to-base16</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-to-base32.html"><strong aria-hidden="true">8.5.32.</strong> nix hash to-base32</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-to-base64.html"><strong aria-hidden="true">8.5.33.</strong> nix hash to-base64</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-hash-to-sri.html"><strong aria-hidden="true">8.5.34.</strong> nix hash to-sri</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-help.html"><strong aria-hidden="true">8.5.35.</strong> nix help</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-help-stores.html"><strong aria-hidden="true">8.5.36.</strong> nix help-stores</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-key.html"><strong aria-hidden="true">8.5.37.</strong> nix key</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-key-convert-secret-to-public.html"><strong aria-hidden="true">8.5.38.</strong> nix key convert-secret-to-public</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-key-generate-secret.html"><strong aria-hidden="true">8.5.39.</strong> nix key generate-secret</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-log.html"><strong aria-hidden="true">8.5.40.</strong> nix log</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-nar.html"><strong aria-hidden="true">8.5.41.</strong> nix nar</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-nar-cat.html"><strong aria-hidden="true">8.5.42.</strong> nix nar cat</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-nar-dump-path.html"><strong aria-hidden="true">8.5.43.</strong> nix nar dump-path</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-nar-ls.html"><strong aria-hidden="true">8.5.44.</strong> nix nar ls</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-path-info.html"><strong aria-hidden="true">8.5.45.</strong> nix path-info</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-print-dev-env.html"><strong aria-hidden="true">8.5.46.</strong> nix print-dev-env</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile.html"><strong aria-hidden="true">8.5.47.</strong> nix profile</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-diff-closures.html"><strong aria-hidden="true">8.5.48.</strong> nix profile diff-closures</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-history.html"><strong aria-hidden="true">8.5.49.</strong> nix profile history</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-install.html"><strong aria-hidden="true">8.5.50.</strong> nix profile install</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-list.html"><strong aria-hidden="true">8.5.51.</strong> nix profile list</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-remove.html"><strong aria-hidden="true">8.5.52.</strong> nix profile remove</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-rollback.html"><strong aria-hidden="true">8.5.53.</strong> nix profile rollback</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-upgrade.html"><strong aria-hidden="true">8.5.54.</strong> nix profile upgrade</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-profile-wipe-history.html"><strong aria-hidden="true">8.5.55.</strong> nix profile wipe-history</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-realisation.html"><strong aria-hidden="true">8.5.56.</strong> nix realisation</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-realisation-info.html"><strong aria-hidden="true">8.5.57.</strong> nix realisation info</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-registry.html"><strong aria-hidden="true">8.5.58.</strong> nix registry</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-registry-add.html"><strong aria-hidden="true">8.5.59.</strong> nix registry add</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-registry-list.html"><strong aria-hidden="true">8.5.60.</strong> nix registry list</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-registry-pin.html"><strong aria-hidden="true">8.5.61.</strong> nix registry pin</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-registry-remove.html"><strong aria-hidden="true">8.5.62.</strong> nix registry remove</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-repl.html"><strong aria-hidden="true">8.5.63.</strong> nix repl</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-run.html"><strong aria-hidden="true">8.5.64.</strong> nix run</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-search.html"><strong aria-hidden="true">8.5.65.</strong> nix search</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-shell.html"><strong aria-hidden="true">8.5.66.</strong> nix shell</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store.html"><strong aria-hidden="true">8.5.67.</strong> nix store</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-add-file.html"><strong aria-hidden="true">8.5.68.</strong> nix store add-file</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-add-path.html"><strong aria-hidden="true">8.5.69.</strong> nix store add-path</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-cat.html"><strong aria-hidden="true">8.5.70.</strong> nix store cat</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-copy-log.html"><strong aria-hidden="true">8.5.71.</strong> nix store copy-log</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-copy-sigs.html"><strong aria-hidden="true">8.5.72.</strong> nix store copy-sigs</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-delete.html"><strong aria-hidden="true">8.5.73.</strong> nix store delete</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-diff-closures.html"><strong aria-hidden="true">8.5.74.</strong> nix store diff-closures</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-dump-path.html"><strong aria-hidden="true">8.5.75.</strong> nix store dump-path</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-gc.html"><strong aria-hidden="true">8.5.76.</strong> nix store gc</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-ls.html"><strong aria-hidden="true">8.5.77.</strong> nix store ls</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-make-content-addressed.html"><strong aria-hidden="true">8.5.78.</strong> nix store make-content-addressed</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-optimise.html"><strong aria-hidden="true">8.5.79.</strong> nix store optimise</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-path-from-hash-part.html"><strong aria-hidden="true">8.5.80.</strong> nix store path-from-hash-part</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-ping.html"><strong aria-hidden="true">8.5.81.</strong> nix store ping</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-prefetch-file.html"><strong aria-hidden="true">8.5.82.</strong> nix store prefetch-file</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-repair.html"><strong aria-hidden="true">8.5.83.</strong> nix store repair</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-sign.html"><strong aria-hidden="true">8.5.84.</strong> nix store sign</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-store-verify.html"><strong aria-hidden="true">8.5.85.</strong> nix store verify</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-upgrade-nix.html"><strong aria-hidden="true">8.5.86.</strong> nix upgrade-nix</a></li><li class="chapter-item expanded "><a href="command-ref/new-cli/nix3-why-depends.html"><strong aria-hidden="true">8.5.87.</strong> nix why-depends</a></li></ol></li><li class="chapter-item expanded "><a href="command-ref/files.html"><strong aria-hidden="true">8.6.</strong> Files</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/conf-file.html"><strong aria-hidden="true">8.6.1.</strong> nix.conf</a></li><li class="chapter-item expanded "><a href="command-ref/files/profiles.html"><strong aria-hidden="true">8.6.2.</strong> Profiles</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-ref/files/manifest.nix.html"><strong aria-hidden="true">8.6.2.1.</strong> manifest.nix</a></li><li class="chapter-item expanded "><a href="command-ref/files/manifest.json.html"><strong aria-hidden="true">8.6.2.2.</strong> manifest.json</a></li></ol></li><li class="chapter-item expanded "><a href="command-ref/files/channels.html"><strong aria-hidden="true">8.6.3.</strong> Channels</a></li><li class="chapter-item expanded "><a href="command-ref/files/default-nix-expression.html"><strong aria-hidden="true">8.6.4.</strong> Default Nix expression</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="architecture/architecture.html"><strong aria-hidden="true">9.</strong> Architecture and Design</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="architecture/file-system-object.html"><strong aria-hidden="true">9.1.</strong> File System Object</a></li></ol></li><li class="chapter-item expanded "><a href="protocols/protocols.html"><strong aria-hidden="true">10.</strong> Protocols</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="protocols/tarball-fetcher.html"><strong aria-hidden="true">10.1.</strong> Serving Tarball Flakes</a></li><li class="chapter-item expanded "><a href="protocols/derivation-aterm.html"><strong aria-hidden="true">10.2.</strong> Derivation &quot;ATerm&quot; file format</a></li></ol></li><li class="chapter-item expanded "><a href="glossary.html"><strong aria-hidden="true">11.</strong> Glossary</a></li><li class="chapter-item expanded "><a href="contributing/contributing.html"><strong aria-hidden="true">12.</strong> Contributing</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/hacking.html"><strong aria-hidden="true">12.1.</strong> Hacking</a></li><li class="chapter-item expanded "><a href="contributing/testing.html"><strong aria-hidden="true">12.2.</strong> Testing</a></li><li class="chapter-item expanded "><a href="contributing/experimental-features.html"><strong aria-hidden="true">12.3.</strong> Experimental Features</a></li><li class="chapter-item expanded "><a href="contributing/deprecated-features.html"><strong aria-hidden="true">12.4.</strong> Deprecated Features</a></li><li class="chapter-item expanded "><a href="contributing/cli-guideline.html"><strong aria-hidden="true">12.5.</strong> CLI guideline</a></li><li class="chapter-item expanded "><a href="contributing/cxx.html"><strong aria-hidden="true">12.6.</strong> C++ style guide</a></li></ol></li><li class="chapter-item expanded "><a href="release-notes/release-notes.html"><strong aria-hidden="true">13.</strong> Release Notes</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="release-notes/rl-next.html"><strong aria-hidden="true">13.1.</strong> Upcoming release</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.94.html"><strong aria-hidden="true">13.2.</strong> Lix 2.94 (2025-11-17)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.93.html"><strong aria-hidden="true">13.3.</strong> Lix 2.93 (2025-05-09)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.92.html"><strong aria-hidden="true">13.4.</strong> Lix 2.92 (2025-01-18)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.91.html"><strong aria-hidden="true">13.5.</strong> Lix 2.91 (2024-08-12)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.90.html"><strong aria-hidden="true">13.6.</strong> Lix 2.90 (2024-07-10)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.18.html"><strong aria-hidden="true">13.7.</strong> Nix 2.18 (2023-09-20)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.17.html"><strong aria-hidden="true">13.8.</strong> Nix 2.17 (2023-07-24)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.16.html"><strong aria-hidden="true">13.9.</strong> Nix 2.16 (2023-05-31)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.15.html"><strong aria-hidden="true">13.10.</strong> Nix 2.15 (2023-04-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.14.html"><strong aria-hidden="true">13.11.</strong> Nix 2.14 (2023-02-28)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.13.html"><strong aria-hidden="true">13.12.</strong> Nix 2.13 (2023-01-17)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.12.html"><strong aria-hidden="true">13.13.</strong> Nix 2.12 (2022-12-06)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.11.html"><strong aria-hidden="true">13.14.</strong> Nix 2.11 (2022-08-25)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.10.html"><strong aria-hidden="true">13.15.</strong> Nix 2.10 (2022-07-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.9.html"><strong aria-hidden="true">13.16.</strong> Nix 2.9 (2022-05-30)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.8.html"><strong aria-hidden="true">13.17.</strong> Nix 2.8 (2022-04-19)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.7.html"><strong aria-hidden="true">13.18.</strong> Nix 2.7 (2022-03-07)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.6.html"><strong aria-hidden="true">13.19.</strong> Nix 2.6 (2022-01-24)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.5.html"><strong aria-hidden="true">13.20.</strong> Nix 2.5 (2021-12-13)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.4.html"><strong aria-hidden="true">13.21.</strong> Nix 2.4 (2021-11-01)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.3.html"><strong aria-hidden="true">13.22.</strong> Nix 2.3 (2019-09-04)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.2.html"><strong aria-hidden="true">13.23.</strong> Nix 2.2 (2019-01-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.1.html"><strong aria-hidden="true">13.24.</strong> Nix 2.1 (2018-09-02)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-2.0.html"><strong aria-hidden="true">13.25.</strong> Nix 2.0 (2018-02-22)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.11.10.html"><strong aria-hidden="true">13.26.</strong> Nix 1.11.10 (2017-06-12)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.11.html"><strong aria-hidden="true">13.27.</strong> Nix 1.11 (2016-01-19)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.10.html"><strong aria-hidden="true">13.28.</strong> Nix 1.10 (2015-09-03)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.9.html"><strong aria-hidden="true">13.29.</strong> Nix 1.9 (2015-06-12)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.8.html"><strong aria-hidden="true">13.30.</strong> Nix 1.8 (2014-12-14)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.7.html"><strong aria-hidden="true">13.31.</strong> Nix 1.7 (2014-04-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.6.1.html"><strong aria-hidden="true">13.32.</strong> Nix 1.6.1 (2013-10-28)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.6.html"><strong aria-hidden="true">13.33.</strong> Nix 1.6 (2013-09-10)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.5.2.html"><strong aria-hidden="true">13.34.</strong> Nix 1.5.2 (2013-05-13)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.5.html"><strong aria-hidden="true">13.35.</strong> Nix 1.5 (2013-02-27)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.4.html"><strong aria-hidden="true">13.36.</strong> Nix 1.4 (2013-02-26)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.3.html"><strong aria-hidden="true">13.37.</strong> Nix 1.3 (2013-01-04)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.2.html"><strong aria-hidden="true">13.38.</strong> Nix 1.2 (2012-12-06)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.1.html"><strong aria-hidden="true">13.39.</strong> Nix 1.1 (2012-07-18)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-1.0.html"><strong aria-hidden="true">13.40.</strong> Nix 1.0 (2012-05-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.16.html"><strong aria-hidden="true">13.41.</strong> Nix 0.16 (2010-08-17)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.15.html"><strong aria-hidden="true">13.42.</strong> Nix 0.15 (2010-03-17)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.14.html"><strong aria-hidden="true">13.43.</strong> Nix 0.14 (2010-02-04)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.13.html"><strong aria-hidden="true">13.44.</strong> Nix 0.13 (2009-11-05)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.12.html"><strong aria-hidden="true">13.45.</strong> Nix 0.12 (2008-11-20)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.11.html"><strong aria-hidden="true">13.46.</strong> Nix 0.11 (2007-12-31)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.10.1.html"><strong aria-hidden="true">13.47.</strong> Nix 0.10.1 (2006-10-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.10.html"><strong aria-hidden="true">13.48.</strong> Nix 0.10 (2006-10-06)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.9.2.html"><strong aria-hidden="true">13.49.</strong> Nix 0.9.2 (2005-09-21)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.9.1.html"><strong aria-hidden="true">13.50.</strong> Nix 0.9.1 (2005-09-20)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.9.html"><strong aria-hidden="true">13.51.</strong> Nix 0.9 (2005-09-16)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.8.1.html"><strong aria-hidden="true">13.52.</strong> Nix 0.8.1 (2005-04-13)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.8.html"><strong aria-hidden="true">13.53.</strong> Nix 0.8 (2005-04-11)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.7.html"><strong aria-hidden="true">13.54.</strong> Nix 0.7 (2005-01-12)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.6.html"><strong aria-hidden="true">13.55.</strong> Nix 0.6 (2004-11-14)</a></li><li class="chapter-item expanded "><a href="release-notes/rl-0.5.html"><strong aria-hidden="true">13.56.</strong> Nix 0.5 and earlier</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
