{
  lib,
  fetchurl,
  appimageTools,
}:

appimageTools.wrapType2 rec {
  pname = "responsively-app";
  version = "1.16.0";

  src = fetchurl {
    url = "https://github.com/responsively-org/responsively-app-releases/releases/download/v${version}/ResponsivelyApp-${version}.AppImage";
    hash = "sha256-r0wznN+7zZXKNFNFUV4hm2e4gd84M6hVcun4OfNEeSw=";
  };

  appimageContents = appimageTools.extract {
    inherit pname version src;
  };

  extraInstallCommands = ''
    install -m 444 -D ${appimageContents}/responsivelyapp.desktop $out/share/applications/responsivelyapp.desktop
    install -m 444 -D ${appimageContents}/usr/share/icons/hicolor/512x512/apps/responsivelyapp.png \
      $out/share/icons/hicolor/512x512/apps/responsivelyapp.png
    substituteInPlace $out/share/applications/responsivelyapp.desktop \
      --replace-fail 'Exec=AppRun' 'Exec=${pname}'
  '';

  meta = {
    knownVulnerabilities = [
      "Uses electron 27 which is EOL and has multiple vulnerabilities"
      "Has been dropped in Nixpkgs unstable and is unmaintained"
    ];
    description = "Modified web browser that helps in responsive web development";
    mainProgram = "responsively-desktop";
    homepage = "https://responsively.app/";
    changelog = "https://github.com/responsively-org/responsively-app/releases/tag/v${version}";
    license = lib.licenses.agpl3Plus;
    maintainers = with lib.maintainers; [ kashw2 ];
    platforms = [ "x86_64-linux" ];
    sourceProvenance = with lib.sourceTypes; [ binaryNativeCode ];
  };
}
