{
  lib,
  stdenv,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "mx-takeover";
  version = "0.1.1";

  src = fetchFromGitHub {
    owner = "musana";
    repo = "mx-takeover";
    tag = "v${version}";
    hash = "sha256-yDQd2FEVFFsUu3wKxp26VDhGjnuXmAtxpWoKjV6ZrHA=";
  };

  vendorHash = "sha256-mJ8pVsgRM6lhEa8jtCxFhavkf7XFlBqEN9l1r0/GTvM=";

  ldflags = [
    "-s"
    "-w"
  ];

  meta = with lib; {
    description = "Tool to work with DNS MX records";
    homepage = "https://github.com/musana/mx-takeover";
    changelog = "https://github.com/musana/mx-takeover/releases/tag/v${src.tag}";
    license = licenses.mit;
    maintainers = with maintainers; [ fab ];
    mainProgram = "mx-takeover";
    broken = stdenv.hostPlatform.isDarwin;
  };
}
