{
  lib,
  stdenv,
  fetchFromGitHub,
  drat-trim,
  p7zip,
  pkg-config,
}:

let
  # Early meta to reference in pkgconfig generation
  meta = with lib; {
    description = "'keep it simple and clean bare metal SAT solver' written in C";
    mainProgram = "kissat";
    longDescription = ''
      Kissat is a "keep it simple and clean bare metal SAT solver" written in C.
      It is a port of CaDiCaL back to C with improved data structures,
      better scheduling of inprocessing and optimized algorithms and implementation.
    '';
    maintainers = with maintainers; [ shnarazk ];
    platforms = platforms.unix;
    license = licenses.mit;
    homepage = "https://fmv.jku.at/kissat";
  };
in
stdenv.mkDerivation rec {
  pname = "kissat";
  version = "4.0.2";

  src = fetchFromGitHub {
    owner = "arminbiere";
    repo = "kissat";
    rev = "rel-${version}";
    sha256 = "sha256-XVaWO1zHMXM83Qih3HnmIsOvM1zpefF6u9lBP420/mQ=";
  };

  outputs = [
    "out"
    "dev"
    "lib"
  ];

  nativeBuildInputs = [
    pkg-config
  ];

  nativeCheckInputs = [
    drat-trim
    p7zip
  ];
  doCheck = true;

  # 'make test' assumes that /etc/passwd is not writable.
  patches = [ ./writable-passwd-is-ok.patch ];

  # the configure script is not generated by autotools and does not accept the
  # arguments that the default configurePhase passes like --prefix and --libdir
  dontAddPrefix = true;
  setOutputFlags = false;

  configurePhase = ''
    ./configure
  '';

  buildPhase = ''
    make -j$NIX_BUILD_CORES
  '';

  installPhase = ''
    runHook preInstall

    install -Dm0755 build/kissat "$out/bin/kissat"
    install -Dm0644 src/kissat.h "$dev/include/kissat.h"
    install -Dm0644 build/libkissat.a "$lib/lib/libkissat.a"
    mkdir -p "$out/share/doc/kissat/"
    install -Dm0644 {LICEN?E,README*,VERSION} "$out/share/doc/kissat/"

    # Create pkgconfig
    mkdir -p $dev/lib/pkgconfig
    cat > $dev/lib/pkgconfig/kissat.pc <<EOF
    prefix=${placeholder "dev"}
    exec_prefix=\''${prefix}
    libdir=${placeholder "lib"}/lib
    includedir=\''${prefix}/include

    Name: ${pname}
    Description: ${meta.description}
    Version: ${version}
    Libs: -L\''${libdir} -lkissat
    Cflags: -I\''${includedir}
    EOF

    runHook postInstall
  '';

  inherit meta;
}
