# Release 24.05 (“Uakari”, 2024.05/31) {#sec-release-24.05}

Support is planned until the end of December 2024, handing over to 24.11.

## Highlights {#sec-release-24.05-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

<!-- Please keep entries alphabetically sorted. -->

- The default kernel package has been updated from 6.1 to 6.6. All supported kernels remain available.

- For each supporting version of the Linux kernel, firmware blobs
  are compressed with zstd. For firmware blobs this means an increase of 4.4% in size, however
  a significantly higher decompression speed.

- NixOS now installs a stub ELF loader that prints an informative error message when users attempt to run binaries not made for NixOS.
  - This can be disabled through the `environment.stub-ld.enable` option.
  - If you use `programs.nix-ld.enable`, no changes are needed. The stub will be disabled automatically.

- On flake-based NixOS configurations using `nixpkgs.lib.nixosSystem`, NixOS will automatically set `NIX_PATH` and the system-wide flake registry (`/etc/nix/registry.json`) to point `<nixpkgs>` and the unqualified flake path `nixpkgs` to the version of nixpkgs used to build the system.

  This makes `nix run nixpkgs#hello` and `nix-build '<nixpkgs>' -A hello` work out of the box with no added configuration, reusing dependencies already on the system.

  This may be undesirable if Nix commands are not going to be run on the built system since it adds nixpkgs to the system closure. For such closure-size-constrained non-interactive systems, this setting should be disabled.

  To disable it, set [nixpkgs.flake.setNixPath](#opt-nixpkgs.flake.setNixPath) and [nixpkgs.flake.setFlakeRegistry](#opt-nixpkgs.flake.setFlakeRegistry) to false.

- NixOS AMIs are now uploaded regularly to a new AWS Account.
  Instructions on how to use them can be found on <https://nixos.github.io/amis>.
  We are working on integrating the data into the NixOS homepage.
  The list in `nixos/modules/virtualisation/amazon-ec2-amis.nix` will stop
  being updated and will be removed in the future.

- It is now possible to have a completely perlless system (i.e. a system
  without perl). Previously, the NixOS activation depended on two perl scripts
  which can now be replaced via an opt-in mechanism. To make your system
  perlless, you can use the new perlless profile:
  ```nix
  { modulesPath, ... }:
  {
    imports = [ "${modulesPath}/profiles/perlless.nix" ];
  }
  ```

- Cinnamon has been updated to 6.0. Please be aware that the [Wayland session](https://blog.linuxmint.com/?p=4591) is still experimental in this release and could potentially [affect Xorg sessions](https://blog.linuxmint.com/?p=4639). We suggest a reboot when switching between sessions.

- GNOME has been updated to 46 "Kathmandu". Refer to the [release notes](https://release.gnome.org/46/) for more details. Notably this release brings experimental VRR support, default GTK renderer changes and WebDAV support in Online Accounts. This release we have also stopped including the legacy and unsupported Adwaita-Dark theme by default.

- Lomiri (formerly known as Unity8) desktop mode, using Mir 2.x to function as a Wayland compositor, is now available and can be installed with `services.desktopManager.lomiri.enable = true`. Note that some core applications, services and indicators have yet to be packaged, and some functions may remain incomplete, but the base experience should be there.

- LXQt has been updated to 2.0, which is based on Qt 6 and features Wayland support for many applications.

- MATE has been updated to 1.28.
  - To properly support panel plugins built with Wayland (in-process) support, we are introducing the `services.xserver.desktopManager.mate.extraPanelApplets` option, please use that for installing panel applets.
  - Similarly, please use the `services.xserver.desktopManager.mate.extraCajaExtensions` option for installing Caja extensions.
  - To use the Wayland session, enable `services.xserver.desktopManager.mate.enableWaylandSession`. This is opt-in for now as it is in early an stage and introduces a new set of Wayfire closures. Due to [known issues with LightDM](https://github.com/canonical/lightdm/issues/63), we suggest using SDDM as the display manager.

- Plasma 6 is now available and can be installed with `services.desktopManager.plasma6.enable = true;`. Plasma 5 will likely be deprecated in the next release (24.11). Note that Plasma 6 runs as Wayland by default, and the X11 session needs to be explicitly selected if necessary.

## New Services {#sec-release-24.05-new-services}

<!-- Please keep entries alphabetically sorted. -->

- [Anki Sync Server](https://docs.ankiweb.net/sync-server.html), the official sync server built into recent versions of Anki. Available as [services.anki-sync-server](#opt-services.anki-sync-server.enable).
The pre-existing `services.ankisyncd` has been marked deprecated and will be dropped after 24.05 due to lack of maintenance of the ankisyncd software.

- [ALVR](https://github.com/alvr-org/alvr), a VR desktop streamer. Available as [programs.alvr](#opt-programs.alvr.enable).

- [AppImage](https://appimage.org/), a tool to package desktop applications, now has a `binfmt` option to support running AppImages seamlessly on NixOS. Available as [programs.appimage.binfmt](#opt-programs.appimage.binfmt).

- [armagetronad](https://wiki.armagetronad.org), a mid-2000s 3D lightcycle game widely played at iD Tech Camps. You can define multiple servers using `services.armagetronad.<server>.enable`.

- [BenchExec](https://github.com/sosy-lab/benchexec), a framework for reliable benchmarking and resource measurement, available as [programs.benchexec](#opt-programs.benchexec.enable),
  as well as related programs
  [CPU Energy Meter](https://github.com/sosy-lab/cpu-energy-meter), available as [programs.cpu-energy-meter](#opt-programs.cpu-energy-meter.enable), and
  [PQoS Wrapper](https://gitlab.com/sosy-lab/software/pqos-wrapper), available as [programs.pqos-wrapper](#opt-programs.pqos-wrapper.enable).

- [Bluemap](https://bluemap.bluecolored.de/), a 3D minecraft map renderer. Available as [services.bluemap](#opt-services.bluemap.enable).

- [clatd](https://github.com/toreanderson/clatd), a CLAT / SIIT-DC Edge Relay implementation for Linux.

- [Clevis](https://github.com/latchset/clevis), a pluggable framework for automated decryption, used to unlock encrypted devices in initrd. Available as [boot.initrd.clevis.enable](#opt-boot.initrd.clevis.enable).

- [CommaFeed](https://github.com/Athou/commafeed), a Google Reader-inspired self-hosted RSS reader. Available as [services.commafeed](#opt-services.commafeed.enable).

- [davis](https://github.com/tchapi/davis), a simple CardDav and CalDav server inspired by Baïkal. Available as [services.davis](#opt-services.davis.enable).

- [db-rest](https://github.com/derhuerst/db-rest), a wrapper around Deutsche Bahn's internal API for public transport data. Available as [services.db-rest](#opt-services.db-rest.enable).

- [dnsproxy](https://github.com/AdguardTeam/dnsproxy), a simple DNS proxy with DoH, DoT, DoQ and DNSCrypt support. Available as [services.dnsproxy](#opt-services.dnsproxy.enable).

- [FCast Receiver](https://fcast.org), an open-source alternative to Chromecast and AirPlay. Available as [programs.fcast-receiver](#opt-programs.fcast-receiver.enable).

- [FileSender](https://filesender.org/), a file sharing software. Available as [services.filesender](#opt-services.filesender.enable).

- [Firefly-iii](https://www.firefly-iii.org), a free and open source personal finance manager. Available as [services.firefly-iii](#opt-services.firefly-iii.enable).

- [Flarum](https://flarum.org/), a delightfully simple discussion platform for your website. Available as [services.flarum](#opt-services.flarum.enable).

- [fritz-exporter](https://github.com/pdreker/fritz_exporter), a Prometheus exporter for extracting metrics from [FRITZ!](https://avm.de/produkte/) devices. Available as [services.prometheus.exporters.fritz](#opt-services.prometheus.exporters.fritz.enable).

- [GNS3](https://www.gns3.com/), a network software emulator. Available as [services.gns3-server](#opt-services.gns3-server.enable).

- [go-camo](https://github.com/cactus/go-camo), a secure image proxy server. Available as [services.go-camo](#opt-services.go-camo.enable).

- [Guix](https://guix.gnu.org), a functional package manager inspired by Nix. Available as [services.guix](#opt-services.guix.enable).

- [Handheld Daemon](https://github.com/hhd-dev/hhd), support for gaming handhelds like the Legion Go, ROG Ally, and GPD Win. Available as [services.handheld-daemon](#opt-services.handheld-daemon.enable).

- [hebbot](https://github.com/haecker-felix/hebbot), a Matrix bot to generate "This Week in X" like blog posts. Available as [services.hebbot](#opt-services.hebbot.enable).

- [inadyn](https://github.com/troglobit/inadyn), a Dynamic DNS client with built-in support for multiple providers. Available as [services.inadyn](#opt-services.inadyn.enable).

- [intel-gpu-tools](https://drm.pages.freedesktop.org/igt-gpu-tools), tools for development and testing of the Intel DRM driver. Available as [hardware.intel-gpu-tools](#opt-hardware.intel-gpu-tools.enable).

- [isolate](https://github.com/ioi/isolate), a sandbox for securely executing untrusted programs. Available as [security.isolate](#opt-security.isolate.enable).

- [Jottacloud Command-line Tool](https://docs.jottacloud.com/en/articles/1436834-jottacloud-command-line-tool), a CLI for the [Jottacloud](https://jottacloud.com/) cloud storage provider. Available as [services.jotta-cli](#opt-services.jotta-cli.enable).

- [keto](https://www.ory.sh/keto/), a permission & access control server, the first open source implementation of [*Zanzibar: Google's Consistent, Global Authorization System*](https://research.google/pubs/zanzibar-googles-consistent-global-authorization-system/).

- [manticoresearch](https://manticoresearch.com), easy to use open source fast database for search. Available as [services.manticore](#opt-services.manticore.enable).

- [maubot](https://github.com/maubot/maubot), a plugin-based Matrix bot framework. Available as [services.maubot](#opt-services.maubot.enable).

- [mautrix-meta](https://github.com/mautrix/meta), a Matrix <-> Facebook and Matrix <-> Instagram hybrid puppeting/relaybot bridge. Available as services.mautrix-meta.

- [mautrix-signal](https://github.com/mautrix/signal), a Matrix-Signal puppeting bridge. Available as [services.mautrix-signal](#opt-services.mautrix-signal.enable).

- [Mealie](https://nightly.mealie.io/), a self-hosted recipe manager and meal planner with a RestAPI backend and a reactive frontend application built in NuxtJS for a pleasant user experience for the whole family. Available as [services.mealie](#opt-services.mealie.enable).

- [MollySocket](https://github.com/mollyim/mollysocket) which allows getting Signal notifications via UnifiedPush.

- [microsocks](https://github.com/rofl0r/microsocks), a tiny, portable SOCKS5 server with very moderate resource usage. Available as [services.microsocks](#opt-services.microsocks.enable).

- [Mihomo](https://github.com/MetaCubeX/mihomo/tree/Alpha), a rule-based proxy in Go. Available as [services.mihomo.enable](#opt-services.mihomo.enable).

- [Monado](https://monado.freedesktop.org/), an open source XR runtime. Available as [services.monado](#opt-services.monado.enable).

- [Netbird](https://netbird.io), an open-source VPN management platform, now has a self-hosted management server. Available as [services.netbird.server](#opt-services.netbird.server.enable).

- [nh](https://github.com/nix-community/nh), yet another Nix CLI helper. Available as [programs.nh](#opt-programs.nh.enable).

- [oink](https://github.com/rlado/oink), a dynamic DNS client for Porkbun. Available as [services.oink](#opt-services.oink.enable).

- [ollama](https://ollama.ai), server for running large language models locally.

- [nextjs-ollama-llm-ui](https://github.com/jakobhoeg/nextjs-ollama-llm-ui), light-weight frontend server to chat with Ollama models through a web app.

- [ownCloud Infinite Scale Stack](https://owncloud.com/infinite-scale-4-0/), a modern and scalable rewrite of ownCloud.

- [PhotonVision](https://photonvision.org/), a free, fast, and easy-to-use computer vision solution for the FIRST® Robotics Competition.

- [ping_exporter](https://github.com/czerwonk/ping_exporter), a Prometheus exporter for ICMP echo requests. Available as [services.prometheus.exporters.ping](#opt-services.prometheus.exporters.ping.enable).

- [Pretix](https://pretix.eu/about/en/), an open source ticketing software for events. Available as [services.pretix](#opt-services.pretix.enable).

- [pretalx](https://github.com/pretalx/pretalx), a conference planning tool. Available as [services.pretalx](#opt-services.pretalx.enable).

- [private-gpt](https://github.com/zylon-ai/private-gpt), a service to interact with your documents using the power of LLMs, 100% privately, no data leaks. Available as [services.private-gpt](#opt-services.private-gpt.enable).

- [Prometheus DNSSEC Exporter](https://github.com/chrj/prometheus-dnssec-exporter): check for validity and expiration in DNSSEC signatures and expose metrics for Prometheus. Available as [services.prometheus.exporters.dnssec](#opt-services.prometheus.exporters.dnssec.enable).

- [prometheus-nats-exporter](https://github.com/nats-io/prometheus-nats-exporter), a Prometheus exporter for NATS. Available as [services.prometheus.exporters.nats](#opt-services.prometheus.exporters.nats.enable).

- [pyLoad](https://pyload.net/), a FOSS download manager written in Python. Available as [services.pyload](#opt-services.pyload.enable).

- [Python Matter Server](https://github.com/home-assistant-libs/python-matter-server), a
  Matter Controller Server exposing websocket connections for use with other services, notably Home Assistant.
  Available as [services.matter-server](#opt-services.matter-server.enable).

- [RustDesk](https://rustdesk.com), a full-featured open source remote control alternative for self-hosting and security with minimal configuration. Alternative to TeamViewer. Available as [services.rustdesk-server](#opt-services.rustdesk-server.enable).

- [ryzen-monitor-ng](https://github.com/mann1x/ryzen_monitor_ng), a desktop AMD CPU power monitor and controller, similar to Ryzen Master but for Linux. Available as [programs.ryzen-monitor-ng](#opt-programs.ryzen-monitor-ng.enable).

- [ryzen-smu](https://gitlab.com/leogx9r/ryzen_smu), Linux kernel driver to expose the SMU (System Management Unit) for certain AMD Ryzen Processors. Includes the userspace program `monitor_cpu`. Available at [hardware.cpu.amd.ryzen-smu](#opt-hardware.cpu.amd.ryzen-smu.enable).

- [Scrutiny](https://github.com/AnalogJ/scrutiny), a S.M.A.R.T monitoring tool for hard disks with a web frontend. Available as [services.scrutiny](#opt-services.scrutiny.enable).

- [SimpleSAMLphp](https://simplesamlphp.org/), an application written in native PHP that deals with authentication (SQL, .htpasswd, YubiKey, LDAP, PAPI, Radius). Available as [services.simplesamlphp](#opt-services.simplesamlphp).

- `systemd`'s `gateway`, `upload`, and `remote` services, which provide ways of sending journals across the network. Enable using [services.journald.gateway](#opt-services.journald.gateway.enable), [services.journald.upload](#opt-services.journald.upload.enable), and [services.journald.remote](#opt-services.journald.remote.enable).

- [systemd-lock-handler](https://git.sr.ht/~whynothugo/systemd-lock-handler/), a bridge between logind D-Bus events and systemd targets. Available as [services.systemd-lock-handler.enable](#opt-services.systemd-lock-handler.enable).

- [rspamd-trainer](https://gitlab.com/onlime/rspamd-trainer), script triggered by a helper which reads mails from a specific mail inbox and feeds them into rspamd for spam/ham training.

- [Sunshine](https://app.lizardbyte.dev/Sunshine), a self-hosted game stream host for Moonlight. Available as [services.sunshine](#opt-services.sunshine.enable).

- [Suwayomi Server](https://github.com/Suwayomi/Suwayomi-Server), a free and open source manga reader server that runs extensions built for [Tachiyomi](https://tachiyomi.org). Available as [services.suwayomi-server](#opt-services.suwayomi-server.enable).

- [TigerBeetle](https://tigerbeetle.com/), a distributed financial accounting database designed for mission critical safety and performance. Available as [services.tigerbeetle](#opt-services.tigerbeetle.enable).

- [transfer-sh](https://github.com/dutchcoders/transfer.sh), a tool that supports easy and fast file sharing from the command-line. Available as [services.transfer-sh](#opt-services.transfer-sh.enable).

- [TuxClocker](https://github.com/Lurkki14/tuxclocker), a hardware control and monitoring program. Available as [programs.tuxclocker](#opt-programs.tuxclocker.enable).

- [Uni-Sync](https://github.com/EightB1ts/uni-sync), a synchronization tool for Lian Li Uni Controllers. Available as [hardware.uni-sync](#opt-hardware.uni-sync.enable).

- [wastebin](https://github.com/matze/wastebin), a pastebin server written in rust. Available as [services.wastebin](#opt-services.wastebin.enable).

- [watchdogd](https://troglobit.com/projects/watchdogd/), a system and process supervisor using watchdog timers. Available as [services.watchdogd](#opt-services.watchdogd.enable).

- [WiVRn](https://github.com/Meumeu/WiVRn), an OpenXR streaming application. Available as [services.wivrn](#opt-services.wivrn.enable).

- [Workout-tracker](https://github.com/jovandeginste/workout-tracker), a workout tracking web application for personal use.

- [wyoming-satellite](https://github.com/rhasspy/wyoming-satellite), a voice assistant satellite for Home Assistant using the Wyoming protocol. Available as [services.wyoming.satellite](#opt-services.wyoming.satellite.enable).

- [xdg-terminal-exec](https://github.com/Vladimir-csp/xdg-terminal-exec), the proposed Default Terminal Execution Specification.

- Convenience options for `amdgpu`, open source driver for Radeon cards, is now available under `hardware.amdgpu`.

- [ydotool](https://github.com/ReimuNotMoe/ydotool), a generic command-line automation tool now has a module. Available as [programs.ydotool](#opt-programs.ydotool.enable).

- [your_spotify](https://github.com/Yooooomi/your_spotify), a self hosted Spotify tracking dashboard. Available as [services.your_spotify](#opt-services.your_spotify.enable)

- [RKE2](https://github.com/rancher/rke2), also known as RKE Government, is Rancher's next-generation Kubernetes distribution. Available as [services.rke2](#opt-services.rke2.enable).

## Backward Incompatibilities {#sec-release-24.05-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `akkoma` now requires explicitly setting the base URL for uploaded media (`settings."Pleroma.Upload".base_url`), as well as for the media proxy if enabled (`settings."Media"`).
  This is recommended to be a separate (sub)domain to the one Akkoma is hosted at.
  See [here](https://meta.akkoma.dev/t/akkoma-stable-2024-03-securer-i-barely-know-her/681#explicit-upload-and-media-proxy-domains-5) for more details.

- `appimageTools.wrapAppImage` now creates the binary at `$out/bin/${pname}` rather than `$out/bin/${pname}-${version}`, which will break downstream workarounds.

- `apptainer` and `singularity` now prioritize system-wide `PATH` over those constructed from dependent packages when searching for third-party utilities. The `PATH` to search for third-party utilities, known as `defaultPath` inside Apptainer/Singularity source code, is now constructed from the following sources, ordered by their precedence:
  - `systemBinPaths`, a new argument introduced to specify system-wide `"/**/bin"` directories.
  - The FHS `defaultPath` value set by Apptainer/Singularity developers, making Apptainer/Singularity work out of the box in FHS systems.
  - `defaultPathInputs`, a list of packages to form the fall-back `PATH`.

  This change is required to enable Sylabs SingularityCE (`singularity`) to run images, as it requires a `fusermount3` commant with the SUID bit set.

  `newuidmapPath` and `newgidmapPath` arguments are deprecated in favour of `systemBinPaths`. Their support will be removed in future releases.

  `programs.singularity.systemBinPaths` option is introduced to specify the `systemBinPaths` argument of the overridden package. It includes `"/run/wrappers/bin"` even if specified empty.

  `programs.singularity.enableFakeroot` option is deprecated and has no effect. `--fakeroot` support is now always enabled as long as `programs.singularity.systemBinPaths` is not forcefully overridden.

- `azure-cli` now has extension support. For example, to install the `aks-preview` extension, use

  ```nix
  {
    environment.systemPackages = [ (azure-cli.withExtensions [ azure-cli.extensions.aks-preview ]) ];
  }
  ```
  To make the `azure-cli` immutable and prevent clashes in case `azure-cli` is also installed via other package managers, some configuration files were moved into the derivation.
  This can be disabled by overriding `withImmutableConfig = false` when building `azure-cli`.

- `boot.supportedFilesystems` and `boot.initrd.supportedFilesystems` are now attribute sets instead of lists. Assignment from lists as done previously is still supported, but checking whether a filesystem is enabled must now by done using `supportedFilesystems.fs or false` instead of using `lib.elem "fs" supportedFilesystems` as was done previously.

- `buildGoModule` now throws an error when `vendorHash` is not specified. `vendorSha256`, deprecated in Nixpkgs 23.11, is now ignored and is no longer a `vendorHash` alias.

- `chromium` and `ungoogled-chromium` had a long-standing issue regarding Widevine DRM handling in nixpkgs fixed.
  `chromium` now no longer automatically downloads Widevine when encountering DRM protected content.
  To be able to play DRM protected content in `chromium`, you now have to explicitly opt-in as originally intended using `chromium.override { enableWideVine = true; }`.
  This override was added almost 10 years ago.

- `craftos-pc` package has been updated to v2.8, which includes [breaking changes](https://github.com/MCJack123/craftos2/releases/tag/v2.8).
  - Files are now handled in binary mode; this could break programs with embedded UTF-8 characters.
  - The ROM was updated to match ComputerCraft version v1.109.2.
  - The bundled Lua was updated to Lua v5.2, which includes breaking changes. See the [Lua manual](https://www.lua.org/manual/5.2/manual.html#8) for more information.
  - The WebSocket API [was rewritten](https://github.com/MCJack123/craftos2/issues/337), which introduced breaking changes.

- `cryptsetup` has been upgraded from 2.6.1 to 2.7.0. Cryptsetup is a critical component enabling LUKS-based (but not only) full disk encryption.
  Take the time to review [the release notes](https://gitlab.com/cryptsetup/cryptsetup/-/raw/v2.7.0/docs/v2.7.0-ReleaseNotes).
  One of the highlights is that it is now possible to use hardware OPAL-based encryption of your disk with `cryptsetup`. It has a lot of caveats, see the above notes for the full details.

- `crystal` package has been updated to 1.11.x, which has some breaking changes.
  Refer to crystal's changelog for more information. ([v1.10](https://github.com/crystal-lang/crystal/blob/master/CHANGELOG.md#1100-2023-10-09), [v1.11](https://github.com/crystal-lang/crystal/blob/master/CHANGELOG.md#1110-2024-01-08))

- `cudaPackages` package scope has been updated to `cudaPackages_12`.

- `cudaPackages.autoAddOpenGLRunpathHook` and `cudaPackages.autoAddDriverRunpath` have been deprecated for `pkgs.autoAddDriverRunpath`. Functionality has not changed, but the setuphook has been renamed and moved to the top-level package scope.

- `cudaPackages.cudatoolkit` has been deprecated and replaced with a
  symlink-based wrapper for the splayed redistributable CUDA packages. The
  wrapper only includes tools and libraries necessary to build common packages
  such as tensorflow. The original runfile-based `cudatoolkit` is still
  available as `cudatoolkit-legacy-runfile`.

- `cudaPackages.nsight_systems` now has most vendored third-party libraries removed, though we now only ship it for `cudaPackages_11_8` and later, due to outdated dependencies. Users comfortable with the vendored dependencies may use `overrideAttrs` to amend the `postPatch` phase and the `meta.broken` correspondingly. Alternatively, one could package the deprecated `boost170` locally, as required for `cudaPackages_11_4.nsight_systems`.

- `cudaPackages.autoFixElfFiles` has been deprecated for `pkgs.autoFixElfFiles`. Functionality has not changed, but the setuphook has been renamed and moved to the top-level package scope.

- `davfs2`'s `services.davfs2.extraConfig` setting has been deprecated and converted to the free-form type option named `services.davfs2.settings` according to RFC42.

- `dwarf-fortress` has been updated to version 50, which is identical to the version on Steam, but without the paid elements like tilepacks.
  dfhack and Dwarf Therapist still work, and older versions are still packaged in case you'd like to roll back. Note that DF 50 saves will not be compatible with DF 0.47 and earlier.
  See [Bay 12 Games](http://www.bay12games.com/dwarves/) for more details on what's new in Dwarf Fortress.

  - Running an earlier version can be achieved through an override: `dwarf-fortress-packages.dwarf-fortress-full.override { dfVersion = "0.47.5"; }`

  - Ruby plugin support has been disabled in DFHack. Many of the Ruby plugins have been converted to Lua, and support was removed upstream due to frequent crashes.

- `erlang-ls` package no longer ships the `els_dap` binary as of v0.51.0.

- `erlang_node_short_name`, `erlang_node_name`: `port` and `options` configuration parameters are gone, and have been replaced with an `environment` parameter.
    Use the appropriate [environment variables](https://hexdocs.pm/livebook/readme.html#environment-variables) inside `environment` to configure the service instead.

- `firefox-devedition`, `firefox-beta`, `firefox-esr` executable file names for now match their package names, which is consistent with the `firefox-*-bin` packages. The desktop entries are also updated so that you can have multiple editions of firefox in your app launcher.

- `gauge` now supports installing plugins using Nix. For the old imperative approach, switch to `gauge-unwrapped`.
  You can load plugins from an existing gauge manifest file using `gauge.fromManifest ./path/to/manifest.json` or
  specify plugins in Nix using `gauge.withPlugins (p: with p; [ js html-report xml-report ])`.

- `gitea` has been updated to 1.21, which introduces several breaking changes, including:
  - Custom themes and other assets that were previously stored in `custom/public/*` now belong in `custom/public/assets/*`
  - New instances of Gitea using MySQL now ignore the `[database].CHARSET` config option and always use the `utf8mb4` charset, existing instances should migrate via the `gitea doctor convert` CLI command.

- `git-town` was updated from version 11 to 13. See the [changelog](https://github.com/git-town/git-town/blob/main/CHANGELOG.md#1300-2024-03-22) for breaking changes.

- `gonic` has been updated to v0.16.4. Config now requires `playlists-path` to be set. See the rest of the [v0.16.0 release notes](https://github.com/sentriz/gonic/releases/tag/v0.16.0) for more details.

- `go-ethereum` has been updated to v1.14.3. Geth v1.14.0 introduced a brand new live-tracing feature,
  which required a number of breaking internal API changes. If you had your own native tracers implemented before this change,
  the [changelog](https://github.com/ethereum/go-ethereum/blob/master/core/tracing/CHANGELOG.md) contains the necessary steps needed to update your old code for the new APIs.
  Geth v1.14.0 drops support for running pre-merge networks ([#29169](https://github.com/ethereum/go-ethereum/pull/29169)).
  It also stops automatically constructing the pending block ([#28623](https://github.com/ethereum/go-ethereum/pull/28623)),
  removes support for filtering pending logs, switched to using Go v1.22 by default (#28946), which means we've dropped support for Go v1.20.
  See [the 1.14.0 release notes](https://github.com/ethereum/go-ethereum/releases/tag/v1.14.0) for more details.

- `grafana-loki` has been updated to 3.0.0, which includes [breaking changes](https://github.com/grafana/loki/releases/tag/v3.0.0).

- `gtest` package has been updated past v1.13.0, which requires C++14 or higher.

- `hare` may now be cross-compiled. For that to work, however, `haredoc` needed to stop being built together with it. Thus, the latter is now its own package with the name of `haredoc`.

- `himalaya` has been updated to v1.0.0-beta.4, which introduces breaking changes. Check out the [release note](https://github.com/soywod/himalaya/releases/tag/v1.0.0-beta.4) for details.

- `halloy` has been updated to 2024.5, which introduced a breaking change by switching the config format from YAML to TOML. See <https://github.com/squidowl/halloy/releases/tag/2024.5> for details.

- `hvm` was updated to version 2.

- `icu` no longer includes `install-sh` and `mkinstalldirs` in the shared folder.

- `idris2` was updated to v0.7.0. This version introduces breaking changes. Check out the [changelog](https://github.com/idris-lang/Idris2/blob/v0.7.0/CHANGELOG.md#v070) for details.

- `inetutils` now has a lower priority to avoid shadowing the commonly-used `util-linux`. If one wishes to restore the default priority, simply use `lib.setPrio 5 inetutils` or override with `meta.priority = 5`.

- `jdt-language-server` package now uses upstream's provided python wrapper instead of our own custom wrapper. This results in the following breaking and notable changes:

  - The main binary for the package is now named `jdtls` instead of `jdt-language-server`, equivalent to what most editors expect the binary to be named.

  - JVM arguments should now be provided with the `--jvm-arg` flag instead of setting `JAVA_OPTS`.

  - The `-data` path is no longer required to run the package, and will be set to point to a folder in `$TMP` if missing.

- `julia` environments can now be built with arbitrary packages from the ecosystem using the `.withPackages` function. For example: `julia.withPackages ["Plots"]`.

- `k3s` has been updated to version [v1.30](https://github.com/k3s-io/k3s/releases/tag/v1.30.0%2Bk3s1), previous supported versions are available under release-specific names (e.g. k3s_1_27, k3s_1_28, and k3s_1_29) in order to help you migrate to the latest supported version. See [changelog and upgrade notes](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.30.md#changelog-since-v1290) for more information.

- `k9s` was updated to v0.31. There have been various breaking changes in the config file format,
  check out the changelog of [v0.29](https://github.com/derailed/k9s/releases/tag/v0.29.0),
  [v0.30](https://github.com/derailed/k9s/releases/tag/v0.30.0) and
  [v0.31](https://github.com/derailed/k9s/releases/tag/v0.31.0) for details. It is recommended
  to back up your current configuration and let k9s recreate the new base configuration.

- `kanata` package has been updated to v1.6.1, which includes breaking changes.  Check out the changelog of [v1.5.0](https://github.com/jtroo/kanata/releases/tag/v1.5.0) and [v1.6.0](https://github.com/jtroo/kanata/releases/tag/v1.6.0) for details.

- `linuxPackages_testing_bcachefs` is now fully deprecated by `linuxPackages_latest`, and is therefore no longer available.

- `livebook` package is now built as a `mix release` instead of an `escript`.
  This means that configuration now has to be done using [environment variables](https://hexdocs.pm/livebook/readme.html#environment-variables) instead of command line arguments.
  This has the further consequence that the `livebook` service configuration has changed.

- `lua` interpreters default LUA_PATH and LUA_CPATH are not overridden by nixpkgs
  anymore, we patch LUA_ROOT instead which is more respectful to upstream.

- `luarocks-packages-updater`'s .csv format, used to define lua packages to be updated, has changed: `src` (URL of a git repository) has now become `rockspec` (URL of a rockspec) to remove ambiguity regarding which rockspec to use and simplify implementation.

- `mkosi` was updated to v22. Parts of the user interface have changed. Consult the
  release notes of [v19](https://github.com/systemd/mkosi/releases/tag/v19),
  [v20](https://github.com/systemd/mkosi/releases/tag/v20),
  [v21](https://github.com/systemd/mkosi/releases/tag/v21) and
  [v22](https://github.com/systemd/mkosi/releases/tag/v22) for a list of changes.

- `mongodb-4_4` has been removed as it has reached end of life. Consequently, `unifi7` and `unifi8` now use MongoDB 5.0 by default.

- `mongodb-5_0` and newer requires a cpu with the AVX instruction set to run.

- `neo4j` has been updated to version 5. You may want to read the [release notes for Neo4j 5](https://neo4j.com/release-notes/database/neo4j-5/).

- `netbox` was updated to v3.7. `services.netbox.package` still defaults
  to v3.6 if `stateVersion` is earlier than 24.05. Refer to upstream's breaking
  changes [for
  v3.7.0](https://github.com/netbox-community/netbox/releases/tag/v3.7.0) and
  upgrade NetBox by changing `services.netbox.package`. Database migrations
  will be run automatically.

- `network-interfaces.target` system target was removed as it has been deprecated for a long time. Use `network.target` instead.

- `networking.iproute2.enable` now does not set `environment.etc."iproute2/rt_tables".text`.

  Setting `environment.etc."iproute2/{CONFIG_FILE_NAME}".text` will override the whole configuration file instead of appending it to the upstream configuration file.

  `CONFIG_FILE_NAME` includes `bpf_pinning`, `ematch_map`, `group`, `nl_protos`, `rt_dsfield`, `rt_protos`, `rt_realms`, `rt_scopes`, and `rt_tables`.

- `nextcloud26` has been removed since it's not maintained anymore by upstream. The latest available version of Nextcloud is now v29 (available as `pkgs.nextcloud29`). The installation logic is as follows:
  - If [`services.nextcloud.package`](#opt-services.nextcloud.package) is specified explicitly, this package will be installed (**recommended**).
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=24.05, `pkgs.nextcloud29` will be installed by default.
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=23.11, `pkgs.nextcloud27` will be installed by default.
  - Please note that an upgrade from v27 (or older) to v29 directly is not possible. Please upgrade to `nextcloud28` (or earlier) first. Nextcloud prohibits skipping major versions while upgrading. You can upgrade by declaring [`services.nextcloud.package = pkgs.nextcloud28;`](options.html#opt-services.nextcloud.package).
  - Known warnings after the upgrade are documented in [](#module-services-nextcloud-known-warnings) from now on.
  - The "Photos" app only displays Media from inside the `Photos` directory. This can be changed manually in the "Photos" tab below "Photos settings".

- `nitter` requires a `guest_accounts.jsonl` to be provided as a path or loaded into the default location at `/var/lib/nitter/guest_accounts.jsonl`. See [Guest Account Branch Deployment](https://github.com/zedeus/nitter/wiki/Guest-Account-Branch-Deployment) for details.

- `nixVersions.unstable` was removed. Instead the following attributes are provided:
  - `nixVersions.git` which tracks the latest Nix master and is roughly updated once a week. This is intended to enable people to easily test unreleased changes of Nix to catch regressions earlier.
  - `nixVersions.latest` which points to the latest Nix version packaged in nixpkgs.

- `nomad` has been updated - note that HashiCorp recommends updating one minor version at a time. Please check [their upgrade guide](https://developer.hashicorp.com/nomad/docs/upgrade) for information on safely updating clusters and potential breaking changes.

  - `nomad` is now Nomad 1.7.x.

  - `nomad_1_4` has been removed, as it is now unsupported upstream.

- `nvtop` family of packages was reorganized into a nested attrset. `nvtop` has been renamed to `nvtopPackages.full`, and all `nvtop-{amd,nvidia,intel,msm}` packages are renamed to `nvtopPackages.{amd,nvidia,intel,msm}`.

- `openssh`, `openssh_hpn` and `openssh_gssapi` are now compiled without support for the DSA signature algorithm as it is being deprecated upstream. Users still relying on DSA keys should consider upgrading
  to another signature algorithm. However, for the time being it is possible to restore DSA key support using `override` to set `dsaKeysSupport = true`.

- `optparse-bash` is now dropped due to upstream inactivity. Alternatives available in Nixpkgs include [`argc`](https://github.com/sigoden/argc), [`argbash`](https://github.com/matejak/argbash), [`bashly`](https://github.com/DannyBen/bashly) and [`gum`](https://github.com/charmbracelet/gum), to name a few.

- `paperless`' `services.paperless.extraConfig` setting has been removed and converted to the free-form type and option named `services.paperless.settings`.

- `pdns` was updated to version [v4.9.x](https://doc.powerdns.com/authoritative/changelog/4.9.html), which introduces breaking changes. Check out the [Upgrade Notes](https://doc.powerdns.com/authoritative/upgrading.html#to-4-9-0) for details.

- `percona-server` now follows [the same two-fold release cycle](https://www.percona.com/blog/lts-and-innovation-releases-for-percona-server-for-mysql/) as Oracle MySQL and provides a *Long-Term-Support (LTS)* in parallel with a continuous-delivery *Innovation* release. `percona-server` defaults to `percona-server_lts`, will be backed by the same release branch throughout the lifetime of this stable NixOS release, and is still available under the versioned attribute `percona-server_8_0`.
  The `percona-server_innovation` releases however have support periods shorter than the lifetime of this NixOS release and will continuously be updated to newer Percona releases. Note that Oracle considers the *Innovation* releases to be production-grade, but each release might include backwards-incompatible changes, even in its on-disk format.
  The same release scheme is applied to the supporting `percona-xtrabackup` tool as well.

- `pipewire` and `wireplumber` modules have removed support for using
`environment.etc."pipewire/..."` and `environment.etc."wireplumber/..."`.
Use `services.pipewire.extraConfig` or `services.pipewire.configPackages` for PipeWire and
`services.pipewire.wireplumber.configPackages` for WirePlumber instead.

- `power.ups` now generates `upsd.conf`, `upsd.users` and `upsmon.conf` automatically from a set of new configuration options. This breaks compatibility with existing `power.ups` setups where these files were created manually. Back up these files before upgrading NixOS.

- `programs.nix-ld.libraries` no longer sets `baseLibraries` via the option's default but in config and now merges any additional libraries with the default ones.
  This means that `lib.mkForce` must be used to clear the list of default libraries.

- `screen`'s module has been cleaned, and will now require you to set `programs.screen.enable` in order to populate `screenrc` and add the program to the environment.

- `security.acme.defaults.server` now has a default value instead of `null`.
  This effectively uses the same server, the Let's Encrypt production server,
  but makes the default explicit, instead of relying on the Lego default.

  A side effect of this is that the directory in which account data is stored
  changes and the ACME module will request a new account and new certificates
  for all domains.  This may cause issues if you pin an `acccounturl` in a CAA
  DNS record.  To avoid this, you
  may set `security.acme.defaults.server = null` to keep the old hashes.

- `security.pam.sshAgentAuth.enable` now requires `services.openssh.authorizedKeysFiles` to be non-empty,
  which is the case when `services.openssh.enable` is true. Previously, `pam_ssh_agent_auth` silently failed to work.

- `security.pam.enableSSHAgentAuth` was replaced by the `sshAgentAuth` attrset, and **only**
  `authorized_keys` files listed in [`sshAgentAuth.authorizedKeysFiles`] are trusted,
  defaulting to `/etc/ssh/authorized_keys.d/%u`.
  ::: {.warning}
  Users of {manpage}`pam_ssh_agent_auth(8)` must take care that the pubkeys they use (for instance with `sudo`)
  are listed in [`sshAgentAuth.authorizedKeysFiles`].
  :::
  ::: {.note}
  Previously, all `services.openssh.authorizedKeysFiles` were trusted, including `~/.ssh/authorized_keys`,
  which results in an **insecure** configuration; see [#31611](https://github.com/NixOS/nixpkgs/issues/31611).
  :::

[`sshAgentAuth.authorizedKeysFiles`]: #opt-security.pam.sshAgentAuth.authorizedKeysFiles

- `services.archisteamfarm` no longer uses the abbreviation `asf` for its state directory (`/var/lib/asf`), user and group (both `asf`). Instead the long name `archisteamfarm` is used.
  Configurations with `system.stateVersion` 23.11 or earlier, default to the old stateDirectory until the 24.11 release and must either set the option explicitly or move the data to the new directory.

- `frr` was updated to 10.0, which introduces the default of `enforce-first-as` for BGP. Please disable again if needed.

- `services.aria2.rpcSecret` has been replaced with `services.aria2.rpcSecretFile`.
  This was done so that secrets aren't stored in the world-readable Nix store.
  To migrate, you will have to create a file with the same exact string, and change
  your module options to point to that file. For example, `services.aria2.rpcSecret =
  "mysecret"` becomes `services.aria2.rpcSecretFile = "/path/to/secret_file"`
  where the file `secret_file` contains the string `mysecret`.

- `services.avahi.nssmdns` was split into `services.avahi.nssmdns4` and `services.avahi.nssmdns6` which enable the mDNS NSS switches for IPv4 and IPv6 respectively.
  Since most mDNS responders only register IPv4 addresses, most users want to keep the IPv6 support disabled to avoid long timeouts.

- `services.frp.settings` now generates the frp configuration file in TOML format as [recommended by upstream](https://github.com/fatedier/frp#configuration-files), instead of the legacy INI format. This has also introduced other changes in the configuration file structure and options:
  - The `settings.common` section in the configuration is no longer valid and all the options form inside it now go directly under `settings`.
  - Configuration option names have been changed from snake_case to camelCase. For example: `server_addr` becomes `serverAddr`, `server_port` becomes `serverPort` etc.
  - Proxies are now defined with a new option, `settings.proxies`, which takes a list of proxies.
  - Consult the [upstream documentation](https://github.com/fatedier/frp#example-usage) for more details on the changes.

- `services.hledger-web.capabilities` options has been replaced by a new option `services.hledger-web.allow`.

  - `allow = "view"` means `capabilities = { view = true; }`;
  - `allow = "add"` means `capabilities = { view = true; add = true; }`;
  - `allow = "edit"` means `capabilities = { view = true; add = true; edit = true }`;
  - `allow = "sandstorm"` reads permissions from the `X-Sandstorm-Permissions` request header.

- `services.homepage-dashboard` now takes its configuration using native Nix expressions, rather than dumping templated configurations into `/var/lib/homepage-dashboard` where they were previously managed manually. There are now new options which allow the configuration of bookmarks, services, widgets and custom CSS/JS natively in Nix.

- `services.invidious.settings.db.user`, the default database username has changed from `kemal` to `invidious`. Setups involving an externally-provisioned database (i.e. `services.invidious.database.createLocally == false`) should adjust their configuration accordingly. The old `kemal` user will not be removed automatically even when the database is provisioned automatically.(https://github.com/NixOS/nixpkgs/pull/265857).

- `services.oauth2_proxy` was renamed to `services.oauth2-proxy`. Also the corresponding service, user and group were renamed.

- `services.smokeping` now has an option `webService`. When enabled, smokeping is now served via nginx instead of thttpd. This change brings the following consequences:
  - The default port for smokeping is now the nginx default port 80 instead of 8081.
  - The option `services.smokeping.port` has been removed. To customize the port, use `services.nginx.virtualHosts.smokeping.listen.*.port`.

- `services.neo4j.allowUpgrade` was removed and no longer has any effect. Neo4j 5 supports automatic rolling upgrades.

- `services.nextcloud` has the following options moved into [`services.nextcloud.settings`](#opt-services.nextcloud.settings) and renamed to match the name from Nextcloud's `config.php`:
  - `logLevel` -> [`loglevel`](#opt-services.nextcloud.settings.loglevel),
  - `logType` -> [`log_type`](#opt-services.nextcloud.settings.log_type),
  - `defaultPhoneRegion` -> [`default_phone_region`](#opt-services.nextcloud.settings.default_phone_region),
  - `overwriteProtocol` -> [`overwriteprotocol`](#opt-services.nextcloud.settings.overwriteprotocol),
  - `skeletonDirectory` -> [`skeletondirectory`](#opt-services.nextcloud.settings.skeletondirectory),
  - `globalProfiles` -> [`profile.enabled`](#opt-services.nextcloud.settings._profile.enabled_),
  - `extraTrustedDomains` -> [`trusted_domains`](#opt-services.nextcloud.settings.trusted_domains) and
  - `trustedProxies` -> [`trusted_proxies`](#opt-services.nextcloud.settings.trusted_proxies).

- `services.nginx` will no longer advertise HTTP/3 availability automatically. This must now be manually added, preferably to each location block.
  Example:

  ```nix
  {
    locations."/".extraConfig = ''
      add_header Alt-Svc 'h3=":$server_port"; ma=86400';
    '';
    locations."^~ /assets/".extraConfig = ''
      add_header Alt-Svc 'h3=":$server_port"; ma=86400';
    '';
  }
  ```

- `services.pgbouncer` now has systemd support enabled and will log to journald. The default setting for `services.pgbouncer.logFile` is now `null` to disable logging to a separate log file.

- `services.postgresql.ensureUsers._.ensurePermissions` has been removed as it is
  not declarative and is broken with newer postgresql versions. Consider using
  [](#opt-services.postgresql.ensureUsers._.ensureDBOwnership)
  instead or a tool that is more suited for managing the data inside a postgresql database.

- `services.redis.vmOverCommit` now defaults to `true` and no longer enforces Transparent Hugepages (THP) to be disabled. Redis only works with THP configured to `madvise` which is the kernel's default.

- `services.resolved.fallbackDns`
  - can now be used to disable the upstream fallback servers entirely by setting it to `[]`
  - to get previous behaviour of upstream defaults, set it to `null`
  - default value has changed from `[]` to `null`, in order to preserve default behaviour

- `services.vikunja` systemd service now uses `vikunja` as dynamic user instead of `vikunja-api`. Database users might need to be changed.

- `services.vikunja.setupNginx` setting has been removed. Users now need to set up the webserver configuration on their own with a proxy pass to the vikunja service.

- `services.vmagent` module deprecates `dataDir`, `group` and `user` settings in favor of the systemd-provided CacheDirectory and DynamicUser.

- `services.vmagent.remoteWriteUrl` setting has been renamed to `services.vmagent.remoteWrite.url` and now defaults to `null`.

- `services.zope2` has been removed, as `zope2` is unmaintained and was relying on Python 2.

- `spark2014` has been renamed to `gnatprove`. A version of `gnatprove` matching different GNAT versions is available from the different `gnatPackages` sets.

- `stalwart-mail` has been updated to v0.5.3, which includes [breaking changes](https://github.com/stalwartlabs/mail-server/blob/v0.5.3/UPGRADING.md).

- `system.etc.overlay.enable` option was added. If enabled, `/etc` is
  mounted via an overlayfs instead of being created by a custom perl script.

- `system.forbiddenDependenciesRegex` has been renamed to `system.forbiddenDependenciesRegexes` and now has the type of `listOf string` instead of `string` to accept multiple regexes.

- `systemd.oomd` module behavior has changed:

  - Raise ManagedOOMMemoryPressureLimit from 50% to 80%. This should make systemd-oomd kill things less often, and fix issues like [this](https://pagure.io/fedora-workstation/issue/358).
    Reference: [commit](https://src.fedoraproject.org/rpms/systemd/c/806c95e1c70af18f81d499b24cd7acfa4c36ffd6?branch=806c95e1c70af18f81d499b24cd7acfa4c36ffd6).

  - Remove swap policy. This helps prevent killing processes when user's swap is small.

  - Expand the memory pressure policy to `system.slice`, `user-.slice`, and all user-owned slices. Reference: [commit](https://src.fedoraproject.org/rpms/systemd/c/7665e1796f915dedbf8e014f0a78f4f576d609bb).

  - Rename `systemd.oomd.enableUserServices` to `systemd.oomd.enableUserSlices`.

- `systemd.sysusers.enable` option was added. If enabled, users and
  groups are created with systemd-sysusers instead of with a custom perl script.

- `teleport` has been upgraded from major version 14 to major version 15.
  Refer to upstream [upgrade instructions](https://goteleport.com/docs/management/operations/upgrading/)
  and release notes for [v15](https://goteleport.com/docs/changelog/#1500-013124).

- `unifiLTS`, `unifi5` and `unifi6` have been removed, as they require MongoDB versions which are end-of-life. All these versions can be upgraded to `unifi7` directly.

- `unrar` was updated to v7. See [changelog](https://www.rarlab.com/unrar7notes.htm) for more information.

- `virtualisation.docker.enableNvidia` and `virtualisation.podman.enableNvidia` options are deprecated. `hardware.nvidia-container-toolkit.enable` should be used instead. This option will expose GPUs on containers with the `--device` CLI option. This is supported by Docker 25, Podman 3.2.0 and Singularity 4. Any container runtime that supports the CDI specification will take advantage of this feature.

- `virtialisation.incus` now defaults to the newly-added `incus-lts` release (v6.0.x). Users who wish to continue using the non-LTS release will need to set `virtualisation.incus.package = pkgs.incus`. Stable release users are encouraged to stay on the LTS release as non-LTS releases will by default not be backported.

- `woodpecker-*` packages have been updated to v2 which includes [breaking changes](https://woodpecker-ci.org/docs/next/migrations#200).

- `wpaperd` has been updated to 1.0.1, which has a breaking change: previous version 0.3.0 had 2 different configuration files, one for wpaperd and one for the wallpapers. Remove the former and move the latter (`wallpaper.toml`) to `config.toml`.

- `writeReferencesToFile` is deprecated in favour of the new trivial build helper `writeClosure`. The latter accepts a list of paths and has an unambiguous name and cleaner implementation.

- `xfsprogs` was updated to version 6.6.0, which enables reverse mapping (rmapbt) and large extent counts (nrext64) by default.
   Support for these features was added in kernel 4.9 and 5.19 and nrext64 was deemed stable in kernel 6.5.
   Format your filesystems with `mkfs.xfs -i nrext64=0`, if they need to be readable by GRUB2 before 2.12 or kernels older than 5.19.

- `xxd` has been moved from `vim` default output to its own output to reduce closure size. The canonical way to reference it across all platforms is `unixtools.xxd`.

- `youtrack` was bumped to 2023.3. The update is not performed automatically, it requires manual interaction. See the YouTrack section in the manual for details.

- Ada packages (libraries and tools) have been moved into the `gnatPackages` scope. `gnatPackages` uses the default GNAT compiler, `gnat12Packages` and `gnat13Packages` use the respective matching compiler version.

- Paths provided as `restartTriggers` and `reloadTriggers` for systemd units will now be copied into the Nix store to make the behavior consistent.
  Previously, `restartTriggers = [ ./config.txt ]`, if defined in a flake, would trigger a restart when any part of the flake changed; and if not defined in a flake, would never trigger a restart even if the contents of `config.txt` changed.

- A warning has been added for services that are
  `after = [ "network-online.target" ]` but do not depend on it (e.g. using
  `wants`), because the dependency that `multi-user.target` has on
  `network-online.target` is planned for removal.

- switch-to-configuration does not directly call systemd-tmpfiles anymore.
  Instead, the new artificial sysinit-reactivation.target is introduced which
  allows to restart multiple services that are ordered before sysinit.target
  and respect the ordering between the services.

- `services.prometheus.exporters.snmp`'s configuration format changed with release 0.23.0.
  The module now includes an optional config check, that is enabled by default, to make the change obvious before any deployment.
  More information about the configuration syntax change is available in the [upstream repository](https://github.com/prometheus/snmp_exporter/blob/b75fc6b839ee3f3ccbee68bee55f1ae99555084a/auth-split-migration.md).

## Other Notable Changes {#sec-release-24.05-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `addDriverRunpath` has been added to facilitate the deprecation of the old `addOpenGLRunpath` setuphook. This change is motivated by the evolution of the setuphook to include all hardware acceleration.

- `appimage`, `appimageTools.wrapAppImage` and `buildFHSEnvBubblewrap` now properly accept `pname` and `version`.

- `bacula` now allows to configure `TLS` for encrypted communication.

- `boot.initrd.network.ssh.authorizedKeyFiles` is a new option in the initrd ssh daemon module, for adding authorized keys via list of files.

- `boot.kernel.sysctl."net.core.wmem_max"` changed from a string to an integer because of the addition of a custom merge option (taking the highest value defined to avoid conflicts between 2 services trying to set that value), just as `boot.kernel.sysctl."net.core.rmem_max"` since 22.11.

- `boot.loader.systemd-boot.xbootldrMountPoint` is a new option for setting up a separate [XBOOTLDR partition](https://uapi-group.org/specifications/specs/boot_loader_specification/) to store boot files. Useful on systems with a small EFI System partition that cannot be easily repartitioned.

- `boot.loader.systemd-boot` will now verify that `efiSysMountPoint` (and `xbootldrMountPoint` if configured) are mounted partitions.

- `buildDubPackage` can now be used to build Programs written in [D](https://dlang.org/) using the `dub` build system and package manager.
  See the [D section](https://nixos.org/manual/nixpkgs/unstable#dlang) in the manual for more information.

- `castopod` has some migration actions to be taken in case of a S3 setup. Some new features may also need some manual migration actions. See [https://code.castopod.org/adaures/castopod/-/releases](https://code.castopod.org/adaures/castopod/-/releases) for more information.

- `documentation.man.mandoc` now, by default, uses `MANPATH` to set the directories where mandoc will search for manual pages.
  This enables mandoc to find manual pages in Nix profiles. To set the manual search paths via the `mandoc.conf` configuration file like before, use `documentation.man.mandoc.settings.manpath` instead.

- `drbd` out-of-tree Linux kernel driver has been added in version 9.2.7. With it the DRBD 9.x features can be used instead of the 8.x features provided by the 8.4.11 in-tree driver.

- `garage` has been updated to v1.x.x. Users should read the [upstream release notes](https://git.deuxfleurs.fr/Deuxfleurs/garage/releases/tag/v1.0.0) and follow the documentation when changing over their `services.garage.package` and performing this manual upgrade.

- `hardware.pulseaudio` module now sets permissions of pulse user home directory to 755 when running in systemWide mode. It fixes [issue 114399](https://github.com/NixOS/nixpkgs/issues/114399).

- `kavita` has been updated to 0.8.0, requiring a manual forced library scan on all libraries for migration. Refer to upstream's [release notes](https://github.com/Kareadita/Kavita/releases/tag/v0.8.0) for details.

- `krb5` module has been rewritten and moved to `security.krb5`, moving all options but `security.krb5.enable` and `security.krb5.package` into `security.krb5.settings`.

- `libass` now uses the native CoreText backend on Darwin, which may fix subtitle rendering issues with `mpv`, `ffmpeg`, etc.

- `libjxl` version was bumped from 0.8.2 to 0.9.1 [dropped support for the butteraugli API](https://github.com/libjxl/libjxl/pull/2576). You will no longer be able to set `enableButteraugli` on `libaom`.

- [`lilypond`](https://lilypond.org/index.html) and [`denemo`](https://www.denemo.org) are now compiled with Guile 3.0.

- `lxd` has been upgraded to v5.21.x, an LTS release. The LTS release is now the only supported LXD release. Users are encouraged to [migrate to Incus](https://linuxcontainers.org/incus/docs/main/howto/server_migrate_lxd/) for better support on NixOS.

- [`matrix-synapse`](https://element-hq.github.io/synapse/) homeserver module now supports configuring UNIX domain socket [`listeners`](#opt-services.matrix-synapse.settings.listeners) through the `path` option.
  The default replication worker on the main instance has been migrated away from TCP sockets to UNIX domain sockets.

- `mockgen` has changed to the [go.uber.org/mock](https://github.com/uber-go/mock) fork because [the original repository is no longer maintained](https://github.com/golang/mock#gomock).

- `mpich` now requires `withPm` to be a list, e.g. `"hydra:gforker"` becomes `[ "hydra" "gforker" ]`.

- `nextcloud-setup.service` no longer changes the group of each file and directory inside `/var/lib/nextcloud/{config,data,store-apps}` if one of these directories has the wrong owner group. This was part of transitioning the group used for `/var/lib/nextcloud`, but isn't necessary anymore.

- `oils-for-unix`, the oil shell's C++ version is now available. The Python version is still available as `oil`.

- `pkgsExtraHardening`, a new top-level package set, was added. This is a set of packages built with stricter hardening flags - those that have not yet received enough testing to be applied universally, those that are more likely to cause build failures or those that have drawbacks to their use (e.g. performance or required hardware features).

- [`portunus`](https://github.com/majewsky/portunus) has been updated to major version 2.
  This version of Portunus supports strong password hashes, but the legacy hash SHA-256 is also still supported to ensure a smooth migration of existing user accounts.
  After upgrading, follow the instructions on the [upstream release notes](https://github.com/majewsky/portunus/releases/tag/v2.0.0) to upgrade all user accounts to strong password hashes.
  Support for weak password hashes will be removed in NixOS 24.11.

- `programs.fish.package` now allows you to override the package used in the `fish` module.

- `qt6.qtmultimedia` has changed its default backend to `QT_MEDIA_BACKEND=ffmpeg` (previously `gstreamer` on Linux or `darwin` on macOS).
  The previous native backends remain available but are now minimally maintained. Refer to [upstream documentation](https://doc.qt.io/qt-6/qtmultimedia-index.html#ffmpeg-as-the-default-backend) for further details about each platform.

- `services.btrbk` now automatically selects and provides required compression
  program depending on the configured `stream_compress` option.

- `services.github-runner` module has been removed. To configure a single GitHub Actions Runner refer to `services.github-runners.*`. Note that this will trigger a new runner registration.

- `services.networkmanager.extraConfig` was renamed to `services.networkmanager.settings` and changed to use the ini type instead of using a multiline string.

- `services.nextcloud.config.dbport` option of the Nextcloud module was removed to match upstream.
  The port can be specified in [`services.nextcloud.config.dbhost`](#opt-services.nextcloud.config.dbhost).

- `services.kavita` now uses the free-form option `services.kavita.settings` for the application settings file.
  The options `services.kavita.ipAdresses` and `services.kavita.port` now exist at `services.kavita.settings.IpAddresses`
  and `services.kavita.settings.IpAddresses`. The file at `services.kavita.tokenKeyFile` now needs to contain a secret with
  512+ bits instead of 128+ bits.

- `services.netbird` now allows running multiple tunnels in parallel through [`services.netbird.tunnels`](#opt-services.netbird.tunnels).

- `services.nginx.virtualHosts` using `forceSSL` or
  `globalRedirect` can now have redirect codes other than 301 through `redirectCode`.

- `services.openssh` now has an option `authorizedKeysInHomedir`, controlling whether `~/.ssh/authorizedKeys` is
  added to `authorizedKeysFiles`.
  ::: {.note}
  This option currently defaults to `true` for NixOS 24.05, preserving the previous behaviour.
  This is expected to change in NixOS 24.11.
  :::
  ::: {.warning}
  Users should check that their SSH keys are in `users.users.*.openssh`, or that they have another way to access
  and administer the system, before setting this option to `false`.
  :::

- `services.paperless` module no longer uses the previously downloaded NLTK data stored in `/var/cache/paperless/nltk`. This directory can be removed.

- `services.postgresql.extraPlugins`' type has expanded. Previously it was a list of packages, now it can also be a function that returns such a list.
  For example a config line like ``services.postgresql.extraPlugins = with pkgs.postgresql_11.pkgs; [ postgis ];`` is recommended to be changed to ``services.postgresql.extraPlugins = ps: with ps; [ postgis ];``;

- `services.slskd` has been refactored to include more configuration options in
  the free-form `services.slskd.settings` option, and some defaults (including listen ports)
  have been changed to match the upstream defaults. Additionally, disk logging is now
  disabled by default, and the log rotation timer has been removed.
  The nginx virtualhost option is now of the `vhost-options` type.

- `services.soju` now has a wrapper for the `sojuctl` command, pointed at the service config file. It also has the new option `adminSocket.enable`, which creates a unix admin socket at `/run/soju/admin`.

- `services.stalwart-mail` uses the legacy version 0.6.X as default because newer `stalwart-mail` versions require a [manual upgrade process](https://github.com/stalwartlabs/mail-server/blob/main/UPGRADING.md). Change [`services.stalwart-mail.package`](#opt-services.stalwart-mail.package) to `pkgs.stalwart-mail` if you wish to switch to the new version.

- `services.teeworlds` module now has a wealth of configuration options, including a new `package` option.

- `services.xserver.desktopManager.budgie` installs `gnome.gnome-terminal` by default (instead of `mate.mate-terminal`).

- `services.zfs.zed.enableMail` now uses the global `sendmail` wrapper defined by an email module
  (such as msmtp or Postfix). It no longer requires using a special ZFS build with email support.

- `sonarr` version was bumped to from 3.0.10 to 4.0.3. Consequently existing config database files will be upgraded automatically, but note that some old apparently-working configs [might actually be corrupt and fail to upgrade cleanly](https://forums.sonarr.tv/t/sonarr-v4-released/33089).

- `stdenv`: The `--replace` flag in `substitute`, `substituteInPlace`, `substituteAll`, `substituteAllStream`, and `substituteStream` is now deprecated if favor of the new `--replace-fail`, `--replace-warn` and `--replace-quiet`. The deprecated `--replace` equates to `--replace-warn`.

- `systemd`: when merging unit options (of type `unitOption`),
  if at least one definition is a list, all those which aren't are now lifted into a list,
  making it possible to accumulate definitions without resorting to `mkForce`,
  hence to retain the definitions not anticipating that need.

- `systemd` units can now specify the `Upholds=` and `UpheldBy=` unit dependencies via the aptly
  named `upholds` and `upheldBy` options. These options get systemd to enforce that the
  dependencies remain continuously running for as long as the dependent unit is in a running state.

- A stdenv's default set of hardening flags can now be set via its `bintools-wrapper`'s `defaultHardeningFlags` argument. A convenient stdenv adapter, `withDefaultHardeningFlags`, can be used to override an existing stdenv's `defaultHardeningFlags`.

- Programs written in [Nim](https://nim-lang.org/) are built with libraries selected by lockfiles.
  The `nimPackages` and `nim2Packages` sets have been removed.
  See https://nixos.org/manual/nixpkgs/unstable#nim for more information.

- The EC2 image module now enables the [Amazon SSM Agent](https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html) by default.

- A new abstraction to create both read-only as well as writable overlay file
  systems was added. Available via
  [fileSystems.overlay](#opt-fileSystems._name_.overlay.lowerdir). See also the
  [NixOS docs](#sec-overlayfs).

- A new hardening flag, `zerocallusedregs` was made available, corresponding to the gcc/clang option `-fzero-call-used-regs=used-gpr`.

- A new hardening flag, `trivialautovarinit` was made available, corresponding to the gcc/clang option `-ftrivial-auto-var-init=pattern`.

- `dnsdist` has new options to enable and configure a DNSCrypt endpoint (see `services.dnsdist.dnscrypt.enable`, etc.).
  The module can generate the DNSCrypt provider key pair and certificates, and also rotates them automatically with no downtime.

- The kernel Yama LSM is now enabled by default, which prevents ptracing
  non-child processes. This means you will not be able to attach gdb to an
  existing process, but will need to start that process from gdb (so it is a
  child). Or you can set `boot.kernel.sysctl."kernel.yama.ptrace_scope"` to 0.

- Lisp modules: previously deprecated interface based on `common-lisp.sh` has now been removed.

- The `systemd-confinement` module extension is now compatible with `DynamicUser=true` and thus `ProtectSystem=strict` too.


## Nixpkgs Library {#sec-release-24.05-nixpkgs-lib}

### Additions and Improvements {#sec-release-24.05-lib-additions-improvements}

New functions:
- [`lib.asserts.assertEachOneOf`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.asserts.assertEachOneOf): Check that each value is one of the allowed ones.
- [`lib.attrsets.longestValidPathPrefix`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.attrsets.longestValidPathPrefix): The longest prefix of an attribute path that refers to an existing attribute in a nesting of attribute sets.
- [`lib.attrsets.mapCartesianProduct`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.attrsets.mapCartesianProduct): Apply a function to the cartesian product of attribute set value combinations.
- [`lib.trivial.xor`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.trivial.xor): Boolean "exclusive or"
- [`lib.lists.ifilter0`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.lists.ifilter0): Filter a list for elements that satisfy a predicate function. The predicate function is called with both the index and value for each element.
- [`lib.lists.sortOn`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.lists.sortOn): Sort a list based on the default comparison of a derived property.
- [`lib.path.hasStorePathPrefix`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.path.hasStorePathPrefix): Whether a [path](https://nixos.org/manual/nix/stable/language/values.html#type-path) has a [store path](https://nixos.org/manual/nix/stable/store/store-path.html#store-path) as a prefix.
- [`lib.filesystem.packagesFromDirectoryRecursive`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.filesystem.packagesFromDirectoryRecursive): Transform a directory tree containing package files suitable for `callPackage` into a matching nested attribute set of derivations.
- [`lib.fileset.toList`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.fileset.toList): The list of file paths contained in a given file set.
- [`lib.fileset.maybeMissing`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.fileset.maybeMissing): Create a file set from a path that may or may not exist.
- [`lib.derivations.optionalDrvAttr`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.derivations.optionalDrvAttr): Conditionally set a derivation attribute.
- [`lib.strings.makeIncludePath`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.strings.makeIncludePath): Construct an include search path (such as `C_INCLUDE_PATH`) containing the header files for a set of packages or paths.

Improvements:
- [`lib.fixedPoints.extends`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.fixedPoints.extends): Better documentation
- [`lib.customisation.makeScope`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.customisation.makeScope): Better documentation
- [`lib.derivations.lazyDerivation`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.derivations.lazyDerivation): Now supports multiple outputs with an `outputs` argument
- [`lib.gvariant`](https://nixos.org/manual/nixpkgs/unstable#sec-functions-library-gvariant): Better error message for integers and attribute set values
- [`lib.filesets.gitTracked`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.fileset.gitTracked): Now works within store paths

Misc:
- The [`lib/` directory](https://github.com/NixOS/nixpkgs/tree/release-24.05/lib) is a self-contained flake now, including a working [`lib.trivial.version`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.version) (but note that fetching a subtree by itself is not supported in Nix yet)
- [Various minor performance improvements](https://github.com/NixOS/nixpkgs/issues?q=author%3Aadisbladis+label%3A%226.topic%3A+lib%22+created%3A%3C2024-05-31+)

Module System:
- New types:
  - [`types.attrTag`](https://nixos.org/manual/nixos/unstable/#sec-option-types-sums): A tagged union type
  - `types.nonEmptyListOf`: A non-empty list
- Improved types:
  - `types.uniq`/`unique` now check the wrapped type

### Deprecations {#sec-release-24.05-lib-deprecations}

- [`lib.options.mdDoc`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.options.mdDoc) is obsolete and now emits a warning. The core ecosystem has completely migrated to markdown, so marking markdown as markdown is redundant.
- `lib.attrsets.zipWithNames` is now a deprecated alias of [`lib.attrsets.zipAttrsWithNames`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.attrsets.zipAttrsWithNames)
- `lib.attrsets.cartesianProductOfSets` has been renamed to [`lib.attrsets.cartesianProduct`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.attrsets.cartesianProduct)

### Internal {#sec-release-24.05-lib-internal}
- `lib` now has [Readme for contributing](https://github.com/NixOS/nixpkgs/tree/master/lib#readme).
- Some function's documentation is now written using the [accepted doc comment syntax](https://github.com/NixOS/rfcs/pull/145).
- `odoo` has been updated from `16.0.20231024` to `17.0.20240507`.
