# generated by zon2nix (https://github.com/Cloudef/zig2nix)

{
  lib,
  linkFarm,
  fetchurl,
  fetchgit,
  runCommandLocal,
  zig,
  name ? "zig-packages",
}:

with builtins;
with lib;

let
  unpackZigArtifact =
    { name, artifact }:
    runCommandLocal name
      {
        nativeBuildInputs = [ zig ];
      }
      ''
        hash="$(zig fetch --global-cache-dir "$TMPDIR" ${artifact})"
        mv "$TMPDIR/p/$hash" "$out"
        chmod 755 "$out"
      '';

  fetchZig =
    {
      name,
      url,
      hash,
    }:
    let
      artifact = fetchurl { inherit url hash; };
    in
    unpackZigArtifact { inherit name artifact; };

  fetchGitZig =
    {
      name,
      url,
      hash,
    }:
    let
      parts = splitString "#" url;
      url_base = elemAt parts 0;
      url_without_query = elemAt (splitString "?" url_base) 0;
      rev_base = elemAt parts 1;
      rev = if match "^[a-fA-F0-9]{40}$" rev_base != null then rev_base else "refs/heads/${rev_base}";
    in
    fetchgit {
      inherit name rev hash;
      url = url_without_query;
      deepClone = false;
    };

  fetchZigArtifact =
    {
      name,
      url,
      hash,
    }:
    let
      parts = splitString "://" url;
      proto = elemAt parts 0;
      path = elemAt parts 1;
      fetcher = {
        "git+http" = fetchGitZig {
          inherit name hash;
          url = "http://${path}";
        };
        "git+https" = fetchGitZig {
          inherit name hash;
          url = "https://${path}";
        };
        http = fetchZig {
          inherit name hash;
          url = "http://${path}";
        };
        https = fetchZig {
          inherit name hash;
          url = "https://${path}";
        };
      };
    in
    fetcher.${proto};
in
linkFarm name [
  {
    name = "1220930a42f8da3fb7f723e3ad3f6dcc6db76327dd8d26274566423192d53e91b2bb";
    path = fetchZigArtifact {
      name = "flags";
      url = "https://github.com/n0s4/flags/archive/b3905aa990719ff567f1c5a2f89e6dd3292d8533.tar.gz";
      hash = "sha256-2lN2goQgjU5Hf18tvDV/csS83A20nA9Iu2/fKXtpZok=";
    };
  }
  {
    name = "1220d0fb2bff7b453dbb39d1db3eb472b6680e2564f2b23b0e947671be47bbdd188f";
    path = fetchZigArtifact {
      name = "tracy";
      url = "https://github.com/neurocyte/zig-tracy/archive/e04e31c64498149a324491b8534758e6af43a5c2.tar.gz";
      hash = "sha256-otvs9tKc8zMRFng0VJDn5iNf7lvbozjrtH0q8IFnP0w=";
    };
  }
  {
    name = "122051b30656170b4628580e571d98b1fe45d7c0d581bc2d45e894c75c6376294ede";
    path = fetchZigArtifact {
      name = "tracy_src";
      url = "https://github.com/neurocyte/tracy/archive/0ff0a1b324f497cf313a445637b7df25aabefb47.tar.gz";
      hash = "sha256-dzMilJsOSdjNyvhyDb1v5dPWcR5uvhnQmsBynAJH74I=";
    };
  }
  {
    name = "1220220dbc7fe91c1c54438193ca765cebbcb7d58f35cdcaee404a9d2245a42a4362";
    path = fetchZigArtifact {
      name = "dizzy";
      url = "https://github.com/neurocyte/dizzy/archive/455d18369cbb2a0458ba70be919cd378338d695e.tar.gz";
      hash = "sha256-PKCqS8/sEieEA3ZONEsBHq+am02JRHG9waYzn2GnYgI=";
    };
  }
  {
    name = "1220bbfd147f41fa49d2e5406096f3529c62e9335f4d2a89ae381e679a76ce398f1f";
    path = fetchZigArtifact {
      name = "thespian";
      url = "https://github.com/neurocyte/thespian/archive/db3ad5f45e707a04eaa51aa657995abe43ce967a.tar.gz";
      hash = "sha256-La5pv08xPAnkNxBHjpTmLpKxrcifRFWcqm8NYp92iRA=";
    };
  }
  {
    name = "1220c85e0d9438ec518849c84e3ea66633a0e191e49c4ae4bbb3bc46626cd8dfad75";
    path = fetchZigArtifact {
      name = "asio";
      url = "https://github.com/neurocyte/asio/archive/b9c9c23ef2e6f11b6123535ec33e5a23ed0c59da.tar.gz";
      hash = "sha256-tD9lxE6RRAptBE9suZA4ANpT5x/B3e4YINay9Se78XY=";
    };
  }
  {
    name = "1220e4f3baf09dc23e48616f7dbf00bd45c3034faa2eddede7bb45ef4c23a19b962b";
    path = fetchZigArtifact {
      name = "themes";
      url = "https://github.com/neurocyte/flow-themes/releases/download/master-8b79cf6d79373c142393ec26a81b19f4701f4372/flow-themes.tar.gz";
      hash = "sha256-xy0cTVc85U6JpI+oca2XKXE7GAs0EId21DeQCDa8+n0=";
    };
  }
  {
    name = "122019f077d09686b1ec47928ca2b4bf264422f3a27afc5b49dafb0129a4ceca0d01";
    path = fetchZigArtifact {
      name = "fuzzig";
      url = "https://github.com/fjebaker/fuzzig/archive/0fd156d5097365151e85a85eef9d8cf0eebe7b00.tar.gz";
      hash = "sha256-XVOKqHX2X8HvRDJgnqVEPN/A0hFvCk8Fgsss0CKInYQ=";
    };
  }
  {
    name = "12207e33747072d878fce61f587c133124dc95f4ae8aab7d2b3f467699586af07c77";
    path = fetchZigArtifact {
      name = "vaxis";
      url = "https://github.com/neurocyte/libvaxis/archive/d899244bc0a3775b59c18e90eb41acee11675f96.tar.gz";
      hash = "sha256-8bK0zM6rD/mqTaHDZKMgS3+qV1VviImM9jr9D0lkPdw=";
    };
  }
  {
    name = "1220dd654ef941fc76fd96f9ec6adadf83f69b9887a0d3f4ee5ac0a1a3e11be35cf5";
    path = fetchZigArtifact {
      name = "zigimg";
      url = "git+https://github.com/zigimg/zigimg#3a667bdb3d7f0955a5a51c8468eac83210c1439e";
      hash = "sha256-oLf3YH3yeg4ikVO/GahMCDRMTU31AHkfSnF4rt7xTKo=";
    };
  }
  {
    name = "122055beff332830a391e9895c044d33b15ea21063779557024b46169fb1984c6e40";
    path = fetchZigArtifact {
      name = "zg";
      url = "https://github.com/neurocyte/zg/archive/refs/tags/v0.13.2.tar.gz";
      hash = "sha256-Hd8HlYEkkA/2BLW+4d/0Ibw7r7U533us3n2QR+XG/PQ=";
    };
  }
  {
    name = "1220755ea2a5aa6bb3713437aaafefd44812169fe43f1da755c3ee6101b85940f441";
    path = fetchZigArtifact {
      name = "zeit";
      url = "https://github.com/rockorager/zeit/archive/9cca8ec620a54c3b07cd249f25e5bcb3153d03d7.tar.gz";
      hash = "sha256-4bxyQKbVUtYzZixUq2d+iiSPGkcwg+dG4WLaDYYQzn8=";
    };
  }
  {
    name = "1220925614447b54ccc9894bbba8b202c6a8b750267890edab7732064867e46f3217";
    path = fetchZigArtifact {
      name = "win32";
      url = "https://github.com/marlersoft/zigwin32/archive/259b6f353a48968d7e3171573db4fd898b046188.tar.gz";
      hash = "sha256-N9Jp2vmq1+xPWByb+VZkbS2lm9FCrUW4UBAPhSP+dUw=";
    };
  }
  {
    name = "1220f9702ca6257f5464b31e576b1e92b0f441bf0e61733c4a2fbf95b7c0c55a3e22";
    path = fetchZigArtifact {
      name = "tree-sitter";
      url = "https://github.com/neurocyte/tree-sitter/releases/download/master-69775ce3ba8a5e331bba9feb760d1ba31394eea7/source.tar.gz";
      hash = "sha256-0ZLcPuhUV6Z3EsXfU7gXRrG/nRP9zuLRSL00Q5OGnus=";
    };
  }
]
