typedef struct {
        uint32_t   id;
        const char *name;
} kd_event_t;
kd_event_t kd_events[] = {
        {0x1020000, "KTrap_DivideError"},
        {0x1020004, "KTrap_Debug"},
        {0x1020008, "KTrap_NMI"},
        {0x102000c, "KTrap_Int3"},
        {0x1020010, "KTrap_Overflow"},
        {0x1020014, "KTrap_BoundRange"},
        {0x1020018, "KTrap_InvalidOpcode"},
        {0x102001c, "KTrap_DeviceNotAvail"},
        {0x1020020, "KTrap_DoubleFault"},
        {0x1020024, "KTrap_Coprocessor"},
        {0x1020028, "KTrap_InvalidTSS"},
        {0x102002c, "KTrap_SegmentNotPresent"},
        {0x1020030, "KTrap_StackFault"},
        {0x1020034, "KTrap_GeneralProtection"},
        {0x1020038, "KTrap_PageFault"},
        {0x102003c, "KTrap_unknown"},
        {0x1020040, "KTrap_FloatPointError"},
        {0x1020044, "KTrap_AlignmentCheck"},
        {0x1020048, "KTrap_MachineCheck"},
        {0x102004c, "KTrap_SIMD_FP"},
        {0x10203fc, "KTrap_Preempt"},
        {0x1050000, "INTERRUPT"},
        {0x1070000, "UTrap_DivideError"},
        {0x1070004, "UTrap_Debug"},
        {0x1070008, "UTrap_NMI"},
        {0x107000c, "UTrap_Int3"},
        {0x1070010, "UTrap_Overflow"},
        {0x1070014, "UTrap_BoundRange"},
        {0x1070018, "UTrap_InvalidOpcode"},
        {0x107001c, "UTrap_DeviceNotAvail"},
        {0x1070020, "UTrap_DoubleFault"},
        {0x1070024, "UTrap_Coprocessor"},
        {0x1070028, "UTrap_InvalidTSS"},
        {0x107002c, "UTrap_SegmentNotPresent"},
        {0x1070030, "UTrap_StackFault"},
        {0x1070034, "UTrap_GeneralProtection"},
        {0x1070038, "UTrap_PageFault"},
        {0x107003c, "UTrap_unknown"},
        {0x1070040, "UTrap_FloatPointError"},
        {0x1070044, "UTrap_AlignmentCheck"},
        {0x1070048, "UTrap_MachineCheck"},
        {0x107004c, "UTrap_SIMD_FP"},
        {0x1090000, "DecrTrap"},
        {0x1090004, "DecrSet"},
        {0x1090008, "TMR_TimerCallIntr"},
        {0x109000c, "TMR_pmsStep"},
        {0x1090010, "TMR_TimerMigration"},
        {0x1090014, "TMR_rdHPET"},
        {0x1090018, "TMR_set_tsc_deadline"},
        {0x109001c, "TMR_TimerCallEnter"},
        {0x1090020, "TMR_TimerCallCancel"},
        {0x1090024, "TMR_TimerQueue"},
        {0x1090028, "TMR_TimerCallExpire"},
        {0x109002c, "TMR_AsyncDequeue"},
        {0x1090030, "TMR_TimerUpdate"},
        {0x1090034, "TMR_TimerEscalate"},
        {0x1090038, "TMR_TimerOverdue"},
        {0x109003c, "TMR_Rescan"},
        {0x1090040, "TMR_set_apic_deadline"},
        {0x10c0000, "MACH_SysCall"},
        {0x10c0004, "MSC_kern_invalid_#1"},
        {0x10c0008, "MSC_kern_invalid_#2"},
        {0x10c000c, "MSC_kern_invalid_#3"},
        {0x10c0010, "MSC_kern_invalid_#4"},
        {0x10c0014, "MSC_kern_invalid_#5"},
        {0x10c0018, "MSC_kern_invalid_#6"},
        {0x10c001c, "MSC_kern_invalid_#7"},
        {0x10c0020, "MSC_kern_invalid_#8"},
        {0x10c0024, "MSC_kern_invalid_#9"},
        {0x10c0028, "MSC_mach_vm_allocate_trap"},
        {0x10c002c, "MSC_kern_invalid_#11"},
        {0x10c0030, "MSC_mach_vm_deallocate_trap"},
        {0x10c0034, "MSC_kern_invalid_#13"},
        {0x10c0038, "MSC_mach_vm_protect_trap"},
        {0x10c003c, "MSC_mach_vm_map_trap"},
        {0x10c0040, "MSC_mach_port_allocate_trap"},
        {0x10c0044, "MSC_mach_port_destroy_trap"},
        {0x10c0048, "MSC_mach_port_deallocate_trap"},
        {0x10c004c, "MSC_mach_port_mod_refs_trap"},
        {0x10c0050, "MSC_mach_port_move_member_trap"},
        {0x10c0054, "MSC_mach_port_insert_right_trap"},
        {0x10c0058, "MSC_mach_port_insert_member_trap"},
        {0x10c005c, "MSC_mach_port_extract_member_trap"},
        {0x10c0060, "MSC_mach_port_construct_trap"},
        {0x10c0064, "MSC_mach_port_destruct_trap"},
        {0x10c0068, "MSC_mach_reply_port"},
        {0x10c006c, "MSC_thread_self_trap"},
        {0x10c0070, "MSC_task_self_trap"},
        {0x10c0074, "MSC_host_self_trap"},
        {0x10c0078, "MSC_kern_invalid_#30"},
        {0x10c007c, "MSC_mach_msg_trap"},
        {0x10c0080, "MSC_mach_msg_overwrite_trap"},
        {0x10c0084, "MSC_semaphore_signal_trap"},
        {0x10c0088, "MSC_semaphore_signal_all_trap"},
        {0x10c008c, "MSC_semaphore_signal_thread_trap"},
        {0x10c0090, "MSC_semaphore_wait_trap"},
        {0x10c0094, "MSC_semaphore_wait_signal_trap"},
        {0x10c0098, "MSC_semaphore_timedwait_trap"},
        {0x10c009c, "MSC_semaphore_timedwait_signal_trap"},
        {0x10c00a0, "MSC_kern_invalid_#40"},
        {0x10c00a4, "MSC_mach_port_guard_trap"},
        {0x10c00a8, "MSC_mach_port_unguard_trap"},
        {0x10c00ac, "MSC_mach_generate_activity_id"},
        {0x10c00b0, "MSC_task_name_for_pid"},
        {0x10c00b4, "MSC_task_for_pid"},
        {0x10c00b8, "MSC_pid_for_task"},
        {0x10c00bc, "MSC_kern_invalid_#47"},
        {0x10c00c0, "MSC_macx_swapon"},
        {0x10c00c4, "MSC_macx_swapoff"},
        {0x10c00c8, "MSC_kern_invalid_#50"},
        {0x10c00cc, "MSC_macx_triggers"},
        {0x10c00d0, "MSC_macx_backing_store_suspend"},
        {0x10c00d4, "MSC_macx_backing_store_recovery"},
        {0x10c00d8, "MSC_kern_invalid_#54"},
        {0x10c00dc, "MSC_kern_invalid_#55"},
        {0x10c00e0, "MSC_kern_invalid_#56"},
        {0x10c00e4, "MSC_kern_invalid_#57"},
        {0x10c00e8, "MSC_pfz_exit"},
        {0x10c00ec, "MSC_swtch_pri"},
        {0x10c00f0, "MSC_swtch"},
        {0x10c00f4, "MSC_thread_switch"},
        {0x10c00f8, "MSC_clock_sleep_trap"},
        {0x10c00fc, "MSC_kern_invalid_#63"},
        {0x10c0100, "MSC_kern_invalid_#64"},
        {0x10c0104, "MSC_kern_invalid_#65"},
        {0x10c0108, "MSC_kern_invalid_#66"},
        {0x10c010c, "MSC_kern_invalid_#67"},
        {0x10c0110, "MSC_kern_invalid_#68"},
        {0x10c0114, "MSC_kern_invalid_#69"},
        {0x10c0118, "MSC_host_create_mach_voucher_trap"},
        {0x10c011c, "MSC_kern_invalid_#71"},
        {0x10c0120, "MSC_mach_voucher_extract_attr_recipe_trap"},
        {0x10c0124, "MSC_kern_invalid_#73"},
        {0x10c0128, "MSC_kern_invalid_#74"},
        {0x10c012c, "MSC_kern_invalid_#75"},
        {0x10c0130, "MSC_kern_invalid_#76"},
        {0x10c0134, "MSC_kern_invalid_#77"},
        {0x10c0138, "MSC_kern_invalid_#78"},
        {0x10c013c, "MSC_kern_invalid_#79"},
        {0x10c0140, "MSC_kern_invalid_#80"},
        {0x10c0144, "MSC_kern_invalid_#81"},
        {0x10c0148, "MSC_kern_invalid_#82"},
        {0x10c014c, "MSC_kern_invalid_#83"},
        {0x10c0150, "MSC_kern_invalid_#84"},
        {0x10c0154, "MSC_kern_invalid_#85"},
        {0x10c0158, "MSC_kern_invalid_#86"},
        {0x10c015c, "MSC_kern_invalid_#87"},
        {0x10c0160, "MSC_kern_invalid_#88"},
        {0x10c0164, "MSC_mach_timebase_info"},
        {0x10c0168, "MSC_mach_wait_until"},
        {0x10c016c, "MSC_mk_timer_create"},
        {0x10c0170, "MSC_mk_timer_destroy"},
        {0x10c0174, "MSC_mk_timer_arm"},
        {0x10c0178, "MSC_mk_timer_cancel"},
        {0x10c017c, "MSC_mk_timer_arm_leeway"},
        {0x10c0180, "MSC_kern_invalid_#96"},
        {0x10c0184, "MSC_kern_invalid_#97"},
        {0x10c0188, "MSC_kern_invalid_#98"},
        {0x10c018c, "MSC_kern_invalid_#99"},
        {0x10c0190, "MSC_iokit_user_client"},
        {0x10c0194, "MSC_kern_invalid_#101"},
        {0x10c0198, "MSC_kern_invalid_#102"},
        {0x10c019c, "MSC_kern_invalid_#103"},
        {0x10c01a0, "MSC_kern_invalid_#104"},
        {0x10c01a4, "MSC_kern_invalid_#105"},
        {0x10c01a8, "MSC_kern_invalid_#106"},
        {0x10c01ac, "MSC_kern_invalid_#107"},
        {0x10c01b0, "MSC_kern_invalid_#108"},
        {0x10c01b4, "MSC_kern_invalid_#109"},
        {0x10c01b8, "MSC_kern_invalid_#110"},
        {0x10c01bc, "MSC_kern_invalid_#111"},
        {0x10c01c0, "MSC_kern_invalid_#112"},
        {0x10c01c4, "MSC_kern_invalid_#113"},
        {0x10c01c8, "MSC_kern_invalid_#114"},
        {0x10c01cc, "MSC_kern_invalid_#115"},
        {0x10c01d0, "MSC_kern_invalid_#116"},
        {0x10c01d4, "MSC_kern_invalid_#117"},
        {0x10c01d8, "MSC_kern_invalid_#118"},
        {0x10c01dc, "MSC_kern_invalid_#119"},
        {0x10c01e0, "MSC_kern_invalid_#120"},
        {0x10c01e4, "MSC_kern_invalid_#121"},
        {0x10c01e8, "MSC_kern_invalid_#122"},
        {0x10c01ec, "MSC_kern_invalid_#123"},
        {0x10c01f0, "MSC_kern_invalid_#124"},
        {0x10c01f4, "MSC_kern_invalid_#125"},
        {0x10c01f8, "MSC_kern_invalid_#126"},
        {0x10c01fc, "MSC_kern_invalid_#127"},
        {0x1200000, "MACH_task_suspend"},
        {0x1200004, "MACH_task_resume"},
        {0x1200008, "MACH_thread_set_voucher"},
        {0x120000c, "MACH_IPC_msg_send"},
        {0x1200010, "MACH_IPC_msg_recv"},
        {0x1200014, "MACH_IPC_msg_recv_voucher_refused"},
        {0x1200018, "MACH_IPC_kmsg_free"},
        {0x120001c, "MACH_IPC_voucher_create"},
        {0x1200020, "MACH_IPC_voucher_create_attr_data"},
        {0x1200024, "MACH_IPC_voucher_destroy"},
        {0x1200028, "MACH_IPC_kmsg_info"},
        {0x120002c, "MACH_IPC_kmsg_link"},
        {0x1250008, "MACH_RMON_CPUUSAGE_VIOLATED"},
        {0x1250010, "MACH_RMON_CPUUSAGE_VIOLATED_K32A"},
        {0x1250014, "MACH_RMON_CPUUSAGE_VIOLATED_K32B"},
        {0x1250048, "MACH_RMON_CPUWAKES_VIOLATED"},
        {0x1250050, "MACH_RMON_CPUWAKES_VIOLATED_K32A"},
        {0x1250054, "MACH_RMON_CPUWAKES_VIOLATED_K32B"},
        {0x1250088, "MACH_RMON_LOGWRITES_VIOLATED"},
        {0x1250090, "MACH_RMON_LOGWRITES_VIOLATED_K32A"},
        {0x1250094, "MACH_RMON_LOGWRITES_VIOLATED_K32A"},
        {0x1300004, "MACH_Pageout"},
        {0x1300008, "MACH_vmfault"},
        {0x1300100, "MACH_purgable_token_add"},
        {0x1300104, "MACH_purgable_token_delete"},
        {0x1300108, "MACH_purgable_token_ripened"},
        {0x130010c, "MACH_purgable_token_purged"},
        {0x1300120, "MACH_purgable_object_add"},
        {0x1300124, "MACH_purgable_object_remove"},
        {0x1300128, "MACH_purgable_object_purge"},
        {0x130012c, "MACH_purgable_object_purge_all"},
        {0x1300150, "MACH_vm_map_partial_reap"},
        {0x1300400, "MACH_vm_check_zf_delay"},
        {0x1300404, "MACH_vm_cow_delay"},
        {0x1300408, "MACH_vm_zf_delay"},
        {0x130040c, "MACH_vm_compressor_delay"},
        {0x1300410, "MACH_vm_pageout_scan"},
        {0x1300414, "MACH_vm_pageout_balanceQ"},
        {0x1300418, "MACH_vm_pageout_freelist"},
        {0x130041c, "MACH_vm_pageout_purge_one"},
        {0x1300420, "MACH_vm_pageout_cache_evict"},
        {0x1300424, "MACH_vm_pageout_thread_block"},
        {0x1300428, "MACH_vm_pageout_jetsam"},
        {0x1300480, "MACH_vm_upl_page_wait"},
        {0x1300484, "MACH_vm_iopl_page_wait"},
        {0x1300488, "MACH_vm_page_wait_block"},
        {0x130048c, "MACH_vm_page_sleep"},
        {0x1300490, "MACH_vm_page_expedite"},
        {0x13004c0, "MACH_vm_pressure_event"},
        {0x1300500, "MACH_vm_data_write"},
        {0x1320000, "vm_disconnect_all_page_mappings"},
        {0x1320004, "vm_disconnect_task_page_mappings"},
        {0x1320008, "RealFaultAddressInternal"},
        {0x132000c, "RealFaultAddressPurgeable"},
        {0x1320010, "RealFaultAddressExternal"},
        {0x1320014, "RealFaultAddressSharedCache"},
        {0x1400000, "MACH_SCHED"},
        {0x1400004, "MACH_STKATTACH"},
        {0x1400008, "MACH_STKHANDOFF"},
        {0x140000c, "MACH_CALLCONT"},
        {0x1400010, "MACH_CALLOUT"},
        {0x1400014, "MACH_ServiceT"},
        {0x1400018, "MACH_MKRUNNABLE"},
        {0x140001c, "MACH_PROMOTE"},
        {0x1400020, "MACH_DEMOTE"},
        {0x1400024, "MACH_IDLE"},
        {0x1400028, "MACH_STACK_DEPTH"},
        {0x140002c, "MACH_MOVED"},
        {0x1400038, "MACH_FAILSAFE"},
        {0x140003c, "MACH_BLOCK"},
        {0x1400040, "MACH_WAIT"},
        {0x1400044, "MACH_SCHED_BT"},
        {0x1400048, "MACH_IDLE_BT"},
        {0x1400050, "MACH_SCHED_GET_URGENCY"},
        {0x1400054, "MACH_SCHED_URGENCY"},
        {0x1400058, "MACH_SCHED_REDISPATCH"},
        {0x140005c, "MACH_SCHED_REMOTE_AST"},
        {0x1400060, "MACH_SCHED_CHOOSE_PROCESSOR"},
        {0x1400064, "MACH_DEEP_IDLE"},
        {0x1400068, "MACH_SCHED_DECAY_PRIORITY"},
        {0x140006c, "MACH_CPU_THROTTLE_DISABLE"},
        {0x1400070, "MACH_RW_PROMOTE"},
        {0x1400074, "MACH_RW_DEMOTE"},
        {0x140007c, "MACH_SCHED_MAINTENANCE"},
        {0x1400080, "MACH_DISPATCH"},
        {0x1400084, "MACH_QUANTUM_HANDOFF"},
        {0x1400088, "MACH_MULTIQ_DEQUEUE"},
        {0x140008c, "MACH_SCHED_THREAD_SWITCH"},
        {0x1400094, "MACH_SCHED_REMOTE_DEFERRED_AST"},
        {0x1400098, "MACH_SCHED_REMOTE_CANCEL_AST"},
        {0x140009c, "MACH_SCHED_CHANGE_PRIORITY"},
        {0x14000a0, "MACH_SCHED_UPDATE_REC_CORES"},
        {0x14000a4, "MACH_STACK_WAIT"},
        {0x14000a8, "MACH_THREAD_BIND"},
        {0x14000ac, "MACH_WAITQ_PROMOTE"},
        {0x14000b0, "MACH_WAITQ_DEMOTE"},
        {0x14000b4, "MACH_SCHED_LOAD"},
        {0x14000b8, "MACH_REC_CORES_FAILSAFE"},
        {0x14000bc, "MACH_SCHED_QUANTUM_EXPIRED"},
        {0x1500000, "MACH_MSGID_INVALID"},
        {0x1600000, "MTX_SLEEP"},
        {0x1600004, "MTX_SLEEP_DEADLINE"},
        {0x1600008, "MTX_WAIT"},
        {0x160000c, "MTX_WAKEUP"},
        {0x1600010, "MTX_LOCK"},
        {0x1600014, "MTX_UNLOCK"},
        {0x1600080, "MTX_x86_wait"},
        {0x1600084, "MTX_x86_wakeup"},
        {0x1600088, "MTX_x86_spin"},
        {0x160008c, "MTX_x86_acquire"},
        {0x1600090, "MTX_x86_demote"},
        {0x1600200, "MTX_full_lock"},
        {0x1600400, "RW_EXCL_WaitForWriter"},
        {0x1600404, "RW_EXCL_WaitForReaders"},
        {0x1600408, "RW_SHRD_WaitForWriter"},
        {0x160040c, "RW_SHRDtoEXCL_FailedUpgrade"},
        {0x1600410, "RW_SHRDtoEXCL_WaitForReaders"},
        {0x1600414, "RW_EXCLtoSHRD"},
        {0x1600418, "RW_EXCL_SpinForWriter"},
        {0x160041c, "RW_EXCL_WaitForWriter"},
        {0x1600420, "RW_EXCL_SpinForReaders"},
        {0x1600424, "RW_EXCL_WaitForReaders"},
        {0x1600428, "RW_SHRD_unlock"},
        {0x160042c, "RW_EXCL_unlock"},
        {0x1600440, "RW_SHRD_SpinForWriter"},
        {0x1600444, "RW_SHRD_WaitForWriter"},
        {0x1600448, "RW_SHRDtoEXCL_SpinForReaders"},
        {0x160044c, "RW_SHRDtoEXCL_WaitForReaders"},
        {0x1700000, "PMAP_create"},
        {0x1700004, "PMAP_destroy"},
        {0x1700008, "PMAP_protect"},
        {0x170000c, "PMAP_page_protect"},
        {0x1700010, "PMAP_enter"},
        {0x1700014, "PMAP_remove"},
        {0x1700018, "PMAP_nest"},
        {0x170001c, "PMAP_unnest"},
        {0x1700020, "PMAP_flush_TLBS"},
        {0x1700024, "PMAP_update_interrupt"},
        {0x1700028, "PMAP_attribute_clear"},
        {0x170002c, "PMAP_reusable"},
        {0x1700030, "PMAP_query_resident"},
        {0x1700034, "PMAP_flush_kernel_TLBS"},
        {0x1700038, "PMAP_flush_delayed_TLBS"},
        {0x170003c, "PMAP_flush_TLBS_TO"},
        {0x1800000, "MACH_CLOCK_EPOCH_CHANGE"},
        {0x1900000, "MP_TLB_FLUSH"},
        {0x1900004, "MP_CPUS_CALL"},
        {0x1900008, "MP_CPUS_CALL_LOCAL"},
        {0x190000c, "MP_CPUS_CALL_ACTION"},
        {0x1900010, "MP_CPUS_CALL_NOBUF"},
        {0x1900014, "MP_CPU_FAST_START"},
        {0x1900018, "MP_CPU_START"},
        {0x190001c, "MP_CPU_DEACTIVATE"},
        {0x1a10000, "MICROSTACKSHOT_RECORD"},
        {0x1a10004, "MICROSTACKSHOT_GATHER"},
        {0x1a20000, "SFI_SET_WINDOW"},
        {0x1a20004, "SFI_CANCEL_WINDOW"},
        {0x1a20008, "SFI_SET_CLASS_OFFTIME"},
        {0x1a2000c, "SFI_CANCEL_CLASS_OFFTIME"},
        {0x1a20010, "SFI_THREAD_DEFER"},
        {0x1a20014, "SFI_OFF_TIMER"},
        {0x1a20018, "SFI_ON_TIMER"},
        {0x1a2001c, "SFI_WAIT_CANCELED"},
        {0x1a20020, "SFI_PID_SET_MANAGED"},
        {0x1a20024, "SFI_PID_CLEAR_MANAGED"},
        {0x1a20028, "SFI_GLOBAL_DEFER"},
        {0x1a30004, "ENERGY_PERF_GPU_DESCRIPTION"},
        {0x1a30008, "ENERGY_PERF_GPU_TIME"},
        {0x1a40000, "SYSDIAGNOSE_notify_user"},
        {0x1a50000, "ZALLOC_ZCRAM"},
        {0x2010000, "L_IP_In_Beg"},
        {0x2010004, "L_IP_Out_Beg"},
        {0x2010008, "L_IP_In_End"},
        {0x201000c, "L_IP_Out_End"},
        {0x2010404, "F_IP_Output"},
        {0x2010800, "F_IP_Input"},
        {0x2010c00, "F_In_CkSum"},
        {0x2020000, "L_ARP_Req"},
        {0x2020004, "L_ARP_Resp"},
        {0x2020008, "L_ARP_Reply"},
        {0x202000c, "L_ARP_Timo"},
        {0x2020010, "L_ARP_Look"},
        {0x2020014, "L_ARP_Input"},
        {0x2030000, "L_UDP_In_Beg"},
        {0x2030004, "L_UDP_Out_Beg"},
        {0x2030008, "L_UDP_In_End"},
        {0x203000c, "L_UDP_Out_End"},
        {0x2031400, "F_UDP_Input"},
        {0x2031804, "F_UDP_Output"},
        {0x2040000, "L_TCP_In_Beg"},
        {0x2040004, "L_TCP_Out_Beg"},
        {0x2040008, "L_TCP_In_End"},
        {0x204000c, "L_TCP_Out_End"},
        {0x2040c00, "F_TCP_Input"},
        {0x2041004, "F_TCP_Output"},
        {0x2041400, "F_TCP_FastT"},
        {0x2041404, "F_TCP_SlowT"},
        {0x2041408, "F_TCP_Close"},
        {0x2041800, "F_PCB_Lookup"},
        {0x2041804, "F_PCB_HshLkup"},
        {0x2041c00, "F_TCP_NewConn"},
        {0x2041d00, "F_TCP_gotSync"},
        {0x20b0010, "F_SBDrop"},
        {0x20b0014, "F_SBAppend"},
        {0x20b0404, "F_SendMsg"},
        {0x20b0804, "F_SendTo"},
        {0x20b0c04, "F_SendIt"},
        {0x20b1004, "F_SoSend"},
        {0x20b1008, "F_SoSend_CopyD"},
        {0x20b100c, "F_SoSend_List"},
        {0x20b1400, "F_RecvFrom"},
        {0x20b1800, "F_RecvMsg"},
        {0x20b1c00, "F_RecvIt"},
        {0x20b2000, "F_SoReceive"},
        {0x20b200c, "F_SoReceive_List"},
        {0x20b2100, "F_SoShutdown"},
        {0x20b2400, "F_SoAccept"},
        {0x20b2800, "F_sendfile"},
        {0x20b2804, "F_sendfile_wait"},
        {0x20b2808, "F_sendfile_read"},
        {0x20b280c, "F_sendfile_send"},
        {0x20b2c00, "F_sendmsg_x"},
        {0x20b3000, "F_recvmsg_x"},
        {0x2650004, "AT_DDPinput"},
        {0x2f00000, "F_FreemList"},
        {0x2f00004, "F_m_copym"},
        {0x2f00008, "F_getpackets"},
        {0x2f0000c, "F_getpackethdrs"},
        {0x3010000, "HFS_Write"},
        {0x301001c, "HFS_Truncate"},
        {0x3010028, "vinvalbuf"},
        {0x3010030, "HFS_Read"},
        {0x301003c, "MACH_copyiostr"},
        {0x3010040, "UIO_copyout"},
        {0x3010044, "UIO_copyin"},
        {0x3010048, "MACH_copyio"},
        {0x301004c, "Cl_bp"},
        {0x3010050, "Cl_iodone"},
        {0x3010054, "Cl_ubc_dump"},
        {0x3010058, "Cl_io"},
        {0x301005c, "Cl_zero"},
        {0x3010060, "Cl_cmap"},
        {0x3010068, "Cl_ioread"},
        {0x301006c, "Cl_iowrite"},
        {0x3010070, "Cl_ioabort"},
        {0x3010074, "Cl_zero_commit"},
        {0x3010078, "Cl_wrdel_commit"},
        {0x301007c, "Cl_read_abort"},
        {0x3010080, "Cl_read_copy"},
        {0x3010084, "Cl_read_list_req"},
        {0x3010088, "Cl_phys_uiomove"},
        {0x301008c, "Cl_read_commit"},
        {0x3010090, "VFS_LOOKUP"},
        {0x3010094, "HFS_getnewvnode"},
        {0x301009c, "VFS_LOOKUP_DONE"},
        {0x30100a0, "Cl_write_copy"},
        {0x30100a4, "Cl_write_list_req"},
        {0x30100a8, "Cl_write_uiomove"},
        {0x30100ac, "Cl_write_zeros"},
        {0x30100b0, "Cl_write_delayed"},
        {0x30100b4, "Cl_write_abort"},
        {0x30100b8, "Cl_zero_info"},
        {0x30100c0, "Cl_rd_ahead"},
        {0x30100c4, "Cl_rd_prefetch"},
        {0x30100c8, "Cl_rd_prefabort"},
        {0x30100cc, "Cl_writepush"},
        {0x30100d0, "Cl_pageout"},
        {0x30100d4, "Cl_push"},
        {0x30100e0, "Cl_pagein"},
        {0x30100f0, "Cl_advisory_rd"},
        {0x30100f4, "Cl_adv_fault_list"},
        {0x30100f8, "Cl_adv_abort1"},
        {0x30100fc, "Cl_adv_abort2"},
        {0x3010118, "Cl_read_direct"},
        {0x301011c, "Cl_ncpr_uiomv"},
        {0x3010120, "Cl_ncpr_getupl"},
        {0x3010124, "Cl_ncpr_clio"},
        {0x301012c, "Cl_write_direct"},
        {0x3010130, "Cl_ncpw_getupl"},
        {0x3010134, "Cl_ncpw_clio"},
        {0x3010138, "Cl_sparse_collect"},
        {0x301013c, "Cl_sparse_push"},
        {0x3010140, "Cl_sparse_add"},
        {0x3010144, "Cl_release"},
        {0x3010148, "Cl_drt_emptyfree"},
        {0x301014c, "Cl_drt_retcluster"},
        {0x3010150, "Cl_drt_alloctable"},
        {0x3010154, "Cl_drt_insert"},
        {0x3010158, "Cl_drt_mark"},
        {0x301015c, "Cl_drt_6"},
        {0x3010160, "Cl_drt_freetable"},
        {0x3010170, "Cl_read_contig_getupl"},
        {0x3010174, "Cl_write_contig_getupl"},
        {0x3010178, "Cl_io_type"},
        {0x301017c, "Cl_wait_IO"},
        {0x3010180, "Vnode_Pagein"},
        {0x3010184, "throttle_lowpri_io"},
        {0x3010198, "rethrottle_wakeup"},
        {0x301019c, "rethrottle_noted"},
        {0x3010200, "Vnode_Pageout"},
        {0x3010280, "Vnode_WaitForWrites"},
        {0x3010300, "PageoutThrottle"},
        {0x3010340, "SuperCluster"},
        {0x3010344, "PS_Offsets"},
        {0x3010348, "PS_Indexes"},
        {0x301034c, "Dirty_Indexes"},
        {0x3010350, "PS_Write"},
        {0x3010354, "PS_WriteComplete"},
        {0x3010380, "PageoutCollect"},
        {0x3010384, "PagesOnInactive_Q"},
        {0x3010388, "PagesOnActive_Q"},
        {0x301038c, "PageoutScan"},
        {0x3010390, "PageoutWait"},
        {0x3010394, "PageoutWakeup1"},
        {0x3010398, "PageoutWakeup2"},
        {0x301039c, "PageoutWakeup3"},
        {0x3010400, "NFS_doio"},
        {0x3010404, "NFS_doio_offsets"},
        {0x3010408, "NFS_doio_zero_read"},
        {0x301040c, "NFS_doio_zero_write"},
        {0x3010410, "NFS_doio_invalidate"},
        {0x3010414, "NFS_doio_retry"},
        {0x3010418, "NFS_doio_done"},
        {0x3010500, "NFS_pagein_zero"},
        {0x3010504, "NFS_pageout_zero"},
        {0x3010508, "NFS_pagein"},
        {0x301050c, "NFS_pageout"},
        {0x3010600, "BIO_write_list_req"},
        {0x3010604, "BIO_getblk_list_req"},
        {0x3010608, "BIO_getblk"},
        {0x301060c, "BIO_biodone"},
        {0x3010610, "BIO_brelse"},
        {0x3010614, "BIO_recovered_buf"},
        {0x3010618, "BIO_dumped_buf"},
        {0x301061c, "BIO_write_delayed"},
        {0x3010620, "BIO_acquire_error"},
        {0x3010624, "BIO_write_async"},
        {0x3010628, "BIO_write_sync"},
        {0x301062c, "BIO_flushdirty"},
        {0x3010630, "BIO_getblk_msleep"},
        {0x3010700, "VM_pageout_list_req"},
        {0x3010704, "VM_pagein_list_req"},
        {0x3010800, "NFS_setattr"},
        {0x3010804, "NFS_getattr"},
        {0x3010808, "NFS_read"},
        {0x301080c, "NFS_write"},
        {0x3010810, "NFS_truncate"},
        {0x3010814, "NFS_flush"},
        {0x3010818, "NFS_flush_again"},
        {0x301081c, "NFS_flush_bvec"},
        {0x3010820, "NFS_flush_upls"},
        {0x3010824, "NFS_commit"},
        {0x3010828, "NFS_flush_commit"},
        {0x301082c, "NFS_flush_done"},
        {0x3010830, "NFS_flush_busy"},
        {0x3010834, "NFS_flush_bwrite"},
        {0x3010838, "NFS_flush_normal"},
        {0x301083c, "NFS_loadattrcache"},
        {0x3010840, "NFS_getattrcache"},
        {0x3010844, "NFS_connect"},
        {0x3010848, "NFS_reply"},
        {0x301084c, "NFS_request"},
        {0x3010850, "NFS_softterm"},
        {0x3010854, "NFS_rcvunlock"},
        {0x3010858, "NFS_rcvlock"},
        {0x301085c, "NFS_timer"},
        {0x3010860, "NFS_vinvalbuf"},
        {0x3010864, "NFS_srvcommit"},
        {0x3010868, "NFS_srvfsync"},
        {0x301086c, "NFS_RdAhead"},
        {0x3010870, "NFS_srvread"},
        {0x3010874, "NFS_srvVOPREAD"},
        {0x3010900, "UBC_setsize"},
        {0x3010904, "UBC_sync_range"},
        {0x3010908, "UBC_upl_abort_range"},
        {0x301090c, "UBC_upl_commit_range"},
        {0x3011000, "UPL_iopl_req"},
        {0x3011004, "UPL_upl_req"},
        {0x3011008, "UPL_abort_range"},
        {0x301100c, "UPL_abort"},
        {0x3011010, "UPL_commit_range"},
        {0x3011014, "UPL_commit"},
        {0x3011018, "UPL_destroy"},
        {0x301101c, "UPL_commit_range_active"},
        {0x3011020, "UPL_commit_range_inactive"},
        {0x3011024, "UPL_map_enter_upl"},
        {0x3011028, "UPL_map_remove_upl"},
        {0x301102c, "UPL_commit_range_speculative"},
        {0x3018000, "HFS_update"},
        {0x3018004, "HFS_modify_block_end"},
        {0x3020000, "P_WrData"},
        {0x3020004, "P_WrDataDone"},
        {0x3020008, "P_RdData"},
        {0x302000c, "P_RdDataDone"},
        {0x3020010, "P_WrDataAsync"},
        {0x3020014, "P_WrDataAsyncDone"},
        {0x3020018, "P_RdDataAsync"},
        {0x302001c, "P_RdDataAsyncDone"},
        {0x3020020, "P_WrMeta"},
        {0x3020024, "P_WrMetaDone"},
        {0x3020028, "P_RdMeta"},
        {0x302002c, "P_RdMetaDone"},
        {0x3020030, "P_WrMetaAsync"},
        {0x3020034, "P_WrMetaAsyncDone"},
        {0x3020038, "P_RdMetaAsync"},
        {0x302003c, "P_RdMetaAsyncDone"},
        {0x3020040, "P_PgOut"},
        {0x3020044, "P_PgOutDone"},
        {0x3020048, "P_PgIn"},
        {0x302004c, "P_PgInDone"},
        {0x3020050, "P_PgOutAsync"},
        {0x3020054, "P_PgOutAsyncDone"},
        {0x3020058, "P_PgInAsync"},
        {0x302005c, "P_PgInAsyncDone"},
        {0x3020100, "P_WrDataP"},
        {0x3020104, "P_WrDataPDone"},
        {0x3020108, "P_RdDataP"},
        {0x302010c, "P_RdDataPDone"},
        {0x3020110, "P_WrDataAsyncP"},
        {0x3020114, "P_WrDataAsyncPDone"},
        {0x3020118, "P_RdDataAsyncP"},
        {0x302011c, "P_RdDataAsyncPDone"},
        {0x3020120, "P_WrMetaP"},
        {0x3020124, "P_WrMetaPDone"},
        {0x3020128, "P_RdMetaP"},
        {0x302012c, "P_RdMetaPDone"},
        {0x3020130, "P_WrMetaAsyncP"},
        {0x3020134, "P_WrMetaAsyncPDone"},
        {0x3020138, "P_RdMetaAsyncP"},
        {0x302013c, "P_RdMetaAsyncPDone"},
        {0x3020140, "P_PgOutP"},
        {0x3020144, "P_PgOutPDone"},
        {0x3020148, "P_PgInP"},
        {0x302014c, "P_PgInPDone"},
        {0x3020150, "P_PgOutAsyncP"},
        {0x3020154, "P_PgOutAsyncPDone"},
        {0x3020158, "P_PgInAsyncP"},
        {0x302015c, "P_PgInAsyncPDone"},
        {0x3020200, "P_WrDataN"},
        {0x3020204, "P_WrDataNDone"},
        {0x3020208, "P_RdDataN"},
        {0x302020c, "P_RdDataNDone"},
        {0x3020210, "P_WrDataAsyncN"},
        {0x3020214, "P_WrDataAsyncNDone"},
        {0x3020218, "P_RdDataAsyncN"},
        {0x302021c, "P_RdDataAsyncNDone"},
        {0x3020300, "P_WrDataNP"},
        {0x3020304, "P_WrDataNPDone"},
        {0x3020308, "P_RdDataNP"},
        {0x302030c, "P_RdDataNPDone"},
        {0x3020310, "P_WrDataAsyncNP"},
        {0x3020314, "P_WrDataAsyncNPDone"},
        {0x3020318, "P_RdDataAsyncNP"},
        {0x302031c, "P_RdDataAsyncNPDone"},
        {0x3020480, "P_WrDataT1"},
        {0x3020484, "P_WrDataT1Done"},
        {0x3020488, "P_RdDataT1"},
        {0x302048c, "P_RdDataT1Done"},
        {0x3020490, "P_WrDataAsyncT1"},
        {0x3020494, "P_WrDataAsyncT1Done"},
        {0x3020498, "P_RdDataAsyncT1"},
        {0x302049c, "P_RdDataAsyncT1Done"},
        {0x30204a0, "P_WrMetaT1"},
        {0x30204a4, "P_WrMetaT1Done"},
        {0x30204a8, "P_RdMetaT1"},
        {0x30204ac, "P_RdMetaT1Done"},
        {0x30204b0, "P_WrMetaAsyncT1"},
        {0x30204b4, "P_WrMetaAsyncT1Done"},
        {0x30204b8, "P_RdMetaAsyncT1"},
        {0x30204bc, "P_RdMetaAsyncT1Done"},
        {0x30204c0, "P_PgOutT1"},
        {0x30204c4, "P_PgOutT1Done"},
        {0x30204c8, "P_PgInT1"},
        {0x30204cc, "P_PgInT1Done"},
        {0x30204d0, "P_PgOutAsyncT1"},
        {0x30204d4, "P_PgOutAsyncT1Done"},
        {0x30204d8, "P_PgInAsyncT1"},
        {0x30204dc, "P_PgInAsyncT1Done"},
        {0x3020680, "P_WrDataNT1"},
        {0x3020684, "P_WrDataNT1Done"},
        {0x3020688, "P_RdDataNT1"},
        {0x302068c, "P_RdDataNT1Done"},
        {0x3020690, "P_WrDataAsyncNT1"},
        {0x3020694, "P_WrDataAsyncNT1Done"},
        {0x3020698, "P_RdDataAsyncNT1"},
        {0x302069c, "P_RdDataAsyncNT1Done"},
        {0x3020880, "P_WrDataT2"},
        {0x3020884, "P_WrDataT2Done"},
        {0x3020888, "P_RdDataT2"},
        {0x302088c, "P_RdDataT2Done"},
        {0x3020890, "P_WrDataAsyncT2"},
        {0x3020894, "P_WrDataAsyncT2Done"},
        {0x3020898, "P_RdDataAsyncT2"},
        {0x302089c, "P_RdDataAsyncT2Done"},
        {0x30208a0, "P_WrMetaT2"},
        {0x30208a4, "P_WrMetaT2Done"},
        {0x30208a8, "P_RdMetaT2"},
        {0x30208ac, "P_RdMetaT2Done"},
        {0x30208b0, "P_WrMetaAsyncT2"},
        {0x30208b4, "P_WrMetaAsyncT2Done"},
        {0x30208b8, "P_RdMetaAsyncT2"},
        {0x30208bc, "P_RdMetaAsyncT2Done"},
        {0x30208c0, "P_PgOutT2"},
        {0x30208c4, "P_PgOutT2Done"},
        {0x30208c8, "P_PgInT2"},
        {0x30208cc, "P_PgInT2Done"},
        {0x30208d0, "P_PgOutAsyncT2"},
        {0x30208d4, "P_PgOutAsyncT2Done"},
        {0x30208d8, "P_PgInAsyncT2"},
        {0x30208dc, "P_PgInAsyncT2Done"},
        {0x3020a80, "P_WrDataNT2"},
        {0x3020a84, "P_WrDataNT2Done"},
        {0x3020a88, "P_RdDataNT2"},
        {0x3020a8c, "P_RdDataNT2Done"},
        {0x3020a90, "P_WrDataAsyncNT2"},
        {0x3020a94, "P_WrDataAsyncNT2Done"},
        {0x3020a98, "P_RdDataAsyncNT2"},
        {0x3020a9c, "P_RdDataAsyncNT2Done"},
        {0x3020c80, "P_WrDataT3"},
        {0x3020c84, "P_WrDataT3Done"},
        {0x3020c88, "P_RdDataT3"},
        {0x3020c8c, "P_RdDataT3Done"},
        {0x3020c90, "P_WrDataAsyncT3"},
        {0x3020c94, "P_WrDataAsyncT3Done"},
        {0x3020c98, "P_RdDataAsyncT3"},
        {0x3020c9c, "P_RdDataAsyncT3Done"},
        {0x3020ca0, "P_WrMetaT3"},
        {0x3020ca4, "P_WrMetaT3Done"},
        {0x3020ca8, "P_RdMetaT3"},
        {0x3020cac, "P_RdMetaT3Done"},
        {0x3020cb0, "P_WrMetaAsyncT3"},
        {0x3020cb4, "P_WrMetaAsyncT3Done"},
        {0x3020cb8, "P_RdMetaAsyncT3"},
        {0x3020cbc, "P_RdMetaAsyncT3Done"},
        {0x3020cc0, "P_PgOutT3"},
        {0x3020cc4, "P_PgOutT3Done"},
        {0x3020cc8, "P_PgInT3"},
        {0x3020ccc, "P_PgInT3Done"},
        {0x3020cd0, "P_PgOutAsyncT3"},
        {0x3020cd4, "P_PgOutAsyncT3Done"},
        {0x3020cd8, "P_PgInAsyncT3"},
        {0x3020cdc, "P_PgInAsyncT3Done"},
        {0x3020e80, "P_WrDataNT3"},
        {0x3020e84, "P_WrDataNT3Done"},
        {0x3020e88, "P_RdDataNT3"},
        {0x3020e8c, "P_RdDataNT3Done"},
        {0x3020e90, "P_WrDataAsyncNT3"},
        {0x3020e94, "P_WrDataAsyncNT3Done"},
        {0x3020e98, "P_RdDataAsyncNT3"},
        {0x3020e9c, "P_RdDataAsyncNT3Done"},
        {0x3050004, "journal_flush"},
        {0x3060000, "SPEC_ioctl"},
        {0x3060004, "SPEC_trim_extent"},
        {0x3070004, "BootCache_tag"},
        {0x3070008, "BootCache_batch"},
        {0x3070010, "BC_IO_HIT"},
        {0x3070020, "BC_IO_HIT_STALLED"},
        {0x3070040, "BC_IO_MISS"},
        {0x3070080, "BC_IO_MISS_CUT_THROUGH"},
        {0x3070100, "BC_PLAYBACK_IO"},
        {0x3080000, "HFS_Unmap_free"},
        {0x3080004, "HFS_Unmap_alloc"},
        {0x3080008, "HFS_Unmap_callback"},
        {0x3080010, "HFS_BlockAllocate"},
        {0x3080014, "HFS_BlockDeallocate"},
        {0x3080018, "HFS_ReadBitmapBlock"},
        {0x308001c, "HFS_ReleaseBitmapBlock"},
        {0x3080020, "HFS_BlockAllocateContig"},
        {0x3080024, "HFS_BlockAllocateAnyBitmap"},
        {0x3080028, "HFS_BlockAllocateKnown"},
        {0x308002c, "HFS_BlockMarkAllocated"},
        {0x3080030, "HFS_BlockMarkFree"},
        {0x3080034, "HFS_BlockFindContiguous"},
        {0x3080038, "HFS_IsAllocated"},
        {0x3080040, "HFS_ResetFreeExtCache"},
        {0x3080044, "HFS_remove_free_extcache"},
        {0x3080048, "HFS_add_free_extcache"},
        {0x308004c, "HFS_ReadBitmapRange"},
        {0x3080050, "HFS_ReleaseScanBitmapRange"},
        {0x3080054, "HFS_syncer"},
        {0x3080058, "HFS_syncer_timed"},
        {0x308005c, "HFS_ScanUnmapBlocks"},
        {0x3080060, "HFS_issue_unmap"},
        {0x3080064, "HFS_KR"},
        {0x30a0000, "SMB_vop_mount"},
        {0x30a0004, "SMB_vop_unmount"},
        {0x30a0008, "SMB_vop_root"},
        {0x30a000c, "SMB_vop_getattr"},
        {0x30a0010, "SMB_vop_sync"},
        {0x30a0014, "SMB_vop_vget"},
        {0x30a0018, "SMB_vop_sysctl"},
        {0x30a001c, "SMB_vnop_advlock"},
        {0x30a0020, "SMB_vnop_close"},
        {0x30a0024, "SMB_vnop_create"},
        {0x30a0028, "SMB_vnop_fsync"},
        {0x30a002c, "SMB_vnop_get_attr"},
        {0x30a0030, "SMB_vnop_page_in"},
        {0x30a0034, "SMB_vnop_inactive"},
        {0x30a0038, "SMB_vnop_ioctl"},
        {0x30a003c, "SMB_vnop_link"},
        {0x30a0040, "SMB_vnop_lookup"},
        {0x30a0044, "SMB_vnop_mkdir"},
        {0x30a0048, "SMB_vnop_mknode"},
        {0x30a004c, "SMB_vnop_mmap"},
        {0x30a0050, "SMB_vnop_mnomap"},
        {0x30a0054, "SMB_vnop_open"},
        {0x30a0058, "SMB_vnop_cmpd_open"},
        {0x30a005c, "SMB_vnop_pathconf"},
        {0x30a0060, "SMB_vnop_page_out"},
        {0x30a0064, "SMB_vnop_copyfile"},
        {0x30a0068, "SMB_vnop_read"},
        {0x30a006c, "SMB_vnop_read_dir"},
        {0x30a0070, "SMB_vnop_read_dir_attr"},
        {0x30a0074, "SMB_vnop_read_link"},
        {0x30a0078, "SMB_vnop_reclaim"},
        {0x30a007c, "SMB_vnop_remove"},
        {0x30a0080, "SMB_vnop_rename"},
        {0x30a0084, "SMB_vnop_rm_dir"},
        {0x30a0088, "SMB_vnop_set_attr"},
        {0x30a008c, "SMB_vnop_sym_link"},
        {0x30a0090, "SMB_vnop_write"},
        {0x30a0094, "SMB_vnop_strategy"},
        {0x30a0098, "SMB_vnop_get_xattr"},
        {0x30a009c, "SMB_vnop_set_xattr"},
        {0x30a00a0, "SMB_vnop_rm_xattr"},
        {0x30a00a4, "SMB_vnop_list_xattr"},
        {0x30a00a8, "SMB_vnop_monitor"},
        {0x30a00ac, "SMB_vnop_get_nstream"},
        {0x30a00b0, "SMB_vnop_make_nstream"},
        {0x30a00b4, "SMB_vnop_rm_nstream"},
        {0x30a00b8, "SMB_vnop_access"},
        {0x30a00bc, "SMB_vnop_allocate"},
        {0x30a00c0, "SMB_smbfs_close"},
        {0x30a00c4, "SMB_smbfs_create"},
        {0x30a00c8, "SMB_smbfs_fsync"},
        {0x30a00cc, "SMB_smb_fsync"},
        {0x30a00d0, "SMB_smbfs_update_cache"},
        {0x30a00d4, "SMB_smbfs_open"},
        {0x30a00d8, "SMB_smb_read"},
        {0x30a00dc, "SMB_smb_rw_async"},
        {0x30a00e0, "SMB_smb_rw_fill"},
        {0x30a00e4, "SMB_pack_attr_blk"},
        {0x30a00e8, "SMB_smbfs_remove"},
        {0x30a00ec, "SMB_smbfs_setattr"},
        {0x30a00f0, "SMB_smbfs_get_sec"},
        {0x30a00f4, "SMB_smbfs_set_sec"},
        {0x30a00f8, "SMB_smbfs_get_max_access"},
        {0x30a00fc, "SMB_smbfs_lookup"},
        {0x30a0100, "SMB_smbfs_notify"},
        {0x3110004, "OpenThrottleWindow"},
        {0x3110008, "CauseIOThrottle"},
        {0x311000c, "IO_THROTTLE_DISABLE"},
        {0x3cf0000, "CP_OFFSET_IO"},
        {0x4010004, "proc_exit"},
        {0x4010008, "force_exit"},
        {0x401000c, "proc_exec"},
        {0x4010010, "exit_reason_create"},
        {0x4010014, "exit_reason_commit"},
        {0x4020004, "MEMSTAT_scan"},
        {0x4020008, "MEMSTAT_jetsam"},
        {0x402000c, "MEMSTAT_jetsam_hiwat"},
        {0x4020010, "MEMSTAT_freeze"},
        {0x4020014, "MEMSTAT_latency_coalesce"},
        {0x4020018, "MEMSTAT_update"},
        {0x402001c, "MEMSTAT_idle_demote"},
        {0x4020020, "MEMSTAT_clear_errors"},
        {0x4020024, "MEMSTAT_dirty_track"},
        {0x4020028, "MEMSTAT_dirty_set"},
        {0x402002c, "MEMSTAT_dirty_clear"},
        {0x4020030, "MEMSTAT_grp_set_properties"},
        {0x4020034, "MEMSTAT_do_kill"},
        {0x40c0000, "BSC_indirect_syscall"},
        {0x40c0004, "BSC_exit"},
        {0x40c0008, "BSC_fork"},
        {0x40c000c, "BSC_read"},
        {0x40c0010, "BSC_write"},
        {0x40c0014, "BSC_open"},
        {0x40c0018, "BSC_close"},
        {0x40c001c, "BSC_wait4"},
        {0x40c0020, "BSC_obs_creat"},
        {0x40c0024, "BSC_link"},
        {0x40c0028, "BSC_unlink"},
        {0x40c002c, "BSC_obs_execv"},
        {0x40c0030, "BSC_chdir"},
        {0x40c0034, "BSC_fchdir"},
        {0x40c0038, "BSC_mknod"},
        {0x40c003c, "BSC_chmod"},
        {0x40c0040, "BSC_chown"},
        {0x40c0044, "BSC_obs_break"},
        {0x40c0048, "BSC_getfsstat"},
        {0x40c004c, "BSC_obs_lseek"},
        {0x40c0050, "BSC_getpid"},
        {0x40c0054, "BSC_obs_mount"},
        {0x40c0058, "BSC_obs_umount"},
        {0x40c005c, "BSC_setuid"},
        {0x40c0060, "BSC_getuid"},
        {0x40c0064, "BSC_geteuid"},
        {0x40c0068, "BSC_ptrace"},
        {0x40c006c, "BSC_recvmsg"},
        {0x40c0070, "BSC_sendmsg"},
        {0x40c0074, "BSC_recvfrom"},
        {0x40c0078, "BSC_accept"},
        {0x40c007c, "BSC_getpeername"},
        {0x40c0080, "BSC_getsockname"},
        {0x40c0084, "BSC_access"},
        {0x40c0088, "BSC_chflags"},
        {0x40c008c, "BSC_fchflags"},
        {0x40c0090, "BSC_sync"},
        {0x40c0094, "BSC_kill"},
        {0x40c0098, "BSC_obs_stat"},
        {0x40c009c, "BSC_getppid"},
        {0x40c00a0, "BSC_obs_lstat"},
        {0x40c00a4, "BSC_dup"},
        {0x40c00a8, "BSC_pipe"},
        {0x40c00ac, "BSC_getegid"},
        {0x40c00b0, "BSC_obs_profil"},
        {0x40c00b4, "BSC_obs_ktrace"},
        {0x40c00b8, "BSC_sigaction"},
        {0x40c00bc, "BSC_getgid"},
        {0x40c00c0, "BSC_sigprocmask"},
        {0x40c00c4, "BSC_getlogin"},
        {0x40c00c8, "BSC_setlogin"},
        {0x40c00cc, "BSC_acct"},
        {0x40c00d0, "BSC_sigpending"},
        {0x40c00d4, "BSC_sigaltstack"},
        {0x40c00d8, "BSC_ioctl"},
        {0x40c00dc, "BSC_reboot"},
        {0x40c00e0, "BSC_revoke"},
        {0x40c00e4, "BSC_symlink"},
        {0x40c00e8, "BSC_readlink"},
        {0x40c00ec, "BSC_execve"},
        {0x40c00f0, "BSC_umask"},
        {0x40c00f4, "BSC_chroot"},
        {0x40c00f8, "BSC_obs_fstat"},
        {0x40c00fc, "BSC_used_internally_and_reserved"},
        {0x40c0100, "BSC_obs_getpagesize"},
        {0x40c0104, "BSC_msync"},
        {0x40c0108, "BSC_vfork"},
        {0x40c010c, "BSC_obs_vread"},
        {0x40c0110, "BSC_obs_vwrite"},
        {0x40c0114, "BSC_obs_sbrk"},
        {0x40c0118, "BSC_obs_sstk"},
        {0x40c011c, "BSC_obs_mmap"},
        {0x40c0120, "BSC_obs_vadvise"},
        {0x40c0124, "BSC_munmap"},
        {0x40c0128, "BSC_mprotect"},
        {0x40c012c, "BSC_madvise"},
        {0x40c0130, "BSC_obs_vhangup"},
        {0x40c0134, "BSC_obs_vlimit"},
        {0x40c0138, "BSC_mincore"},
        {0x40c013c, "BSC_getgroups"},
        {0x40c0140, "BSC_setgroups"},
        {0x40c0144, "BSC_getpgrp"},
        {0x40c0148, "BSC_setpgid"},
        {0x40c014c, "BSC_setitimer"},
        {0x40c0150, "BSC_obs_wait"},
        {0x40c0154, "BSC_swapon"},
        {0x40c0158, "BSC_getitimer"},
        {0x40c015c, "BSC_obs_gethostname"},
        {0x40c0160, "BSC_obs_sethostname"},
        {0x40c0164, "BSC_getdtablesize"},
        {0x40c0168, "BSC_dup2"},
        {0x40c016c, "BSC_obs_getdopt"},
        {0x40c0170, "BSC_fcntl"},
        {0x40c0174, "BSC_select"},
        {0x40c0178, "BSC_obs_setdopt"},
        {0x40c017c, "BSC_fsync"},
        {0x40c0180, "BSC_setpriority"},
        {0x40c0184, "BSC_socket"},
        {0x40c0188, "BSC_connect"},
        {0x40c018c, "BSC_obs_accept"},
        {0x40c0190, "BSC_getpriority"},
        {0x40c0194, "BSC_obs_send"},
        {0x40c0198, "BSC_obs_recv"},
        {0x40c019c, "BSC_obs_sigreturn"},
        {0x40c01a0, "BSC_bind"},
        {0x40c01a4, "BSC_setsockopt"},
        {0x40c01a8, "BSC_listen"},
        {0x40c01ac, "BSC_obs_vtimes"},
        {0x40c01b0, "BSC_obs_sigvec"},
        {0x40c01b4, "BSC_obs_sigblock"},
        {0x40c01b8, "BSC_obs_sigsetmask"},
        {0x40c01bc, "BSC_sigsuspend"},
        {0x40c01c0, "BSC_obs_sigstack"},
        {0x40c01c4, "BSC_obs_recvmsg"},
        {0x40c01c8, "BSC_obs_sendmsg"},
        {0x40c01cc, "BSC_obs_vtrace"},
        {0x40c01d0, "BSC_gettimeofday"},
        {0x40c01d4, "BSC_getrusage"},
        {0x40c01d8, "BSC_getsockopt"},
        {0x40c01dc, "BSC_obs_resuba"},
        {0x40c01e0, "BSC_readv"},
        {0x40c01e4, "BSC_writev"},
        {0x40c01e8, "BSC_settimeofday"},
        {0x40c01ec, "BSC_fchown"},
        {0x40c01f0, "BSC_fchmod"},
        {0x40c01f4, "BSC_obs_recvfrom"},
        {0x40c01f8, "BSC_setreuid"},
        {0x40c01fc, "BSC_setregid"},
        {0x40c0200, "BSC_rename"},
        {0x40c0204, "BSC_obs_truncate"},
        {0x40c0208, "BSC_obs_ftruncate"},
        {0x40c020c, "BSC_flock"},
        {0x40c0210, "BSC_mkfifo"},
        {0x40c0214, "BSC_sendto"},
        {0x40c0218, "BSC_shutdown"},
        {0x40c021c, "BSC_socketpair"},
        {0x40c0220, "BSC_mkdir"},
        {0x40c0224, "BSC_rmdir"},
        {0x40c0228, "BSC_utimes"},
        {0x40c022c, "BSC_futimes"},
        {0x40c0230, "BSC_adjtime"},
        {0x40c0234, "BSC_obs_getpeername"},
        {0x40c0238, "BSC_gethostuuid"},
        {0x40c023c, "BSC_obs_sethostid"},
        {0x40c0240, "BSC_obs_getrlimit"},
        {0x40c0244, "BSC_obs_setrlimit"},
        {0x40c0248, "BSC_obs_killpg"},
        {0x40c024c, "BSC_setsid"},
        {0x40c0250, "BSC_obs_setquota"},
        {0x40c0254, "BSC_obs_qquota"},
        {0x40c0258, "BSC_obs_getsockname"},
        {0x40c025c, "BSC_getpgid"},
        {0x40c0260, "BSC_setprivexec"},
        {0x40c0264, "BSC_pread"},
        {0x40c0268, "BSC_pwrite"},
        {0x40c026c, "BSC_nfssvc"},
        {0x40c0270, "BSC_obs_getdirentries"},
        {0x40c0274, "BSC_statfs"},
        {0x40c0278, "BSC_fstatfs"},
        {0x40c027c, "BSC_unmount"},
        {0x40c0280, "BSC_obs_async_daemon"},
        {0x40c0284, "BSC_getfh"},
        {0x40c0288, "BSC_obs_getdomainname"},
        {0x40c028c, "BSC_obs_setdomainname"},
        {0x40c0290, "BSC_#164"},
        {0x40c0294, "BSC_quotactl"},
        {0x40c0298, "BSC_obs_exportfs"},
        {0x40c029c, "BSC_mount"},
        {0x40c02a0, "BSC_obs_ustat"},
        {0x40c02a4, "BSC_csops"},
        {0x40c02a8, "BSC_csops_audittoken"},
        {0x40c02ac, "BSC_obs_wait3"},
        {0x40c02b0, "BSC_obs_rpause"},
        {0x40c02b4, "BSC_waitid"},
        {0x40c02b8, "BSC_obs_getdents"},
        {0x40c02bc, "BSC_obs_gc_control"},
        {0x40c02c0, "BSC_obs_add_profil"},
        {0x40c02c4, "BSC_kdebug_typefilter"},
        {0x40c02c8, "BSC_kdebug_trace_string"},
        {0x40c02cc, "BSC_kdebug_trace64"},
        {0x40c02d0, "BSC_kdebug_trace"},
        {0x40c02d4, "BSC_setgid"},
        {0x40c02d8, "BSC_setegid"},
        {0x40c02dc, "BSC_seteuid"},
        {0x40c02e0, "BSC_sigreturn"},
        {0x40c02e4, "BSC_obs_chud"},
        {0x40c02e8, "BSC_#186"},
        {0x40c02ec, "BSC_fdatasync"},
        {0x40c02f0, "BSC_stat"},
        {0x40c02f4, "BSC_fstat"},
        {0x40c02f8, "BSC_lstat"},
        {0x40c02fc, "BSC_pathconf"},
        {0x40c0300, "BSC_fpathconf"},
        {0x40c0304, "BSC_obs_getfsstat"},
        {0x40c0308, "BSC_getrlimit"},
        {0x40c030c, "BSC_setrlimit"},
        {0x40c0310, "BSC_getdirentries"},
        {0x40c0314, "BSC_mmap"},
        {0x40c0318, "BSC_obs___syscall"},
        {0x40c031c, "BSC_lseek"},
        {0x40c0320, "BSC_truncate"},
        {0x40c0324, "BSC_ftruncate"},
        {0x40c0328, "BSC_sysctl"},
        {0x40c032c, "BSC_mlock"},
        {0x40c0330, "BSC_munlock"},
        {0x40c0334, "BSC_undelete"},
        {0x40c0338, "BSC_obs_ATsocket"},
        {0x40c033c, "BSC_obs_ATgetmsg"},
        {0x40c0340, "BSC_obs_ATputmsg"},
        {0x40c0344, "BSC_obs_ATsndreq"},
        {0x40c0348, "BSC_obs_ATsndrsp"},
        {0x40c034c, "BSC_obs_ATgetreq"},
        {0x40c0350, "BSC_obs_ATgetrsp"},
        {0x40c0354, "BSC_Reserved_for_AppleTalk"},
        {0x40c0358, "BSC_#214"},
        {0x40c035c, "BSC_#215"},
        {0x40c0360, "BSC_open_dprotected_np"},
        {0x40c0364, "BSC_obs_statv"},
        {0x40c0368, "BSC_obs_lstatv"},
        {0x40c036c, "BSC_obs_fstatv"},
        {0x40c0370, "BSC_getattrlist"},
        {0x40c0374, "BSC_setattrlist"},
        {0x40c0378, "BSC_getdirentriesattr"},
        {0x40c037c, "BSC_exchangedata"},
        {0x40c0380, "BSC_obs_checkuseraccess_or_fsgetpath"},
        {0x40c0384, "BSC_searchfs"},
        {0x40c0388, "BSC_delete"},
        {0x40c038c, "BSC_copyfile"},
        {0x40c0390, "BSC_fgetattrlist"},
        {0x40c0394, "BSC_fsetattrlist"},
        {0x40c0398, "BSC_poll"},
        {0x40c039c, "BSC_watchevent"},
        {0x40c03a0, "BSC_waitevent"},
        {0x40c03a4, "BSC_modwatch"},
        {0x40c03a8, "BSC_getxattr"},
        {0x40c03ac, "BSC_fgetxattr"},
        {0x40c03b0, "BSC_setxattr"},
        {0x40c03b4, "BSC_fsetxattr"},
        {0x40c03b8, "BSC_removexattr"},
        {0x40c03bc, "BSC_fremovexattr"},
        {0x40c03c0, "BSC_listxattr"},
        {0x40c03c4, "BSC_flistxattr"},
        {0x40c03c8, "BSC_fsctl"},
        {0x40c03cc, "BSC_initgroups"},
        {0x40c03d0, "BSC_posix_spawn"},
        {0x40c03d4, "BSC_ffsctl"},
        {0x40c03d8, "BSC_#246"},
        {0x40c03dc, "BSC_nfsclnt"},
        {0x40c03e0, "BSC_fhopen"},
        {0x40c03e4, "BSC_#249"},
        {0x40c03e8, "BSC_minherit"},
        {0x40c03ec, "BSC_semsys"},
        {0x40c03f0, "BSC_msgsys"},
        {0x40c03f4, "BSC_shmsys"},
        {0x40c03f8, "BSC_semctl"},
        {0x40c03fc, "BSC_semget"},
        {0x40c0400, "BSC_semop"},
        {0x40c0404, "BSC_obs_semconfig"},
        {0x40c0408, "BSC_msgctl"},
        {0x40c040c, "BSC_msgget"},
        {0x40c0410, "BSC_msgsnd"},
        {0x40c0414, "BSC_msgrcv"},
        {0x40c0418, "BSC_shmat"},
        {0x40c041c, "BSC_shmctl"},
        {0x40c0420, "BSC_shmdt"},
        {0x40c0424, "BSC_shmget"},
        {0x40c0428, "BSC_shm_open"},
        {0x40c042c, "BSC_shm_unlink"},
        {0x40c0430, "BSC_sem_open"},
        {0x40c0434, "BSC_sem_close"},
        {0x40c0438, "BSC_sem_unlink"},
        {0x40c043c, "BSC_sem_wait"},
        {0x40c0440, "BSC_sem_trywait"},
        {0x40c0444, "BSC_sem_post"},
        {0x40c0448, "BSC_sysctlbyname"},
        {0x40c044c, "BSC_obs_sem_init"},
        {0x40c0450, "BSC_obs_sem_destroy"},
        {0x40c0454, "BSC_open_extended"},
        {0x40c0458, "BSC_umask_extended"},
        {0x40c045c, "BSC_stat_extended"},
        {0x40c0460, "BSC_lstat_extended"},
        {0x40c0464, "BSC_fstat_extended"},
        {0x40c0468, "BSC_chmod_extended"},
        {0x40c046c, "BSC_fchmod_extended"},
        {0x40c0470, "BSC_access_extended"},
        {0x40c0474, "BSC_settid"},
        {0x40c0478, "BSC_gettid"},
        {0x40c047c, "BSC_setsgroups"},
        {0x40c0480, "BSC_getsgroups"},
        {0x40c0484, "BSC_setwgroups"},
        {0x40c0488, "BSC_getwgroups"},
        {0x40c048c, "BSC_mkfifo_extended"},
        {0x40c0490, "BSC_mkdir_extended"},
        {0x40c0494, "BSC_identitysvc"},
        {0x40c0498, "BSC_shared_region_check_np"},
        {0x40c049c, "BSC_obs_shared_region_map_np"},
        {0x40c04a0, "BSC_vm_pressure_monitor"},
        {0x40c04a4, "BSC_psynch_rw_longrdlock"},
        {0x40c04a8, "BSC_psynch_rw_yieldwrlock"},
        {0x40c04ac, "BSC_psynch_rw_downgrade"},
        {0x40c04b0, "BSC_psynch_rw_upgrade"},
        {0x40c04b4, "BSC_psynch_mutexwait"},
        {0x40c04b8, "BSC_psynch_mutexdrop"},
        {0x40c04bc, "BSC_psynch_cvbroad"},
        {0x40c04c0, "BSC_psynch_cvsignal"},
        {0x40c04c4, "BSC_psynch_cvwait"},
        {0x40c04c8, "BSC_psynch_rw_rdlock"},
        {0x40c04cc, "BSC_psynch_rw_wrlock"},
        {0x40c04d0, "BSC_psynch_rw_unlock"},
        {0x40c04d4, "BSC_psynch_rw_unlock2"},
        {0x40c04d8, "BSC_getsid"},
        {0x40c04dc, "BSC_settid_with_pid"},
        {0x40c04e0, "BSC_psynch_cvclrprepost"},
        {0x40c04e4, "BSC_aio_fsync"},
        {0x40c04e8, "BSC_aio_return"},
        {0x40c04ec, "BSC_aio_suspend"},
        {0x40c04f0, "BSC_aio_cancel"},
        {0x40c04f4, "BSC_aio_error"},
        {0x40c04f8, "BSC_aio_read"},
        {0x40c04fc, "BSC_aio_write"},
        {0x40c0500, "BSC_lio_listio"},
        {0x40c0504, "BSC_obs___pthread_cond_wait"},
        {0x40c0508, "BSC_iopolicysys"},
        {0x40c050c, "BSC_process_policy"},
        {0x40c0510, "BSC_mlockall"},
        {0x40c0514, "BSC_munlockall"},
        {0x40c0518, "BSC_#326"},
        {0x40c051c, "BSC_issetugid"},
        {0x40c0520, "BSC_pthread_kill"},
        {0x40c0524, "BSC_pthread_sigmask"},
        {0x40c0528, "BSC_sigwait"},
        {0x40c052c, "BSC_disable_threadsignal"},
        {0x40c0530, "BSC_pthread_markcancel"},
        {0x40c0534, "BSC_pthread_canceled"},
        {0x40c0538, "BSC_semwait_signal"},
        {0x40c053c, "BSC_obs_utrace"},
        {0x40c0540, "BSC_proc_info"},
        {0x40c0544, "BSC_sendfile"},
        {0x40c0548, "BSC_stat64"},
        {0x40c054c, "BSC_fstat64"},
        {0x40c0550, "BSC_lstat64"},
        {0x40c0554, "BSC_stat64_extended"},
        {0x40c0558, "BSC_lstat64_extended"},
        {0x40c055c, "BSC_fstat64_extended"},
        {0x40c0560, "BSC_getdirentries64"},
        {0x40c0564, "BSC_statfs64"},
        {0x40c0568, "BSC_fstatfs64"},
        {0x40c056c, "BSC_getfsstat64"},
        {0x40c0570, "BSC_pthread_chdir"},
        {0x40c0574, "BSC_pthread_fchdir"},
        {0x40c0578, "BSC_audit"},
        {0x40c057c, "BSC_auditon"},
        {0x40c0580, "BSC_#352"},
        {0x40c0584, "BSC_getauid"},
        {0x40c0588, "BSC_setauid"},
        {0x40c058c, "BSC_obs_getaudit"},
        {0x40c0590, "BSC_obs_setaudit"},
        {0x40c0594, "BSC_getaudit_addr"},
        {0x40c0598, "BSC_setaudit_addr"},
        {0x40c059c, "BSC_auditctl"},
        {0x40c05a0, "BSC_bsdthread_create"},
        {0x40c05a4, "BSC_bsdthread_terminate"},
        {0x40c05a8, "BSC_kqueue"},
        {0x40c05ac, "BSC_kevent"},
        {0x40c05b0, "BSC_lchown"},
        {0x40c05b4, "BSC_obs_stack_snapshot"},
        {0x40c05b8, "BSC_bsdthread_register"},
        {0x40c05bc, "BSC_workq_open"},
        {0x40c05c0, "BSC_workq_kernreturn"},
        {0x40c05c4, "BSC_kevent64"},
        {0x40c05c8, "BSC_old_semwait_signal"},
        {0x40c05cc, "BSC_old_semwait_signal_nocancel"},
        {0x40c05d0, "BSC_thread_selfid"},
        {0x40c05d4, "BSC_ledger"},
        {0x40c05d8, "BSC_kevent_qos"},
        {0x40c05dc, "BSC_#375"},
        {0x40c05e0, "BSC_#376"},
        {0x40c05e4, "BSC_#377"},
        {0x40c05e8, "BSC_#378"},
        {0x40c05ec, "BSC_#379"},
        {0x40c05f0, "BSC_mac_execve"},
        {0x40c05f4, "BSC_mac_syscall"},
        {0x40c05f8, "BSC_mac_get_file"},
        {0x40c05fc, "BSC_mac_set_file"},
        {0x40c0600, "BSC_mac_get_link"},
        {0x40c0604, "BSC_mac_set_link"},
        {0x40c0608, "BSC_mac_get_proc"},
        {0x40c060c, "BSC_mac_set_proc"},
        {0x40c0610, "BSC_mac_get_fd"},
        {0x40c0614, "BSC_mac_set_fd"},
        {0x40c0618, "BSC_mac_get_pid"},
        {0x40c061c, "BSC_#391"},
        {0x40c0620, "BSC_#392"},
        {0x40c0624, "BSC_#393"},
        {0x40c0628, "BSC_pselect"},
        {0x40c062c, "BSC_pselect_nocancel"},
        {0x40c0630, "BSC_read_nocancel"},
        {0x40c0634, "BSC_write_nocancel"},
        {0x40c0638, "BSC_open_nocancel"},
        {0x40c063c, "BSC_close_nocancel"},
        {0x40c0640, "BSC_wait4_nocancel"},
        {0x40c0644, "BSC_recvmsg_nocancel"},
        {0x40c0648, "BSC_sendmsg_nocancel"},
        {0x40c064c, "BSC_recvfrom_nocancel"},
        {0x40c0650, "BSC_accept_nocancel"},
        {0x40c0654, "BSC_msync_nocancel"},
        {0x40c0658, "BSC_fcntl_nocancel"},
        {0x40c065c, "BSC_select_nocancel"},
        {0x40c0660, "BSC_fsync_nocancel"},
        {0x40c0664, "BSC_connect_nocancel"},
        {0x40c0668, "BSC_sigsuspend_nocancel"},
        {0x40c066c, "BSC_readv_nocancel"},
        {0x40c0670, "BSC_writev_nocancel"},
        {0x40c0674, "BSC_sendto_nocancel"},
        {0x40c0678, "BSC_pread_nocancel"},
        {0x40c067c, "BSC_pwrite_nocancel"},
        {0x40c0680, "BSC_waitid_nocancel"},
        {0x40c0684, "BSC_poll_nocancel"},
        {0x40c0688, "BSC_msgsnd_nocancel"},
        {0x40c068c, "BSC_msgrcv_nocancel"},
        {0x40c0690, "BSC_sem_wait_nocancel"},
        {0x40c0694, "BSC_aio_suspend_nocancel"},
        {0x40c0698, "BSC_sigwait_nocancel"},
        {0x40c069c, "BSC_semwait_signal_nocancel"},
        {0x40c06a0, "BSC_mac_mount"},
        {0x40c06a4, "BSC_mac_get_mount"},
        {0x40c06a8, "BSC_mac_getfsstat"},
        {0x40c06ac, "BSC_fsgetpath"},
        {0x40c06b0, "BSC_audit_session_self"},
        {0x40c06b4, "BSC_audit_session_join"},
        {0x40c06b8, "BSC_fileport_makeport"},
        {0x40c06bc, "BSC_fileport_makefd"},
        {0x40c06c0, "BSC_audit_session_port"},
        {0x40c06c4, "BSC_pid_suspend"},
        {0x40c06c8, "BSC_pid_resume"},
        {0x40c06cc, "BSC_#435"},
        {0x40c06d0, "BSC_#436"},
        {0x40c06d4, "BSC_obs_shared_region_slide_np"},
        {0x40c06d8, "BSC_shared_region_map_and_slide_np"},
        {0x40c06dc, "BSC_kas_info"},
        {0x40c06e0, "BSC_memorystatus_control"},
        {0x40c06e4, "BSC_guarded_open_np"},
        {0x40c06e8, "BSC_guarded_close_np"},
        {0x40c06ec, "BSC_guarded_kqueue_np"},
        {0x40c06f0, "BSC_change_fdguard_np"},
        {0x40c06f4, "BSC_usrctl"},
        {0x40c06f8, "BSC_proc_rlimit_control"},
        {0x40c06fc, "BSC_connectx"},
        {0x40c0700, "BSC_disconnectx"},
        {0x40c0704, "BSC_peeloff"},
        {0x40c0708, "BSC_socket_delegate"},
        {0x40c070c, "BSC_telemetry"},
        {0x40c0710, "BSC_proc_uuid_policy"},
        {0x40c0714, "BSC_memorystatus_get_level"},
        {0x40c0718, "BSC_system_override"},
        {0x40c071c, "BSC_vfs_purge"},
        {0x40c0720, "BSC_sfi_ctl"},
        {0x40c0724, "BSC_sfi_pidctl"},
        {0x40c0728, "BSC_coalition"},
        {0x40c072c, "BSC_coalition_info"},
        {0x40c0730, "BSC_necp_match_policy"},
        {0x40c0734, "BSC_getattrlistbulk"},
        {0x40c0738, "BSC_clonefileat"},
        {0x40c073c, "BSC_openat"},
        {0x40c0740, "BSC_openat_nocancel"},
        {0x40c0744, "BSC_renameat"},
        {0x40c0748, "BSC_faccessat"},
        {0x40c074c, "BSC_fchmodat"},
        {0x40c0750, "BSC_fchownat"},
        {0x40c0754, "BSC_fstatat"},
        {0x40c0758, "BSC_fstatat64"},
        {0x40c075c, "BSC_linkat"},
        {0x40c0760, "BSC_unlinkat"},
        {0x40c0764, "BSC_readlinkat"},
        {0x40c0768, "BSC_symlinkat"},
        {0x40c076c, "BSC_mkdirat"},
        {0x40c0770, "BSC_getattrlistat"},
        {0x40c0774, "BSC_proc_trace_log"},
        {0x40c0778, "BSC_bsdthread_ctl"},
        {0x40c077c, "BSC_openbyid_np"},
        {0x40c0780, "BSC_recvmsg_x"},
        {0x40c0784, "BSC_sendmsg_x"},
        {0x40c0788, "BSC_thread_selfusage"},
        {0x40c078c, "BSC_csrctl"},
        {0x40c0790, "BSC_guarded_open_dprotected_np"},
        {0x40c0794, "BSC_guarded_write_np"},
        {0x40c0798, "BSC_guarded_pwrite_np"},
        {0x40c079c, "BSC_guarded_writev_np"},
        {0x40c07a0, "BSC_renameatx_np"},
        {0x40c07a4, "BSC_mremap_encrypted"},
        {0x40c07a8, "BSC_netagent_trigger"},
        {0x40c07ac, "BSC_stack_snapshot_with_config"},
        {0x40c07b0, "BSC_microstackshot"},
        {0x40c07b4, "BSC_grab_pgo_data"},
        {0x40c07b8, "BSC_persona"},
        {0x40c07bc, "BSC_#495"},
        {0x40c07c0, "BSC_#496"},
        {0x40c07c4, "BSC_#497"},
        {0x40c07c8, "BSC_#498"},
        {0x40c07cc, "BSC_work_interval_ctl"},
        {0x40c07d0, "BSC_getentropy"},
        {0x40c07d4, "BSC_necp_open"},
        {0x40c07d8, "BSC_necp_client_action"},
        {0x40c07dc, "BSC_#503"},
        {0x40c07e0, "BSC_#504"},
        {0x40c07e4, "BSC_#505"},
        {0x40c07e8, "BSC_#506"},
        {0x40c07ec, "BSC_#507"},
        {0x40c07f0, "BSC_#508"},
        {0x40c07f4, "BSC_#509"},
        {0x40c07f8, "BSC_#510"},
        {0x40c07fc, "BSC_#511"},
        {0x40c0800, "BSC_#512"},
        {0x40c0804, "BSC_#513"},
        {0x40c0808, "BSC_#514"},
        {0x40c080c, "BSC_ulock_wait"},
        {0x40c0810, "BSC_ulock_wake"},
        {0x40c0814, "BSC_fclonefileat"},
        {0x40c0818, "BSC_fs_snapshot"},
        {0x40c081c, "BSC_#519"},
        {0x40c0820, "BSC_terminate_with_payload"},
        {0x40c0824, "BSC_abort_with_payload"},
        {0x40e0104, "BSC_msync_extended_info"},
        {0x40e0264, "BSC_pread_extended_info"},
        {0x40e0268, "BSC_pwrite_extended_info"},
        {0x40e0314, "BSC_mmap_extended_info"},
        {0x40f0314, "BSC_mmap_extended_info2"},
        {0x5000004, "INTC_Handler"},
        {0x5010004, "WL_CheckForWork"},
        {0x5010008, "WL_RunEventSources"},
        {0x5020004, "IES_client"},
        {0x5020008, "IES_latency"},
        {0x502000c, "IES_sema"},
        {0x5020010, "IES_intctxt"},
        {0x5020014, "IES_intfltr"},
        {0x5020018, "IES_action"},
        {0x502001c, "IES_filter"},
        {0x5030004, "TES_client"},
        {0x5030008, "TES_latency"},
        {0x503000c, "TES_sema"},
        {0x5030010, "TES_action"},
        {0x5040004, "CQ_client"},
        {0x5040008, "CQ_latency"},
        {0x504000c, "CQ_sema"},
        {0x5040010, "CQ_psema"},
        {0x5040014, "CQ_plock"},
        {0x5040018, "CQ_action"},
        {0x5070004, "PM_SetParent"},
        {0x5070008, "PM_AddChild"},
        {0x507000c, "PM_RemoveChild"},
        {0x5070010, "PM_CtrlDriver"},
        {0x5070014, "PM_CtrlDriverErr1"},
        {0x5070018, "PM_CtrlDriverErr2"},
        {0x507001c, "PM_CtrlDriverErr3"},
        {0x5070020, "PM_CtrlDriverErr4"},
        {0x5070024, "PM_InterestDriver"},
        {0x5070028, "PM_InterestDriverAckErr1"},
        {0x507002c, "PM_ChildAck"},
        {0x5070030, "PM_InterestDriverAck"},
        {0x5070034, "PM_InterestDriverAckErr2"},
        {0x5070038, "PM_InterestDriverAckErr3"},
        {0x507003c, "PM_CtrlDriverAckErr4"},
        {0x5070040, "PM_CtrlDriverAck"},
        {0x5070044, "PM_DomainWillChange"},
        {0x5070048, "PM_DomainDidChange"},
        {0x507004c, "PM_RequestDomainState"},
        {0x5070050, "PM_MakeUsable"},
        {0x5070054, "PM_ChangeStateTo"},
        {0x5070058, "PM_ChangeStateToPriv"},
        {0x507005c, "PM_SetAggressiveness"},
        {0x5070060, "PM_CriticalTemp"},
        {0x5070064, "PM_OverrideOn"},
        {0x5070068, "PM_OverrideOff"},
        {0x507006c, "PM_ChangeStateForRoot"},
        {0x5070070, "PM_SynchronizeTree"},
        {0x5070074, "PM_ChangeDone"},
        {0x5070078, "PM_CtrlDriverTardy"},
        {0x507007c, "PM_InterestDriverTardy"},
        {0x5070080, "PM_StartAckTimer"},
        {0x5070084, "PM_StartParentChange"},
        {0x5070088, "PM_AmendParentChange"},
        {0x507008c, "PM_StartDeviceChange"},
        {0x5070090, "PM_RequestDenied"},
        {0x5070094, "PM_CtrlDriverErr5"},
        {0x5070098, "PM_ProgramHardware"},
        {0x507009c, "PM_InformWillChange"},
        {0x50700a0, "PM_InformDidChange"},
        {0x50700a4, "PM_RemoveDriver"},
        {0x50700a8, "PM_SetIdleTimer"},
        {0x50700ac, "PM_SystemWake"},
        {0x50700b4, "PM_ClientAck"},
        {0x50700b8, "PM_ClientTardy"},
        {0x50700bc, "PM_ClientCancel"},
        {0x50700c0, "PM_ClientNotify"},
        {0x50700c4, "PM_AppNotify"},
        {0x50700d4, "PM_IdleCancel"},
        {0x50700d8, "PM_SleepWakeTracePoint"},
        {0x50700dc, "PM_QuiescePowerTree"},
        {0x50700e0, "PM_ComponentWakeProgress"},
        {0x50700e4, "PM_UserActiveState"},
        {0x50700e8, "PM_AppResponseDelay"},
        {0x50700ec, "PM_DriverResponseDelay"},
        {0x50700f0, "PM_PCIDevChangeStart"},
        {0x50700f4, "PM_PCIDevChangeDone"},
        {0x5080004, "IOSERVICE_BUSY"},
        {0x5080008, "IOSERVICE_NONBUSY"},
        {0x508000c, "IOSERVICE_MODULESTALL"},
        {0x5080010, "IOSERVICE_MODULEUNSTALL"},
        {0x5080014, "IOSERVICE_TERM_PHASE1"},
        {0x5080018, "IOSERVICE_TERM_REQUEST_OK"},
        {0x508001c, "IOSERVICE_TERM_REQUEST_FAIL"},
        {0x5080020, "IOSERVICE_TERM_SCHEDULE_STOP"},
        {0x5080024, "IOSERVICE_TERM_SCHEDULE_FINALIZE"},
        {0x5080028, "IOSERVICE_TERM_WILL"},
        {0x508002c, "IOSERVICE_TERM_DID"},
        {0x5080030, "IOSERVICE_TERM_DID_DEFER"},
        {0x5080034, "IOSERVICE_TERM_FINALIZE"},
        {0x5080038, "IOSERVICE_TERM_STOP"},
        {0x508003c, "IOSERVICE_TERM_STOP_NOP"},
        {0x5080040, "IOSERVICE_TERM_STOP_DEFER"},
        {0x5080044, "IOSERVICE_TERM_DONE"},
        {0x5080048, "IOSERVICE_KEXTD_ALIVE"},
        {0x508004c, "IOSERVICE_KEXTD_READY"},
        {0x5080050, "IOSERVICE_REGISTRY_QUIET"},
        {0x5230000, "HID_Unexpected"},
        {0x5230004, "HID_KeyboardLEDThreadTrigger"},
        {0x5230008, "HID_KeyboardLEDThreadActive"},
        {0x523000c, "HID_KeyboardSetParam"},
        {0x5230010, "HID_KeyboardCapsThreadTrigger"},
        {0x5230014, "HID_KeyboardCapsThreadActive"},
        {0x5230018, "HID_PostEvent"},
        {0x523001c, "HID_NewUserClient"},
        {0x5230020, "HID_InturruptReport"},
        {0x5230024, "HID_DispatchScroll"},
        {0x5230028, "HID_DispatchRelativePointer"},
        {0x523002c, "HID_DispatchAbsolutePointer"},
        {0x5230030, "HID_DispatchKeyboard"},
        {0x5230034, "HID_EjectCallback"},
        {0x5230038, "HID_CapsCallback"},
        {0x523003c, "HID_HandleReport"},
        {0x5230040, "HID_DispatchTabletPointer"},
        {0x5230044, "HID_DispatchTabletProx"},
        {0x5230048, "HID_DispatchHIDEvent"},
        {0x523004c, "HID_CalculateCapsDelay"},
        {0x5230050, "HID_Invalid"},
        {0x5310004, "CPUPM_PSTATE"},
        {0x5310008, "CPUPM_IDLE_CSTATE"},
        {0x531000c, "CPUPM_IDLE_HALT"},
        {0x5310010, "CPUPM_IDLE_LOOP"},
        {0x5310014, "CPUPM_HPET_START"},
        {0x5310018, "CPUPM_HPET_END"},
        {0x531001c, "CPUPM_HPET_INTR"},
        {0x5310020, "CPUPM_PSTATE_HW"},
        {0x5310024, "CPUPM_PSTATE_LIMIT"},
        {0x5310028, "CPUPM_PSTATE_PARK"},
        {0x531002c, "CPUPM_PSTATE_START"},
        {0x5310030, "CPUPM_PSTATE_PAUSE"},
        {0x5310034, "CPUPM_PSTATE_RESUME"},
        {0x5310038, "CPUPM_PSTATE_DOWN"},
        {0x531003c, "CPUPM_PSTATE_UP"},
        {0x5310040, "CPUPM_PSTATE_NORM"},
        {0x5310044, "CPUPM_PSTATE_FORCE"},
        {0x5310048, "CPUPM_PSTATE_TIMEOUT"},
        {0x531004c, "CPUPM_PSTATE_SETTO"},
        {0x5310050, "CPUPM_SET_DEADLINE"},
        {0x5310054, "CPUPM_GET_DEADLINE"},
        {0x5310058, "CPUPM_DEADLINE"},
        {0x531005c, "CPUPM_IDLE_SNOOP"},
        {0x5310060, "CPUPM_IDLE_LATENCY"},
        {0x5310064, "CPUPM_IDLE_WAKEUP"},
        {0x5310068, "CPUPM_IDLE_SW_WAKEUP"},
        {0x531006c, "CPUPM_IDLE_SELECT"},
        {0x5310070, "CPUPM_IDLE_SELECTED"},
        {0x5310074, "CPUPM_IDLE_INTSKIP"},
        {0x5310078, "CPUPM_IDLE_LOCK"},
        {0x531007c, "CPUPM_IDLE_UNLOCK"},
        {0x5310080, "CPUPM_IDLE_NO_HPET"},
        {0x5310084, "CPUPM_FI_UP"},
        {0x5310088, "CPUPM_FI_UP_CPU"},
        {0x531008c, "CPUPM_FI_MP"},
        {0x5310090, "CPUPM_FI_MP_CPU"},
        {0x5310094, "CPUPM_FI_PAUSE"},
        {0x5310098, "CPUPM_FI_RUN"},
        {0x531009c, "CPUPM_PROC_HALT"},
        {0x53100a0, "CPUPM_TRACE_STOPPED"},
        {0x53100a4, "CPUPM_HPET_INT_LOCK"},
        {0x53100a8, "CPUPM_HPET_INT_UNLOCK"},
        {0x53100ac, "CPUPM_HPET_TRY_AGAIN"},
        {0x53100b0, "CPUPM_HPET_SETDEADLINE"},
        {0x53100b4, "CPUPM_LOCK_HELDBY"},
        {0x53100b8, "CPUPM_HPET_DELTA"},
        {0x53100bc, "CPUPM_HPET_TOO_LATE"},
        {0x53100c0, "CPUPM_HPET_NO_DEADLINE"},
        {0x53100c4, "CPUPM_IDLE"},
        {0x53100c8, "CPUPM_CORE_CHK_DEADLINE"},
        {0x53100cc, "CPUPM_SET_HPET_DEADLINE"},
        {0x53100d0, "CPUPM_HPET_READ"},
        {0x53100d4, "CPUPM_TIME_ADJUST"},
        {0x53100d8, "CPUPM_IDLE_MWAIT"},
        {0x53100dc, "CPUPM_FI_SLAVE_IDLE"},
        {0x53100e0, "CPUPM_FI_SLAVE_BLOCK"},
        {0x53100e4, "CPUPM_FI_MAST_SIGNAL"},
        {0x53100e8, "CPUPM_CORE_DEADLINE"},
        {0x53100ec, "CPUPM_IDLE_FAST"},
        {0x53100f0, "CPUPM_IDLE_PAUSE"},
        {0x53100f4, "CPUPM_IDLE_SHORT"},
        {0x53100f8, "CPUPM_IDLE_NORMAL"},
        {0x53100fc, "CPUPM_IDLE_SPURIOUS"},
        {0x5310100, "CPUPM_PSTATE_INFO"},
        {0x5310104, "CPUPM_PSTATE_INFO_HW"},
        {0x5310108, "CPUPM_PSTATE_FSM"},
        {0x531010c, "CPUPM_PSTATE_FSM_STEP"},
        {0x5310110, "CPUPM_PSTATE_FSM_EVAL"},
        {0x5310114, "CPUPM_PSTATE_FSM_MAP"},
        {0x5310118, "CPUPM_CPUSTEP_STEP"},
        {0x531011c, "CPUPM_CPUSTEP_STEP_UP"},
        {0x5310120, "CPUPM_CPUSTEP_STEP_DOWN"},
        {0x5310124, "CPUPM_CPUSTEP_AVAIL"},
        {0x5310128, "CPUPM_CPUSTEP_AVAIL_STEP"},
        {0x531012c, "CPUPM_CPUSTEP_AVAIL_CHNG"},
        {0x5310130, "CPUPM_CPUSTEP_LOAD"},
        {0x5310134, "CPUPM_CPUSTEP_START"},
        {0x5310138, "CPUPM_CPUSTEP_STOP"},
        {0x531013c, "CPUPM_CPUSTEP_COPY"},
        {0x5310140, "CPUPM_CPUSTEP_CLEAR"},
        {0x5310144, "CPUPM_CPUSTEP_RUNCOUNT"},
        {0x5310148, "CPUPM_CPUSTEP_WAKEUP"},
        {0x531014c, "CPUPM_PSTATE_TRACE"},
        {0x5310150, "CPUPM_PSTATE_EVENT"},
        {0x5310154, "CPUPM_IDLE_RATE"},
        {0x5310158, "CPUPM_PSTATE_FSM_RESUME"},
        {0x531015c, "CPUPM_PSTATE_FSM_PAUSE"},
        {0x5310160, "CPUPM_PSTATE_INSTRUCTION"},
        {0x5310164, "CPUPM_PSTATE_INST_ARG"},
        {0x5310168, "CPUPM_PSTATE_STACK_PUSH"},
        {0x531016c, "CPUPM_PSTATE_STACK_POP"},
        {0x5310170, "CPUPM_IDLE_PREFIRE"},
        {0x5310174, "CPUPM_PSTATE_VERIFY"},
        {0x5310178, "CPUPM_TIMER_MIGRATE"},
        {0x531017c, "CPUPM_RING_LIMIT"},
        {0x5310180, "CPUPM_CONTEXT_PAUSE"},
        {0x5310184, "CPUPM_CONTEXT_RESUME"},
        {0x5310188, "CPUPM_CONTEXT_RESUME_INFO"},
        {0x531018c, "CPUPM_THREAD_RESUME"},
        {0x5310190, "CPUPM_THREAD_PAUSE_INFO"},
        {0x5310194, "CPUPM_THREAD_RESUME_INFO"},
        {0x5310198, "CPUPM_TEST_MASTER_INFO"},
        {0x531019c, "CPUPM_TEST_SLAVE_INFO"},
        {0x53101a0, "CPUPM_TEST_INFO"},
        {0x53101a4, "CPUPM_TEST_RUN_INFO"},
        {0x53101a8, "CPUPM_TEST_SLAVE_INFO"},
        {0x53101ac, "CPUPM_FORCED_IDLE"},
        {0x53101b4, "CPUPM_PSTATE_CHOOSE"},
        {0x53101b8, "CPUPM_PSTATE_COMMIT"},
        {0x53101bc, "CPUPM_PSTATE_CHECK"},
        {0x5310200, "CPUPM_PST_RESOLVE"},
        {0x5310204, "CPUPM_PST_LOAD_TXFR"},
        {0x5310208, "CPUPM_PST_IDLE_EXIT"},
        {0x531020c, "CPUPM_PST_IDLE_ENTRY"},
        {0x5310210, "CPUPM_PST_TIMER"},
        {0x5310214, "CPUPM_PST_MAXBUS"},
        {0x5310218, "CPUPM_PST_MAXINT"},
        {0x531021c, "CPUPM_PST_PLIMIT"},
        {0x5310220, "CPUPM_PST_SELFSEL"},
        {0x5310224, "CPUPM_PST_RATELIMIT"},
        {0x5310228, "CPUPM_PST_RATEUNLIMIT"},
        {0x531022c, "CPUPM_DVFS_PAUSE"},
        {0x5310230, "CPUPM_DVFS_RESUME"},
        {0x5310234, "CPUPM_DVFS_ADVANCE"},
        {0x5310238, "CPUPM_DVFS_TRANSIT"},
        {0x531023c, "CPUPM_TQM"},
        {0x5310240, "CPUPM_QUIESCE"},
        {0x5310244, "CPUPM_MBD"},
        {0x5310248, "CPUPM_PST_RATELIMIT_QOS"},
        {0x531024c, "CPUPM_PST_QOS_RATEUNLIMIT"},
        {0x5310250, "CPUPM_PST_QOS_SWITCH"},
        {0x5310254, "CPUPM_FORCED_IDLE"},
        {0x5310258, "CPUPM_PST_RAW_PERF"},
        {0x531025c, "CPUPM_CPU_HALT_DEEP"},
        {0x5310260, "CPUPM_CPU_HALT"},
        {0x5310264, "CPUPM_CPU_OFFLINE"},
        {0x5310268, "CPUPM_CPU_EXIT_HALT"},
        {0x531026c, "CPUPM_PST_QOS_CHARGE"},
        {0x5310270, "CPUPM_PST_QOS_APPLY"},
        {0x5310274, "CPUPM_PST_QOS_SWITCH2"},
        {0x5310278, "CPUPM_PST_UIB"},
        {0x531027c, "CPUPM_PST_PLIMIT_UIB"},
        {0x5310280, "CPUPM_IO"},
        {0x5310284, "CPUPM_FI"},
        {0x5330000, "HIBERNATE"},
        {0x5330004, "HIBERNATE_WRITE_IMAGE"},
        {0x5330008, "HIBERNATE_MACHINE_INIT"},
        {0x533000c, "HIBERNATE_FLUSH_MEMORY"},
        {0x5330010, "HIBERNATE_flush_queue"},
        {0x5330014, "HIBERNATE_flush_wait"},
        {0x5330018, "HIBERNATE_flush_in_progress"},
        {0x533001c, "HIBERNATE_flush_bufs"},
        {0x5330020, "HIBERNATE_page_list_setall"},
        {0x5330024, "HIBERNATE_aes_decrypt_cbc"},
        {0x5330028, "HIBERNATE_flush_compressor"},
        {0x533002c, "HIBERNATE_fastwake_warmup"},
        {0x7000004, "TRACE_DATA_NEWTHREAD"},
        {0x7000008, "TRACE_DATA_EXEC"},
        {0x700000c, "TRACE_DATA_THREAD_TERMINATE"},
        {0x7000010, "TRACE_DATA_THREAD_TERMINATE_PID"},
        {0x7010000, "TRACE_STRING_GLOBAL"},
        {0x7010004, "TRACE_STRING_NEWTHREAD"},
        {0x7010008, "TRACE_STRING_EXEC"},
        {0x701000c, "TRACE_STRING_PROC_EXIT"},
        {0x7010010, "TRACE_STRING_THREADNAME"},
        {0x7020000, "TRACE_PANIC"},
        {0x7020004, "TRACE_TIMESTAMPS"},
        {0x7020008, "TRACE_LOST_EVENTS"},
        {0x702000c, "TRACE_WRITING_EVENTS"},
        {0x7020010, "TRACE_INFO_STRING"},
        {0x8000000, "USER_TEST"},
        {0x8000004, "USER_run"},
        {0x8000008, "USER_join"},
        {0x800000c, "USER_create"},
        {0x8000010, "USER_pthread_create"},
        {0x8000014, "USER_pthread_exit"},
        {0x8000018, "USER_pthread_join"},
        {0x800001c, "USER_pthread_run"},
        {0x8000020, "USER_pthread_cleanup_push"},
        {0x8000100, "FW_underrun"},
        {0x8000104, "FW_interrupt"},
        {0x8000108, "FW_workloop"},
        {0x8010400, "F_DLIL_Input"},
        {0x8010800, "F_DLIL_Output"},
        {0x8010c00, "F_DLIL_IfOut"},
        {0x8040000, "USER_STOP"},
        {0x9000084, "wq_deallocate_stack"},
        {0x9000088, "wq_allocate_stack"},
        {0x9008070, "wq_run_item"},
        {0x9008074, "wq_clean_thread"},
        {0x9008078, "wq_post_done"},
        {0x900807c, "wq_stk_cleanup"},
        {0x9008080, "wq_tsd_cleanup"},
        {0x9008084, "wq_tsd_destructor"},
        {0x9008088, "wq_pthread_exit"},
        {0x900808c, "wq_workqueue_exit"},
        {0xa000100, "P_CS_Read"},
        {0xa000104, "P_CS_ReadDone"},
        {0xa000110, "P_CS_Write"},
        {0xa000114, "P_CS_WriteDone"},
        {0xa000200, "P_CS_ReadChunk"},
        {0xa000204, "P_CS_ReadChunkDone"},
        {0xa000210, "P_CS_WriteChunk"},
        {0xa000214, "P_CS_WriteChunkDone"},
        {0xa000300, "P_CS_ReadMeta"},
        {0xa000304, "P_CS_ReadMetaDone"},
        {0xa000310, "P_CS_WriteMeta"},
        {0xa000314, "P_CS_WriteMetaDone"},
        {0xa000400, "P_CS_ReadCrypto"},
        {0xa000404, "P_CS_ReadCryptoDone"},
        {0xa000410, "P_CS_WriteCrypto"},
        {0xa000414, "P_CS_WriteCryptoDone"},
        {0xa000500, "P_CS_TransformRead"},
        {0xa000504, "P_CS_TransformReadDone"},
        {0xa000510, "P_CS_TransformWrite"},
        {0xa000514, "P_CS_TransformWriteDone"},
        {0xa000600, "P_CS_MigrationRead"},
        {0xa000604, "P_CS_MigrationReadDone"},
        {0xa000610, "P_CS_MigrationWrite"},
        {0xa000614, "P_CS_MigrationWriteDone"},
        {0xa000700, "P_CS_DirectRead"},
        {0xa000704, "P_CS_DirectReadDone"},
        {0xa000710, "P_CS_DirectWrite"},
        {0xa000714, "P_CS_DirectWriteDone"},
        {0xa008000, "P_CS_SYNC_DISK"},
        {0xa008004, "P_CS_WaitForBuffer"},
        {0xa008008, "P_CS_NoBuffer"},
        {0xb000000, "AFP_asp_tcp_usr_send"},
        {0xb000004, "AFP_asp_tcp_usr_send_after_Request"},
        {0xb000008, "AFP_asp_tcp_usr_send_after_FindDSIReq"},
        {0xb00000c, "AFP_asp_tcp_usr_send_after_Reply"},
        {0xb000010, "AFP_asp_tcp_slowtimo"},
        {0xb000014, "AFP_asp_tcp_usr_control"},
        {0xb000018, "AFP_asp_tcp_fasttimo"},
        {0xb000020, "AFP_Send"},
        {0xb000024, "AFP_Send_before_sosend"},
        {0xb000028, "AFP_Send_after_sosend"},
        {0xb00002c, "AFP_Send_before_write"},
        {0xb000030, "AFP_Send_after_write"},
        {0xb000040, "AFP_Reply"},
        {0xb000044, "AFP_Reply_rcvdAlready"},
        {0xb000048, "AFP_Reply_before_RcvLock"},
        {0xb00004c, "AFP_Reply_fail_RcvLock"},
        {0xb000050, "AFP_Reply_before_ReadDSIHdr"},
        {0xb000054, "AFP_Reply_after_ReadDSIHdr"},
        {0xb000058, "AFP_Reply_fail_ReadDSIHdr"},
        {0xb00005c, "AFP_Reply_after_FindDSIReqInfo"},
        {0xb000060, "AFP_Reply_SetAFPCmd"},
        {0xb000064, "AFP_Reply_before_ReadDSIPacket"},
        {0xb000068, "AFP_Reply_setRcvdReplyLen"},
        {0xb000070, "AFP_SendReply"},
        {0xb000080, "AFP_CreateDSIHeader"},
        {0xb000084, "AFP_CreateDSIHeader_after_GetReqID"},
        {0xb000090, "AFP_Request"},
        {0xb0000a0, "AFP_ReceiveLock"},
        {0xb0000b0, "AFP_ReceiveWakeUp"},
        {0xb0000c0, "AFP_ReceiveUnLock"},
        {0xb0000e0, "AFP_SendLock"},
        {0xb0000e4, "AFP_SendUnLock"},
        {0xb0000f0, "AFP_SendQueueLock"},
        {0xb000100, "AFP_SendQueueUnLock"},
        {0xb000110, "AFP_ReadDSIHeader"},
        {0xb000120, "AFP_Receive"},
        {0xb000124, "AFP_Receive_before_sorcv"},
        {0xb000128, "AFP_Receive_after_sorcv"},
        {0xb000130, "AFP_ReadDSIPacket"},
        {0xb000140, "AFP_DoCopyOut"},
        {0xb000150, "AFP_DoCopyIn"},
        {0xb000160, "AFP_CheckRcvTickle"},
        {0xb000164, "AFP_CheckRcvTickleTO"},
        {0xb000170, "AFP_CheckSendTickle"},
        {0xb000180, "AFP_CheckIncomingPkts"},
        {0xb000190, "AFP_ProcessOptions"},
        {0xb000200, "AFP_FindDSIReqInfo"},
        {0xb000204, "AFP_FindDSIReqInfo_foundReqInfo"},
        {0xb000208, "AFP_FindDSIReqInfo_flags"},
        {0xb00020c, "AFP_FindDSIReqLeave"},
        {0xb000210, "AFP_UsrDisconnect"},
        {0xc000000, "AFPVFS_UserReply"},
        {0xc000004, "AFPVFS_UserReplyGetMbuf"},
        {0xc000008, "AFPVFS_UserReplysosend"},
        {0xc000010, "AFPVFS_UserCommand"},
        {0xc000018, "AFPVFS_UserCommandsosend"},
        {0xc000020, "AFPVFS_ReadFork"},
        {0xc000024, "AFPVFS_ReadForkFillQPB"},
        {0xc000028, "AFPVFS_ReadForkNbrRequests"},
        {0xc00002c, "AFPVFS_ReadForkSendQPB"},
        {0xc000030, "AFPVFS_ReadForkSendErr"},
        {0xc000040, "AFPVFS_ReadForkGetReply"},
        {0xc000044, "AFPVFS_ReadForkGetReplyResult"},
        {0xc000050, "AFPVFS_WriteFork"},
        {0xc000054, "AFPVFS_WriteForkFillQPB"},
        {0xc000058, "AFPVFS_WriteForkNbrRequests"},
        {0xc00005c, "AFPVFS_WriteForkSendQPB"},
        {0xc000060, "AFPVFS_WriteForkSendErr"},
        {0xc000064, "AFPVFS_WriteForkGetReply"},
        {0xc000068, "AFPVFS_WriteForkGetReplyResult"},
        {0xc000070, "AFPVFS_GetAttr"},
        {0xc000080, "AFPVFS_SetAttr"},
        {0xc000090, "AFPVFS_GetAttrList"},
        {0xc0000a0, "AFPVFS_SetAttrList"},
        {0xc0000b0, "AFPVFS_FSCTL"},
        {0xc0000c0, "AFPVFS_LookUp"},
        {0xc0000d0, "AFPVFS_CacheLookUp"},
        {0xc0000e0, "AFPVFS_Write"},
        {0xc0000e4, "AFPVFS_WriteNoCluster"},
        {0xc0000e8, "AFPVFS_WriteDone"},
        {0xc0000f0, "AFPVFS_DoWrite"},
        {0xc000100, "AFPVFS_Lock"},
        {0xc000110, "AFPVFS_Statfs"},
        {0xc000120, "AFPVFS_Sync"},
        {0xc000130, "AFPVFS_VGet"},
        {0xc000140, "AFPVFS_FlushFiles"},
        {0xc000150, "AFPVFS_Create"},
        {0xc000160, "AFPVFS_Mknod"},
        {0xc000170, "AFPVFS_Open"},
        {0xc000180, "AFPVFS_Close"},
        {0xc000190, "AFPVFS_Access"},
        {0xc000194, "AFPVFS_AccessUID"},
        {0xc000198, "AFPVFS_AccessGID"},
        {0xc00019c, "AFPVFS_AccessWID"},
        {0xc0001a0, "AFPVFS_Writeperm"},
        {0xc0001b0, "AFPVFS_Chmod"},
        {0xc0001c0, "AFPVFS_Chflags"},
        {0xc0001d0, "AFPVFS_Exchange"},
        {0xc0001e0, "AFPVFS_Chid"},
        {0xc0001f0, "AFPVFS_Fsync"},
        {0xc000200, "AFPVFS_Remove"},
        {0xc000210, "AFPVFS_Rename"},
        {0xc000220, "AFPVFS_Copyfile"},
        {0xc000230, "AFPVFS_Mkdir"},
        {0xc000240, "AFPVFS_Symlink"},
        {0xc000250, "AFPVFS_Readdir"},
        {0xc000260, "AFPVFS_Readdirattr"},
        {0xc000264, "AFPVFS_Readdirattr1"},
        {0xc000268, "AFPVFS_Readdirattr2"},
        {0xc00026c, "AFPVFS_Readdirattr3"},
        {0xc000270, "AFPVFS_Readlink"},
        {0xc000280, "AFPVFS_Abortop"},
        {0xc000290, "AFPVFS_Inactive"},
        {0xc0002a0, "AFPVFS_Reclaim"},
        {0xc0002b0, "AFPVFS_Unlock"},
        {0xc0002c0, "AFPVFS_Islocked"},
        {0xc0002d0, "AFPVFS_Pathconf"},
        {0xc0002e0, "AFPVFS_Update"},
        {0xc0002f0, "AFPVFS_Makenode"},
        {0xc000300, "AFPVFS_Allocate"},
        {0xc000310, "AFPVFS_Search"},
        {0xc000320, "AFPVFS_Reconnect"},
        {0xc0003e0, "AFPVFS_Rmdir"},
        {0xc0003f0, "AFPVFS_Vinit"},
        {0x11000000, "DNC_PURGE1"},
        {0x11000004, "DNC_PURGE2"},
        {0x11000008, "DNC_FOUND"},
        {0x1100000c, "DNC_FAILED"},
        {0x11000010, "DNC_ENTER"},
        {0x11000014, "DNC_remove_name"},
        {0x11000018, "DNC_ENTER_CREATE"},
        {0x1100001c, "DNC_update_identity"},
        {0x11000020, "DNC_PURGE"},
        {0x11000030, "DNC_LOOKUP_PATH"},
        {0x11000038, "NAMEI"},
        {0x11000048, "VFS_SUSPENDED"},
        {0x1100004c, "VFS_CACHEPURGE"},
        {0x11000050, "VFS_CACHELOOKUP_SUCCESS"},
        {0x11000054, "VFS_CACHELOOKUP_FAILED"},
        {0x11000058, "VFS_CACHELOOKUP_ENTER"},
        {0x1100005c, "VFS_CACHELOOKUP"},
        {0x11000060, "VFS_GETIOCOUNT"},
        {0x11000064, "VFS_vnode_recycle"},
        {0x11000068, "VFS_vnode_reclaim"},
        {0x11000080, "VOLFS_lookup"},
        {0x11000084, "lookup_mountedhere"},
        {0x11000088, "VNOP_LOOKUP"},
        {0x11000090, "VFS_vnode_rele"},
        {0x11000094, "VFS_vnode_put"},
        {0x11004100, "NC_lock_shared"},
        {0x11004104, "NC_lock_exclusive"},
        {0x11004108, "NC_unlock"},
        {0x1e000000, "SEC_ENTROPY_READ0"},
        {0x1e000004, "SEC_ENTROPY_READ1"},
        {0x1e000008, "SEC_ENTROPY_READ2"},
        {0x1e00000c, "SEC_ENTROPY_READ3"},
        {0x1f000000, "DYLD_initialize"},
        {0x1f010000, "DYLD_CALL_image_init_routine"},
        {0x1f010004, "DYLD_CALL_dependent_init_routine"},
        {0x1f010008, "DYLD_CALL_lazy_init_routine"},
        {0x1f01000c, "DYLD_CALL_module_init_for_library"},
        {0x1f010010, "DYLD_CALL_module_init_for_object"},
        {0x1f010014, "DYLD_CALL_module_terminator_for_object"},
        {0x1f010018, "DYLD_CALL_module_init_for_dylib"},
        {0x1f01001c, "DYLD_CALL_mod_term_func"},
        {0x1f010020, "DYLD_CALL_object_func"},
        {0x1f010024, "DYLD_CALL_library_func"},
        {0x1f010028, "DYLD_CALL_add_image_func"},
        {0x1f01002c, "DYLD_CALL_remove_image_func"},
        {0x1f010030, "DYLD_CALL_link_object_module_func"},
        {0x1f010034, "DYLD_CALL_link_library_module_func"},
        {0x1f010038, "DYLD_CALL_link_module_func"},
        {0x1f020000, "DYLD_lookup_and_bind_with_hint"},
        {0x1f020004, "DYLD_lookup_and_bind_fully"},
        {0x1f020008, "DYLD_link_module"},
        {0x1f02000c, "DYLD_ulink_module"},
        {0x1f020010, "DYLD_bind_objc_module"},
        {0x1f020014, "DYLD_bind_fully_image_containing_address"},
        {0x1f020018, "DYLD_make_delayed_module_initializer_calls"},
        {0x1f02001c, "DYLD_NSNameOfSymbol"},
        {0x1f020020, "DYLD_NSAddressOfSymbol"},
        {0x1f020024, "DYLD_NSModuleForSymbol"},
        {0x1f020028, "DYLD_NSLookupAndBindSymbolWithHint"},
        {0x1f02002c, "DYLD_NSLookupSymbolInModule"},
        {0x1f020030, "DYLD_NSLookupSymbolInImage"},
        {0x1f020034, "DYLD_NSIsSymbolNameDefined"},
        {0x1f020038, "DYLD_NSIsSymbolNameDefinedWithHint"},
        {0x1f02003c, "DYLD_NSIsSymbolNameDefinedInImage"},
        {0x1f020040, "DYLD_NSNameOfModule"},
        {0x1f020044, "DYLD_NSLibraryNameForModule"},
        {0x1f020048, "DYLD_NSAddLibrary"},
        {0x1f02004c, "DYLD_NSAddLibraryWithSearching"},
        {0x1f020050, "DYLD_NSAddImage"},
        {0x1f030000, "DYLD_lookup_symbol"},
        {0x1f030004, "DYLD_bind_lazy_symbol_reference"},
        {0x1f030008, "DYLD_bind_symbol_by_name"},
        {0x1f03000c, "DYLD_link_in_need_modules"},
        {0x1f040000, "DYLD_map_image"},
        {0x1f040004, "DYLD_load_executable_image"},
        {0x1f040008, "DYLD_load_library_image"},
        {0x1f04000c, "DYLD_map_library_image"},
        {0x1f040010, "DYLD_map_bundle_image"},
        {0x1f040014, "DYLD_load_dependent_libraries"},
        {0x1f040018, "DYLD_notify_prebinding_agent"},
        {0x1f050000, "DYLD_uuid_map_a"},
        {0x1f050004, "DYLD_uuid_map_b"},
        {0x1f050008, "DYLD_uuid_map_32_a"},
        {0x1f05000c, "DYLD_uuid_map_32_b"},
        {0x1f050010, "DYLD_uuid_map_32_c"},
        {0x1f050014, "DYLD_uuid_unmap_a"},
        {0x1f050018, "DYLD_uuid_unmap_b"},
        {0x1f05001c, "DYLD_uuid_unmap_32_a"},
        {0x1f050020, "DYLD_uuid_unmap_32_b"},
        {0x1f050024, "DYLD_uuid_unmap_32_c"},
        {0x1f050028, "DYLD_uuid_shared_cache_a"},
        {0x1f05002c, "DYLD_uuid_shared_cache_b"},
        {0x1f050030, "DYLD_uuid_shared_cache_32_a"},
        {0x1f050034, "DYLD_uuid_shared_cache_32_b"},
        {0x1f050038, "DYLD_uuid_shared_cache_32_c"},
        {0x1ff10000, "SCROLL_BEGIN_obs"},
        {0x1ff10100, "SCROLL_END_obs"},
        {0x1ff20000, "BOOT_BEGIN_obs"},
        {0x1ff20100, "BOOT_END_obs"},
        {0x1ff20400, "APP_DidActivateWindow_obs"},
        {0x1ff20500, "TOOL_PRIVATE_1_obs"},
        {0x1ff20504, "TOOL_PRIVATE_2_obs"},
        {0x1ff20508, "TOOL_PRIVATE_3_obs"},
        {0x1ff2050c, "TOOL_PRIVATE_4_obs"},
        {0x1fff0000, "LAUNCH_START_FINDER"},
        {0x1fff0100, "LAUNCH_START_DOCK"},
        {0x1fff0200, "LAUNCH_LSOpen"},
        {0x1fff0204, "LAUNCH_LSRegisterItem"},
        {0x1fff0208, "LAUNCH_LSGetApplicationAndFlagsForInfo"},
        {0x1fff0300, "LAUNCH_CPSLaunch"},
        {0x1fff0304, "LAUNCH_CPSRegisterwithServer"},
        {0x1fff0308, "LAUNCH_CGSCheckInNewProcess"},
        {0x1fff030c, "LAUNCH_CPSExecProcess"},
        {0x1fff0310, "LAUNCH_APP_EnterEventLoop"},
        {0x1fff0314, "LAUNCH_APP_WillOpenUntitled"},
        {0x1fff031c, "LAUNCH_APP_DidOpenUntitled"},
        {0x1fff1000, "LAUNCH_END"},
        {0x1fffffff, "LAUNCH_END"},
        {0x20000004, "RTC_sync_TBR"},
        {0x21010000, "SCROLL_BEGIN"},
        {0x21020000, "BOOT_BEGIN"},
        {0x21030200, "LOGIN_BEGIN"},
        {0x21030204, "LOGINWINDOW_LAUNCHED"},
        {0x21030208, "LOGINWINDOW_LAUNCHES_SA"},
        {0x2103020c, "LOGINWINDOW_GUI_APPEARS"},
        {0x21030210, "LOGINWINDOW_LOGIN_CLICKED"},
        {0x21030214, "LOGINWINDOW_ASKS_AUTH"},
        {0x21030218, "LOGINWINDOW_AUTH_SUCCEEDED"},
        {0x2103021c, "LOGINWINDOW_LAUNCHES_DOCK"},
        {0x21030220, "LOGINWINDOW_LAUNCHES_SUIS"},
        {0x21030224, "LOGINWINDOW_LAUNCHES_FINDER"},
        {0x21030228, "LOGINWINDOW_DOCK_LAUNCHED"},
        {0x2103022c, "LOGINWINDOW_SUIS_LAUNCHED"},
        {0x21030230, "LOGINWINDOW_FINDER_LAUNCHED"},
        {0x21030234, "LOGINWINDOW_LOGOUT_CLICKED"},
        {0x21030238, "LOGINWINDOW_QUIT_FGAPPS"},
        {0x2103023c, "LOGINWINDOW_FGAPPS_QUIT"},
        {0x21030240, "LOGINWINDOW_QUIT_SUIS"},
        {0x21030244, "LOGINWINDOW_SUIS_DIES"},
        {0x21030248, "LOGINWINDOW_QUIT_FINDER"},
        {0x2103024c, "LOGINWINDOW_FINDER_DIES"},
        {0x21030250, "LOGINWINDOW_QUIT_DOCK"},
        {0x21030254, "LOGINWINDOW_DOCK_DIES"},
        {0x21030258, "LOGINWINDOW_EXIT"},
        {0x2103025c, "LOGINWINDOW_FUS_SELUSERNAME"},
        {0x21030260, "LOGINWINDOW_FUS_SELLOGINWIND"},
        {0x21030270, "LOGIN_APPLICATION_EXECUTING"},
        {0x21030274, "LOGIN_APPLICATION_USABLE"},
        {0x21030300, "LOGIN_END"},
        {0x21030500, "LOGINWINDOW_APP_TERMINATION_REQUEST"},
        {0x21030504, "LOGINWINDOW_LOGOUT_START"},
        {0x21030508, "LOGINWINDOW_DESKTOP_UP"},
        {0x2103050c, "LOGINWINDOW_DESKTOP_UP_NOTIFICATION"},
        {0x21030510, "LOGINWINDOW_DISPLAYWAKE"},
        {0x21030514, "LOGINWINDOW_SYSTEMWAKE"},
        {0x21030518, "LOGINWINDOW_UNLOCKUI_TRIGGERED"},
        {0x2103051c, "LOGINWINDOW_UNLOCKUI_SHOWN"},
        {0x21030520, "LOGINWINDOW_NO_LOCKUI_SHOWN"},
        {0x21040000, "APP_AudioOverload"},
        {0x21050000, "TOOL_PRIVATE_1"},
        {0x21050004, "TOOL_PRIVATE_2"},
        {0x21050008, "TOOL_PRIVATE_3"},
        {0x2105000c, "TOOL_PRIVATE_4"},
        {0x21060000, "LAUNCH_CPSTraceLineNum"},
        {0x21060004, "LAUNCH_CPSLaunch"},
        {0x21060008, "LAUNCH_CPSRegisterwithServer"},
        {0x2106000c, "LAUNCH_CPSCheckInNewProcess"},
        {0x21060010, "LAUNCH_CPSServerSideLaunch"},
        {0x21060014, "LAUNCH_CPSExecProcess"},
        {0x21070000, "LAUNCH_LSOpen"},
        {0x21070004, "LAUNCH_LSRegisterItem"},
        {0x21070008, "LAUNCH_LSGetApplicationAndFlagsForInfo"},
        {0x21080000, "MCX_DAEMON_START"},
        {0x21080004, "MCX_DAEMON_FINISH"},
        {0x21080008, "MCX_STARTMCX_START"},
        {0x2108000c, "MCX_STARTMCX_FINISH"},
        {0x21080010, "MCX_POSTCMP_DOCK_START"},
        {0x21080014, "MCX_POSTCMP_DOCK_FINISH"},
        {0x21080020, "MCX_POSTCMP_ENERGYSVR_START"},
        {0x21080024, "MCX_POSTCMP_ENERGYSVR_FINISH"},
        {0x21080030, "MCX_POSTCMP_LOGINITMS_START"},
        {0x21080034, "MCX_POSTCMP_LOGINITMS_FINISH"},
        {0x21080040, "MCX_CMP_COMPUTERINFO_START"},
        {0x21080044, "MCX_CMP_COMPUTERINFO_FINISH"},
        {0x21080050, "MCX_CMP_USERINFO_START"},
        {0x21080054, "MCX_CMP_USERINFO_FINISH"},
        {0x21080060, "MCX_POSTCMP_USER_START"},
        {0x21080064, "MCX_POSTCMP_USER_FINISH"},
        {0x210800a0, "MCX_MECHANISM_START"},
        {0x210800a4, "MCX_MECHANISM_FINISH"},
        {0x210800c0, "MCX_MECHANISM_PICKER_START"},
        {0x210800c4, "MCX_MECHANISM_PICKER_FINISH"},
        {0x21080100, "MCX_APPITEMS_START"},
        {0x21080104, "MCX_APPITEMS_FINISH"},
        {0x21080200, "MCX_CACHER_START"},
        {0x21080204, "MCX_CACHER_FINISH"},
        {0x21080300, "MCX_COMPOSITOR_START"},
        {0x21080304, "MCX_COMPOSITOR_FINISH"},
        {0x21080400, "MCX_DISKSETUP_START"},
        {0x21080404, "MCX_DISKSETUP_FINISH"},
        {0x21090000, "PHD_DAEMON_START"},
        {0x21090004, "PHD_DAEMON_FINISH"},
        {0x21090010, "PHD_SYNCNOW_START"},
        {0x21090014, "PHD_SYNCNOW_FINISH"},
        {0x210b0000, "TAL_APP_LAUNCH_START"},
        {0x210b0004, "TAL_APP_LAUNCH_UNSUSPENDED"},
        {0x210b0008, "TAL_APP_LAUNCH_UNTHROTTLED"},
        {0x210b000c, "TAL_APP_LAUNCH_VISIBLE"},
        {0x210b0010, "TAL_APP_LAUNCH_READY"},
        {0x210b0014, "TAL_ALL_LAUNCH_READY"},
        {0x210c0000, "NSAPPLICATION_RECEIVED_KEYEVENT"},
        {0x210c0004, "NSWINDOW_FLUSHED"},
        {0x210c0008, "NSTEXTVIEW_PROCESSED_KEYEVENT"},
        {0x25000000, "PERF_Event"},
        {0x25010000, "PERF_THD_Sample"},
        {0x25010004, "PERF_THD_Data"},
        {0x25010008, "PERF_THD_XSample"},
        {0x2501000c, "PERF_THD_XPend"},
        {0x25010010, "PERF_THD_XData"},
        {0x25010014, "PERF_THD_CSwitch"},
        {0x25010018, "PERF_THD_Sched_Sample"},
        {0x2501001c, "PERF_THD_Sched_Data"},
        {0x25010020, "PERF_THD_Snap_Sample"},
        {0x25010024, "PERF_THD_Snap_Data"},
        {0x25010028, "PERF_THD_Disp_Sample"},
        {0x2501002c, "PERF_THD_Disp_Data"},
        {0x25010030, "PERF_THD_Disp_Pend"},
        {0x25010034, "PERF_THD_Snap_Data_32"},
        {0x25010038, "PERF_THD_Disp_Data_32"},
        {0x2501003c, "PERF_THD_Sched_Data1_32"},
        {0x25010040, "PERF_THD_Sched_Data2_32"},
        {0x25020000, "PERF_STK_KSample"},
        {0x25020004, "PERF_STK_USched"},
        {0x25020008, "PERF_STK_USample"},
        {0x2502000c, "PERF_STK_KData"},
        {0x25020010, "PERF_STK_UData"},
        {0x25020014, "PERF_STK_KHdr"},
        {0x25020018, "PERF_STK_UHdr"},
        {0x2502001c, "PERF_STK_Error"},
        {0x25020020, "PERF_STK_Backtrace"},
        {0x25020024, "PERF_STK_Log"},
        {0x25030000, "PERF_TMR_AllSched"},
        {0x25030004, "PERF_TMR_Schedule"},
        {0x25030008, "PERF_TMR_Handler"},
        {0x25040000, "PERF_ATS_Thread"},
        {0x25040004, "PERF_ATS_Error"},
        {0x25040008, "PERF_ATS_Run"},
        {0x2504000c, "PERF_ATS_Pause"},
        {0x25040010, "PERF_ATS_Idle"},
        {0x25040014, "PERF_ATS_Sample"},
        {0x25040018, "PERF_PET_Sched"},
        {0x2504001c, "PERF_PET_End"},
        {0x25040020, "PERF_PET_Sample_Task"},
        {0x25040024, "PERF_PET_Sample_Thread"},
        {0x25050000, "PERF_AST_Handler"},
        {0x25050004, "PERF_AST_Error"},
        {0x25060000, "PERF_KPC_Handler"},
        {0x25060004, "PERF_KPC_FCounter"},
        {0x25060008, "PERF_KPC_Counter"},
        {0x2506000c, "PERF_KPC_Data"},
        {0x25060010, "PERF_KPC_Config"},
        {0x25060014, "PERF_KPC_ConfReg"},
        {0x25060018, "PERF_KPC_Data32"},
        {0x2506001c, "PERF_KPC_ConfReg32"},
        {0x25060020, "PERF_KPC_Data_Thread"},
        {0x25060024, "PERF_KPC_Data_Thread32"},
        {0x25060028, "PERF_KPC_CPU_Sample"},
        {0x2506002c, "PERF_KPC_Thd_Sample"},
        {0x25070000, "PERF_KDBG_Handler"},
        {0x25080000, "PERF_TK_Snap_Sample"},
        {0x25080004, "PERF_TK_Snap_Data1"},
        {0x25080008, "PERF_TK_Snap_Data2"},
        {0x2508000c, "PERF_TK_Snap_Data1_32"},
        {0x25080010, "PERF_TK_Snap_Data2_32"},
        {0x250a0000, "PERF_MI_Sample"},
        {0x250a0004, "PERF_MI_Data"},
        {0x26100008, "imp_assertion_hold"},
        {0x2610000c, "imp_assertion_hold_ext"},
        {0x26100010, "imp_assertion_drop"},
        {0x26100014, "imp_assertion_drop_ext"},
        {0x26100020, "imp_assertion_externalize"},
        {0x26110004, "imp_boost_task"},
        {0x26110008, "imp_unboost_task"},
        {0x26120004, "imp_msg_send"},
        {0x26120008, "imp_msg_delv"},
        {0x26130000, "imp_watchport"},
        {0x26170000, "imp_suppression_inactive"},
        {0x26170004, "imp_suppression_active"},
        {0x26180000, "imp_apptype_none"},
        {0x26180004, "imp_apptype_int_daemon"},
        {0x26180008, "imp_apptype_std_daemon"},
        {0x2618000c, "imp_apptype_adapt_daemon"},
        {0x26180010, "imp_apptype_bg_daemon"},
        {0x26180014, "imp_apptype_default_app"},
        {0x26180018, "imp_apptype_tal_app"},
        {0x26190010, "imp_update_task"},
        {0x26190020, "imp_update_thread"},
        {0x261a0000, "imp_usynch_add_override"},
        {0x261a0004, "imp_usynch_remove_override"},
        {0x261b0000, "imp_donor_update_live_donor"},
        {0x261b0004, "imp_donor_init_donor_state"},
        {0x26210010, "imp_task_int_bg"},
        {0x26210014, "imp_task_ext_bg"},
        {0x26210020, "imp_thread_int_bg"},
        {0x26210024, "imp_thread_ext_bg"},
        {0x26220010, "imp_task_int_iopol"},
        {0x26220014, "imp_task_ext_iopol"},
        {0x26220020, "imp_thread_int_iopol"},
        {0x26220024, "imp_thread_ext_iopol"},
        {0x26230010, "imp_task_int_io"},
        {0x26230014, "imp_task_ext_io"},
        {0x26230020, "imp_thread_int_io"},
        {0x26230024, "imp_thread_ext_io"},
        {0x26240010, "imp_task_int_passive_io"},
        {0x26240014, "imp_task_ext_passive_io"},
        {0x26240020, "imp_thread_int_passive_io"},
        {0x26240024, "imp_thread_ext_passive_io"},
        {0x26270018, "imp_task_dbg_iopol"},
        {0x26280018, "imp_task_tal"},
        {0x26290018, "imp_task_boost"},
        {0x262a0018, "imp_task_role"},
        {0x262b0018, "imp_task_suppressed_cpu"},
        {0x262c0018, "imp_task_terminated"},
        {0x262d0018, "imp_task_new_sockets_bg"},
        {0x262e0018, "imp_task_lowpri_cpu"},
        {0x262f0018, "imp_task_latency_qos"},
        {0x26300018, "imp_task_through_qos"},
        {0x26310018, "imp_task_watchers_bg"},
        {0x26320028, "imp_thread_pidbind_bg"},
        {0x26330028, "imp_thread_workq_bg"},
        {0x27000000, "PERF_PCEVENT"},
        {0x27001000, "PERF_CPU_IDLE"},
        {0x27001100, "PERF_CPU_IDLE_TIMER"},
        {0x27002000, "PERF_VOLT_CHG_SOC"},
        {0x27002010, "PERF_VOLT_CHG_CPU"},
        {0x27002020, "PERF_VOLT_CHG_DOM2"},
        {0x27002030, "PERF_VOLT_CHG_DOM3"},
        {0x27003000, "PERF_PERF_CHG_SOC"},
        {0x27003010, "PERF_PERF_CHG_CPU"},
        {0x27003020, "PERF_PERF_CHG_DOM2"},
        {0x27003030, "PERF_PERF_CHG_DOM3"},
        {0x2700a000, "PERF_ARBITER_EVENT"},
        {0x2700a100, "PERF_ARBITER_NOTIFY"},
        {0x2700a200, "PERF_ARBITER_PERF_SET"},
        {0x2700c000, "PERF_CLOCK_GATE"},
        {0x2700e000, "PERF_SRAMEMA_DOM0"},
        {0x2700e010, "PERF_SRAMEMA_DOM1"},
        {0x2700e020, "PERF_SRAMEMA_DOM2"},
        {0x2700e030, "PERF_SRAMEMA_DOM3"},
        {0x27010100, "PERF_CPU_IDL_ACT_TIME"},
        {0x2710a500, "PERF_FB_CONTROLLER"},
        {0x2720a500, "PERF_PMC_CONTROLLER"},
        {0x2730a500, "PERF_GPU_CONTROLLER"},
        {0x2740a500, "PERF_STP_CONTROLLER"},
        {0x28100004, "BANK_SETTLE_CPU_TIME"},
        {0x28100008, "BANK_SECURE_ORIGINATOR_CHANGED"},
        {0x2a100004, "ATM_MIN_CALLED"},
        {0x2a100008, "ATM_LINK_LIST_TRIM"},
        {0x2a200004, "ATM_VALUE_REPLACED"},
        {0x2a200008, "ATM_VALUE_ADDED"},
        {0x2a300004, "ATM_VALUE_UNREGISTERED"},
        {0x2a300008, "ATM_VALUE_DIFF_MAILBOX"},
        {0xff000104, "MSG_mach_notify_port_deleted"},
        {0xff000114, "MSG_mach_notify_port_destroyed"},
        {0xff000118, "MSG_mach_notify_no_senders"},
        {0xff00011c, "MSG_mach_notify_send_once"},
        {0xff000120, "MSG_mach_notify_dead_name"},
        {0xff0001ec, "MSG_audit_triggers"},
        {0xff000320, "MSG_host_info"},
        {0xff000324, "MSG_host_kernel_version"},
        {0xff000328, "MSG_host_page_size"},
        {0xff00032c, "MSG_mach_memory_object_memory_entry"},
        {0xff000330, "MSG_host_processor_info"},
        {0xff000334, "MSG_host_get_io_master"},
        {0xff000338, "MSG_host_get_clock_service"},
        {0xff00033c, "MSG_kmod_get_info"},
        {0xff000340, "MSG_host_zone_info"},
        {0xff000344, "MSG_host_virtual_physical_table_info"},
        {0xff000348, "MSG_host_ipc_hash_info"},
        {0xff00034c, "MSG_enable_bluebox"},
        {0xff000350, "MSG_disable_bluebox"},
        {0xff000354, "MSG_processor_set_default"},
        {0xff000358, "MSG_processor_set_create"},
        {0xff00035c, "MSG_mach_memory_object_memory_entry_64"},
        {0xff000360, "MSG_host_statistics"},
        {0xff000364, "MSG_host_request_notification"},
        {0xff000368, "MSG_host_lockgroup_info"},
        {0xff00036c, "MSG_host_statistics64"},
        {0xff000370, "MSG_mach_zone_info"},
        {0xff000640, "MSG_host_get_boot_info"},
        {0xff000644, "MSG_host_reboot"},
        {0xff000648, "MSG_host_priv_statistics"},
        {0xff00064c, "MSG_host_default_memory_manager"},
        {0xff000650, "MSG_vm_wire"},
        {0xff000654, "MSG_thread_wire"},
        {0xff000658, "MSG_vm_allocate_cpm"},
        {0xff00065c, "MSG_host_processors"},
        {0xff000660, "MSG_host_get_clock_control"},
        {0xff000664, "MSG_kmod_create"},
        {0xff000668, "MSG_kmod_destroy"},
        {0xff00066c, "MSG_kmod_control"},
        {0xff000670, "MSG_host_get_special_port"},
        {0xff000674, "MSG_host_set_special_port"},
        {0xff000678, "MSG_host_set_exception_ports"},
        {0xff00067c, "MSG_host_get_exception_ports"},
        {0xff000680, "MSG_host_swap_exception_ports"},
        {0xff000684, "MSG_host_load_symbol_table"},
        {0xff000688, "MSG_mach_vm_wire"},
        {0xff00068c, "MSG_host_processor_sets"},
        {0xff000690, "MSG_host_processor_set_priv"},
        {0xff000694, "MSG_set_dp_control_port"},
        {0xff000698, "MSG_get_dp_control_port"},
        {0xff00069c, "MSG_host_set_UNDServer"},
        {0xff0006a0, "MSG_host_get_UNDServer"},
        {0xff0006a4, "MSG_kext_request"},
        {0xff000960, "MSG_host_security_create_task_token"},
        {0xff000964, "MSG_host_security_set_task_token"},
        {0xff000f9c, "MSG_mach_gss_init_sec_context"},
        {0xff000fa0, "MSG_clock_get_time"},
        {0xff000fa4, "MSG_clock_get_attributes"},
        {0xff000fa8, "MSG_clock_alarm"},
        {0xff000fac, "MSG_mach_gss_accept_sec_context_v2"},
        {0xff000fb0, "MSG_mach_gss_hold_cred"},
        {0xff000fb4, "MSG_mach_gss_unhold_cred"},
        {0xff000ffc, "MSG_lockd_request"},
        {0xff001000, "MSG_lockd_ping"},
        {0xff001004, "MSG_lockd_shutdown"},
        {0xff0012c0, "MSG_clock_set_time"},
        {0xff0012c4, "MSG_clock_set_attributes"},
        {0xff001f40, "MSG_memory_object_get_attributes"},
        {0xff001f44, "MSG_memory_object_change_attributes"},
        {0xff001f48, "MSG_memory_object_synchronize_completed"},
        {0xff001f4c, "MSG_memory_object_lock_request"},
        {0xff001f50, "MSG_memory_object_destroy"},
        {0xff001f54, "MSG_memory_object_upl_request"},
        {0xff001f58, "MSG_memory_object_super_upl_request"},
        {0xff001f5c, "MSG_memory_object_cluster_size"},
        {0xff001f60, "MSG_memory_object_page_op"},
        {0xff001f64, "MSG_memory_object_recover_named"},
        {0xff001f68, "MSG_memory_object_release_name"},
        {0xff001f6c, "MSG_memory_object_range_op"},
        {0xff002008, "MSG_upl_abort"},
        {0xff00200c, "MSG_upl_abort_range"},
        {0xff002010, "MSG_upl_commit"},
        {0xff002014, "MSG_upl_commit_range"},
        {0xff002260, "MSG_memory_object_init"},
        {0xff002264, "MSG_memory_object_terminate"},
        {0xff002268, "MSG_memory_object_data_request"},
        {0xff00226c, "MSG_memory_object_data_return"},
        {0xff002270, "MSG_memory_object_data_initialize"},
        {0xff002274, "MSG_memory_object_data_unlock"},
        {0xff002278, "MSG_memory_object_synchronize"},
        {0xff00227c, "MSG_memory_object_map"},
        {0xff002280, "MSG_memory_object_last_unmap"},
        {0xff002284, "MSG_memory_object_data_reclaim"},
        {0xff002328, "MSG_memory_object_create"},
        {0xff00238c, "MSG_default_pager_object_create"},
        {0xff002390, "MSG_default_pager_info"},
        {0xff002394, "MSG_default_pager_objects"},
        {0xff002398, "MSG_default_pager_object_pages"},
        {0xff0023a0, "MSG_default_pager_backing_store_create"},
        {0xff0023a4, "MSG_default_pager_backing_store_delete"},
        {0xff0023a8, "MSG_default_pager_backing_store_info"},
        {0xff0023ac, "MSG_default_pager_add_file"},
        {0xff0023b0, "MSG_default_pager_triggers"},
        {0xff0023b4, "MSG_default_pager_info_64"},
        {0xff0023dc, "MSG_default_pager_space_alert"},
        {0xff002584, "MSG_exception_raise"},
        {0xff002588, "MSG_exception_raise_state"},
        {0xff00258c, "MSG_exception_raise_state_identity"},
        {0xff002594, "MSG_mach_exception_raise"},
        {0xff002598, "MSG_mach_exception_raise_state"},
        {0xff00259c, "MSG_mach_exception_raise_state_identity"},
        {0xff002bc0, "MSG_io_object_get_class"},
        {0xff002bc4, "MSG_io_object_conforms_to"},
        {0xff002bc8, "MSG_io_iterator_next"},
        {0xff002bcc, "MSG_io_iterator_reset"},
        {0xff002bd0, "MSG_io_service_get_matching_services"},
        {0xff002bd4, "MSG_io_registry_entry_get_property"},
        {0xff002bd8, "MSG_io_registry_create_iterator"},
        {0xff002bdc, "MSG_io_registry_iterator_enter_entry"},
        {0xff002be0, "MSG_io_registry_iterator_exit_entry"},
        {0xff002be4, "MSG_io_registry_entry_from_path"},
        {0xff002be8, "MSG_io_registry_entry_get_name"},
        {0xff002bec, "MSG_io_registry_entry_get_properties"},
        {0xff002bf0, "MSG_io_registry_entry_get_property_bytes"},
        {0xff002bf4, "MSG_io_registry_entry_get_child_iterator"},
        {0xff002bf8, "MSG_io_registry_entry_get_parent_iterator"},
        {0xff002c00, "MSG_io_service_close"},
        {0xff002c04, "MSG_io_connect_get_service"},
        {0xff002c08, "MSG_io_connect_set_notification_port"},
        {0xff002c0c, "MSG_io_connect_map_memory"},
        {0xff002c10, "MSG_io_connect_add_client"},
        {0xff002c14, "MSG_io_connect_set_properties"},
        {0xff002c18, "MSG_io_connect_method_scalarI_scalarO"},
        {0xff002c1c, "MSG_io_connect_method_scalarI_structureO"},
        {0xff002c20, "MSG_io_connect_method_scalarI_structureI"},
        {0xff002c24, "MSG_io_connect_method_structureI_structureO"},
        {0xff002c28, "MSG_io_registry_entry_get_path"},
        {0xff002c2c, "MSG_io_registry_get_root_entry"},
        {0xff002c30, "MSG_io_registry_entry_set_properties"},
        {0xff002c34, "MSG_io_registry_entry_in_plane"},
        {0xff002c38, "MSG_io_object_get_retain_count"},
        {0xff002c3c, "MSG_io_service_get_busy_state"},
        {0xff002c40, "MSG_io_service_wait_quiet"},
        {0xff002c44, "MSG_io_registry_entry_create_iterator"},
        {0xff002c48, "MSG_io_iterator_is_valid"},
        {0xff002c50, "MSG_io_catalog_send_data"},
        {0xff002c54, "MSG_io_catalog_terminate"},
        {0xff002c58, "MSG_io_catalog_get_data"},
        {0xff002c5c, "MSG_io_catalog_get_gen_count"},
        {0xff002c60, "MSG_io_catalog_module_loaded"},
        {0xff002c64, "MSG_io_catalog_reset"},
        {0xff002c68, "MSG_io_service_request_probe"},
        {0xff002c6c, "MSG_io_registry_entry_get_name_in_plane"},
        {0xff002c70, "MSG_io_service_match_property_table"},
        {0xff002c74, "MSG_io_async_method_scalarI_scalarO"},
        {0xff002c78, "MSG_io_async_method_scalarI_structureO"},
        {0xff002c7c, "MSG_io_async_method_scalarI_structureI"},
        {0xff002c80, "MSG_io_async_method_structureI_structureO"},
        {0xff002c84, "MSG_io_service_add_notification"},
        {0xff002c88, "MSG_io_service_add_interest_notification"},
        {0xff002c8c, "MSG_io_service_acknowledge_notification"},
        {0xff002c90, "MSG_io_connect_get_notification_semaphore"},
        {0xff002c94, "MSG_io_connect_unmap_memory"},
        {0xff002c98, "MSG_io_registry_entry_get_location_in_plane"},
        {0xff002c9c, "MSG_io_registry_entry_get_property_recursively"},
        {0xff002ca0, "MSG_io_service_get_state"},
        {0xff002ca4, "MSG_io_service_get_matching_services_ool"},
        {0xff002ca8, "MSG_io_service_match_property_table_ool"},
        {0xff002cac, "MSG_io_service_add_notification_ool"},
        {0xff002cb0, "MSG_io_object_get_superclass"},
        {0xff002cb4, "MSG_io_object_get_bundle_identifier"},
        {0xff002cb8, "MSG_io_service_open_extended"},
        {0xff002cbc, "MSG_io_connect_map_memory_into_task"},
        {0xff002cc0, "MSG_io_connect_unmap_memory_from_task"},
        {0xff002cc4, "MSG_io_connect_method"},
        {0xff002cc8, "MSG_io_connect_async_method"},
        {0xff002ccc, "MSG_io_connect_set_notification_port_64"},
        {0xff002cd0, "MSG_io_service_add_notification_64"},
        {0xff002cd4, "MSG_io_service_add_interest_notification_64"},
        {0xff002cd8, "MSG_io_service_add_notification_ool_64"},
        {0xff002cdc, "MSG_io_registry_entry_get_registry_entry_id"},
        {0xff002ee0, "MSG_processor_start"},
        {0xff002ee4, "MSG_processor_exit"},
        {0xff002ee8, "MSG_processor_info"},
        {0xff002eec, "MSG_processor_control"},
        {0xff002ef0, "MSG_processor_assign"},
        {0xff002ef4, "MSG_processor_get_assignment"},
        {0xff003200, "MSG_mach_port_names"},
        {0xff003204, "MSG_mach_port_type"},
        {0xff003208, "MSG_mach_port_rename"},
        {0xff00320c, "MSG_mach_port_allocate_name"},
        {0xff003210, "MSG_mach_port_allocate"},
        {0xff003214, "MSG_mach_port_destroy"},
        {0xff003218, "MSG_mach_port_deallocate"},
        {0xff00321c, "MSG_mach_port_get_refs"},
        {0xff003220, "MSG_mach_port_mod_refs"},
        {0xff003228, "MSG_mach_port_set_mscount"},
        {0xff00322c, "MSG_mach_port_get_set_status"},
        {0xff003230, "MSG_mach_port_move_member"},
        {0xff003234, "MSG_mach_port_request_notification"},
        {0xff003238, "MSG_mach_port_insert_right"},
        {0xff00323c, "MSG_mach_port_extract_right"},
        {0xff003240, "MSG_mach_port_set_seqno"},
        {0xff003244, "MSG_mach_port_get_attributes"},
        {0xff003248, "MSG_mach_port_set_attributes"},
        {0xff00324c, "MSG_mach_port_allocate_qos"},
        {0xff003250, "MSG_mach_port_allocate_full"},
        {0xff003254, "MSG_task_set_port_space"},
        {0xff003258, "MSG_mach_port_get_srights"},
        {0xff00325c, "MSG_mach_port_space_info"},
        {0xff003260, "MSG_mach_port_dnrequest_info"},
        {0xff003264, "MSG_mach_port_kernel_object"},
        {0xff003268, "MSG_mach_port_insert_member"},
        {0xff00326c, "MSG_mach_port_extract_member"},
        {0xff003270, "MSG_mach_port_get_context"},
        {0xff003274, "MSG_mach_port_set_context"},
        {0xff003278, "MSG_mach_port_kobject"},
        {0xff003520, "MSG_task_create"},
        {0xff003524, "MSG_task_terminate"},
        {0xff003528, "MSG_task_threads"},
        {0xff00352c, "MSG_mach_ports_register"},
        {0xff003530, "MSG_mach_ports_lookup"},
        {0xff003534, "MSG_task_info"},
        {0xff003538, "MSG_task_set_info"},
        {0xff00353c, "MSG_task_suspend"},
        {0xff003540, "MSG_task_resume"},
        {0xff003544, "MSG_task_get_special_port"},
        {0xff003548, "MSG_task_set_special_port"},
        {0xff00354c, "MSG_thread_create"},
        {0xff003550, "MSG_thread_create_running"},
        {0xff003554, "MSG_task_set_exception_ports"},
        {0xff003558, "MSG_task_get_exception_ports"},
        {0xff00355c, "MSG_task_swap_exception_ports"},
        {0xff003560, "MSG_lock_set_create"},
        {0xff003564, "MSG_lock_set_destroy"},
        {0xff003568, "MSG_semaphore_create"},
        {0xff00356c, "MSG_semaphore_destroy"},
        {0xff003570, "MSG_task_policy_set"},
        {0xff003574, "MSG_task_policy_get"},
        {0xff003578, "MSG_task_sample"},
        {0xff00357c, "MSG_task_policy"},
        {0xff003580, "MSG_task_set_emulation"},
        {0xff003584, "MSG_task_get_emulation_vector"},
        {0xff003588, "MSG_task_set_emulation_vector"},
        {0xff00358c, "MSG_task_set_ras_pc"},
        {0xff003590, "MSG_task_zone_info"},
        {0xff003594, "MSG_task_assign"},
        {0xff003598, "MSG_task_assign_default"},
        {0xff00359c, "MSG_task_get_assignment"},
        {0xff0035a0, "MSG_task_set_policy"},
        {0xff0035a4, "MSG_task_get_state"},
        {0xff0035a8, "MSG_task_set_state"},
        {0xff003840, "MSG_thread_terminate"},
        {0xff003844, "MSG_act_get_state"},
        {0xff003848, "MSG_act_set_state"},
        {0xff00384c, "MSG_thread_get_state"},
        {0xff003850, "MSG_thread_set_state"},
        {0xff003854, "MSG_thread_suspend"},
        {0xff003858, "MSG_thread_resume"},
        {0xff00385c, "MSG_thread_abort"},
        {0xff003860, "MSG_thread_abort_safely"},
        {0xff003864, "MSG_thread_depress_abort"},
        {0xff003868, "MSG_thread_get_special_port"},
        {0xff00386c, "MSG_thread_set_special_port"},
        {0xff003870, "MSG_thread_info"},
        {0xff003874, "MSG_thread_set_exception_ports"},
        {0xff003878, "MSG_thread_get_exception_ports"},
        {0xff00387c, "MSG_thread_swap_exception_ports"},
        {0xff003880, "MSG_thread_policy"},
        {0xff003884, "MSG_thread_policy_set"},
        {0xff003888, "MSG_thread_policy_get"},
        {0xff00388c, "MSG_thread_sample"},
        {0xff003890, "MSG_etap_trace_thread"},
        {0xff003894, "MSG_thread_assign"},
        {0xff003898, "MSG_thread_assign_default"},
        {0xff00389c, "MSG_thread_get_assignment"},
        {0xff0038a0, "MSG_thread_set_policy"},
        {0xff003b60, "MSG_vm_region"},
        {0xff003b64, "MSG_vm_allocate"},
        {0xff003b68, "MSG_vm_deallocate"},
        {0xff003b6c, "MSG_vm_protect"},
        {0xff003b70, "MSG_vm_inherit"},
        {0xff003b74, "MSG_vm_read"},
        {0xff003b78, "MSG_vm_read_list"},
        {0xff003b7c, "MSG_vm_write"},
        {0xff003b80, "MSG_vm_copy"},
        {0xff003b84, "MSG_vm_read_overwrite"},
        {0xff003b88, "MSG_vm_msync"},
        {0xff003b8c, "MSG_vm_behavior_set"},
        {0xff003b90, "MSG_vm_map"},
        {0xff003b94, "MSG_vm_machine_attribute"},
        {0xff003b98, "MSG_vm_remap"},
        {0xff003b9c, "MSG_task_wire"},
        {0xff003ba0, "MSG_mach_make_memory_entry"},
        {0xff003ba4, "MSG_vm_map_page_query"},
        {0xff003ba8, "MSG_mach_vm_region_info"},
        {0xff003bac, "MSG_vm_mapped_pages_info"},
        {0xff003bb4, "MSG_vm_region_recurse"},
        {0xff003bb8, "MSG_vm_region_recurse_64"},
        {0xff003bbc, "MSG_mach_vm_region_info_64"},
        {0xff003bc0, "MSG_vm_region_64"},
        {0xff003bc4, "MSG_mach_make_memory_entry_64"},
        {0xff003bc8, "MSG_vm_map_64"},
        {0xff003bcc, "MSG_vm_map_get_upl"},
        {0xff003bd8, "MSG_vm_purgable_control"},
        {0xff003e80, "MSG_processor_set_statistics"},
        {0xff003e84, "MSG_processor_set_destroy"},
        {0xff003e88, "MSG_processor_set_max_priority"},
        {0xff003e8c, "MSG_processor_set_policy_enable"},
        {0xff003e90, "MSG_processor_set_policy_disable"},
        {0xff003e94, "MSG_processor_set_tasks"},
        {0xff003e98, "MSG_processor_set_threads"},
        {0xff003e9c, "MSG_processor_set_policy_control"},
        {0xff003ea0, "MSG_processor_set_stack_usage"},
        {0xff003ea4, "MSG_processor_set_info"},
        {0xff004b00, "MSG_mach_vm_allocate"},
        {0xff004b04, "MSG_mach_vm_deallocate"},
        {0xff004b08, "MSG_mach_vm_protect"},
        {0xff004b0c, "MSG_mach_vm_inherit"},
        {0xff004b10, "MSG_mach_vm_read"},
        {0xff004b14, "MSG_mach_vm_read_list"},
        {0xff004b18, "MSG_mach_vm_write"},
        {0xff004b1c, "MSG_mach_vm_copy"},
        {0xff004b20, "MSG_mach_vm_read_overwrite"},
        {0xff004b24, "MSG_mach_vm_msync"},
        {0xff004b28, "MSG_mach_vm_behavior_set"},
        {0xff004b2c, "MSG_mach_vm_map"},
        {0xff004b30, "MSG_mach_vm_machine_attribute"},
        {0xff004b34, "MSG_mach_vm_remap"},
        {0xff004b38, "MSG_mach_vm_page_query"},
        {0xff004b3c, "MSG_mach_vm_region_recurse"},
        {0xff004b40, "MSG_mach_vm_region"},
        {0xff004b44, "MSG__mach_make_memory_entry"},
        {0xff004b48, "MSG_mach_vm_purgable_control"},
        {0xff004b4c, "MSG_mach_vm_page_info"},
        {0xff004e20, "MSG_ledger_create"},
        {0xff004e24, "MSG_ledger_terminate"},
        {0xff004e28, "MSG_ledger_transfer"},
        {0xff004e2c, "MSG_ledger_read"},
        {0xff005140, "MSG_mach_get_task_label"},
        {0xff005144, "MSG_mach_get_task_label_text"},
        {0xff005148, "MSG_mach_get_label"},
        {0xff00514c, "MSG_mach_get_label_text"},
        {0xff005150, "MSG_mach_set_port_label"},
        {0xff005154, "MSG_mac_check_service"},
        {0xff005158, "MSG_mac_port_check_service_obj"},
        {0xff00515c, "MSG_mac_port_check_access"},
        {0xff005160, "MSG_mac_label_new"},
        {0xff005164, "MSG_mac_request_label"},
        {0xff005dc0, "MSG_UNDExecute_rpc"},
        {0xff005dc4, "MSG_UNDDisplayNoticeFromBundle_rpc"},
        {0xff005dc8, "MSG_UNDDisplayAlertFromBundle_rpc"},
        {0xff005dcc, "MSG_UNDDisplayCustomFromBundle_rpc"},
        {0xff005dd0, "MSG_UNDDisplayCustomFromDictionary_rpc"},
        {0xff005dd4, "MSG_UNDCancelNotification_rpc"},
        {0xff005dd8, "MSG_UNDDisplayNoticeSimple_rpc"},
        {0xff005ddc, "MSG_UNDDisplayAlertSimple_rpc"},
        {0xff0060e0, "MSG_UNDAlertCompletedWithResult_rpc"},
        {0xff0060e4, "MSG_UNDNotificationCreated_rpc"},
        {0xff01a5e0, "MSG_check_task_access"},
        {0xff01a5e4, "MSG_find_code_signature"},
        {0xff04b320, "MSG_kextd_ping"},
        {0xff25a8a0, "MSG_lock_acquire"},
        {0xff25a8a4, "MSG_lock_release"},
        {0xff25a8a8, "MSG_lock_try"},
        {0xff25a8ac, "MSG_lock_make_stable"},
        {0xff25a8b0, "MSG_lock_handoff"},
        {0xff25a8b4, "MSG_lock_handoff_accept"},
        {0xff25abc0, "MSG_semaphore_signal"},
        {0xff25abc4, "MSG_semaphore_signal_all"},
        {0xff25abc8, "MSG_semaphore_wait"},
        {0xff25abcc, "MSG_semaphore_signal_thread"},
        {0xff25abd0, "MSG_semaphore_timedwait"},
        {0xff25abd4, "MSG_semaphore_wait_signal"},
        {0xff25abd8, "MSG_semaphore_timedwait_signal"},
        {0xffbebdcc, "MSG_clock_alarm_reply"},
};
