{ lib
, buildGoModule
, fetchFromGitHub
}:

buildGoModule rec {
  pname = "go-exploitdb";
  version = "0.4.6";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    rev = "refs/tags/v${version}";
    hash = "sha256-xQQnMlj5dxvvGPqzMyMVloJQe5qY2EPQkYaw3RpgxjI=";
  };

  vendorHash = "sha256-1HvhphLJH0572au2iSXVjN35JCpZr1hesnMrIpdOBRc=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${version}"
  ];

  meta = with lib; {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/v${version}";
    license = licenses.mit;
    maintainers = with maintainers; [ fab ];
  };
}
