{
  mkDerivation, lib, fetchurl,
  extra-cmake-modules, shared-mime-info,
  qtsvg, qtxmlpatterns, karchive, kconfig, kcoreaddons, kparts, kio, ki18n,
  kdiagram, kgraphviewer
}:

mkDerivation rec {
  pname = "massif-visualizer";
  version = "0.7.0";

  src = fetchurl {
    url = "mirror://kde/stable/massif-visualizer/${version}/src/${pname}-${version}.tar.xz";
    sha256 = "0v8z6r9gngzckvqyxjm9kp7hilwfqibyk2f9vag9l98ar0iwr97q";
  };

  nativeBuildInputs = [ extra-cmake-modules shared-mime-info ];

  buildInputs = [
    qtsvg qtxmlpatterns karchive kconfig kcoreaddons kparts kio ki18n
    kdiagram kgraphviewer
  ];

  meta = with lib; {
    description = "Tool that visualizes massif data generated by valgrind";
    mainProgram = "massif-visualizer";
    license = licenses.gpl2;
    platforms = platforms.linux;
    maintainers = with maintainers; [ zraexy ];
  };
}
