{ stdenv
, lib
, fetchFromGitHub
, unstableGitUpdater
, zlib
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "libfmvoice";
  version = "0.0.0-unstable-2023-12-05";

  src = fetchFromGitHub {
    owner = "vampirefrog";
    repo = "libfmvoice";
    rev = "38b1a0c627ef66fcd9c672c215d2b9849163df12";
    hash = "sha256-kXthY9TynIXNX9wmgn13vs4Mrrv/dmEr7zlWiKstjGk=";
  };

  strictDeps = true;

  enableParallelBuilding = true;

  buildInputs = [
    zlib
  ];

  buildFlags = [
    "CC=${stdenv.cc.targetPrefix}cc"
  ];

  installPhase = ''
    runHook preInstall

    for prog in $(grep 'PROGS=' Makefile | cut -d'=' -f2); do
      install -Dm755 $prog $out/bin/$prog
    done

    runHook postInstall
  '';

  passthru = {
    updateScript = unstableGitUpdater { };
  };

  meta = with lib; {
    description = "C library for loading, saving and converting FM sound chip voice files in various formats";
    homepage = "https://github.com/vampirefrog/libfmvoice";
    license = licenses.gpl3Only;
    maintainers = with maintainers; [ OPNA2608 ];
    platforms = platforms.all;
  };
})
