# Release 23.11 (“Tapir”, 2023.11/29) {#sec-release-23.11}

The NixOS release team is happy to announce a new version of NixOS. The release is called NixOS 23.11 ("Tapir").

NixOS is a Linux distribution, whose set of packages can also be used on other Linux systems and macOS.

Support is planned until the end of June 2024, handing over to NixOS 24.05.

To upgrade to the latest release, follow the upgrade chapter and check the [Breaking Changes](#sec-release-23.11-nixos-breaking-changes)
section for packages and services used in your configuration.

The team is excited about the many software updates and improvements in this release. Just to name a few, do check the updates
for `GNOME` packages, `systemd`, `glibc`, the `ROCM` package set, and `hostapd` (which brings support for WiFi6 (IEEE 802.11ax) and WPA3-SAE-PK).

Make sure to also check the many updates in the [Nixpkgs library](#sec-release-23.11-nixpkgs-lib) when developing your own packages.

## Table of Contents {#sec-release-23.11-toc}

- [NixOS](#sec-release-23.11-nixos)
  - [Breaking Changes](#sec-release-23.11-nixos-breaking-changes)
  - [New Services](#sec-release-23.11-nixos-new-services)
  - [Other Notable Changes](#sec-release-23.11-nixos-notable-changes)
- [Nixpkgs Library](#sec-release-23.11-nixpkgs-lib)
  - [Breaking Changes](#sec-release-23.11-lib-breaking)
  - [Additions and Improvements](#sec-release-23.11-lib-additions-improvements)
  - [Deprecations](#sec-release-23.11-lib-deprecations)

## NixOS {#sec-release-23.11-nixos}


### Breaking Changes {#sec-release-23.11-nixos-breaking-changes}

- `services.postgresql.ensurePermissions` has been deprecated in favor of
  `services.postgresql.ensureUsers.*.ensureDBOwnership` which simplifies the
  setup of database owned by a certain system user in local database contexts
  (which make use of peer authentication via UNIX sockets), migration
  guidelines were provided in the NixOS manual, please refer to them if you are
  affected by a PostgreSQL 15 changing the way `GRANT ALL PRIVILEGES` is
  working. `services.postgresql.ensurePermissions` will be removed in 24.05.
  All NixOS modules were migrated using one of the strategy, e.g.
  `ensureDBOwnership` or `postStart`. Refer to the [PR
  #266270](https://github.com/NixOS/nixpkgs/pull/266270) for more details.

- `network-online.target` has been fixed to no longer time out for systems with
  `networking.useDHCP = true` and `networking.useNetworkd = true`. Workarounds
  for this can be removed.

- The `boot.loader.raspberryPi` options have been marked deprecated, with
  intent of removal for NixOS 24.11. They had a limited use-case, and do not
  work like people expect. They required either very old installs from ([before
  mid-2019](https://github.com/NixOS/nixpkgs/pull/62462)) or customized builds
  out of scope of the standard and generic AArch64 support. That option set
  never supported the Raspberry Pi 4 family of devices.

- `python3.pkgs.sequoia` was removed in favor of `python3.pkgs.pysequoia`. The
  latter package is based on upstream's dedicated repository for sequoia's
  Python bindings, where the Python bindings from
  [gitlab:sequoia-pgp/sequoia](https://gitlab.com/sequoia-pgp/sequoia) were
  removed long ago.

- `writeTextFile` requires `executable` to be boolean now, values like `null`
  or `""` will fail to evaluate now.

- The latest version of `clonehero` now stores custom content in
  `~/.clonehero`. Refer to the [migration
  instructions](https://clonehero.net/2022/11/29/v23-to-v1-migration-instructions.html)
  for more details. Typically, these content files would exist along side the
  binary, but the previous build used a wrapper script that would store them in
  `~/.config/unity3d/srylain Inc_/Clone Hero`.

- `services.mastodon` doesn't support providing a TCP port to its `streaming`
  component anymore, as upstream implemented parallelization by running
  multiple instances instead of running multiple processes in one instance.
  Please create a PR if you are interested in this feature.\
  Due to this, the desired number of such instances
  {option}`services.mastodon.streamingProcesses` now needs to be declared explicitly.

- The `services.hostapd` module was rewritten to support `passwordFile` like
  options, WPA3-SAE, and management of multiple interfaces. This breaks
  compatibility with older configurations.
  - `hostapd` is now started with additional systemd sandbox/hardening options
    for better security.
  - `services.hostapd.interface` was replaced with a per-radio and per-bss
    configuration scheme using
    [services.hostapd.radios](#opt-services.hostapd.radios).
  - `services.hostapd.wpa` has been replaced by
    [services.hostapd.radios.&lt;name&gt;.networks.&lt;name&gt;.authentication.wpaPassword](#opt-services.hostapd.radios._name_.networks._name_.authentication.wpaPassword)
    and
    [services.hostapd.radios.&lt;name&gt;.networks.&lt;name&gt;.authentication.saePasswords](#opt-services.hostapd.radios._name_.networks._name_.authentication.saePasswords)
    which configure WPA2-PSK and WP3-SAE respectively.
  - The default authentication has been changed to WPA3-SAE. Options for other
    (legacy) schemes are still available.

- `python3.pkgs.fetchPypi` and `python3Packages.fetchPypi` have been
  deprecated in favor of top-level `fetchPypi`.

- xdg-desktop-portal has been updated to 1.18, which reworked how portal
  implementations are selected. If you roll your own desktop environment, you
  should either set `xdg.portal.config` or `xdg.portal.configPackages`, which
  allow fine-grained control over which portal backend to use for specific
  interfaces, as described in {manpage}`portals.conf(5)`.

  If you don't provide configurations, a portal backend will only be considered
  when the desktop you use matches its deprecated `UseIn` key. While some NixOS
  desktop modules should already ship one for you, it is suggested to test
  portal availability by trying [Door
  Knocker](https://flathub.org/apps/xyz.tytanium.DoorKnocker) and [ASHPD
  Demo](https://flathub.org/apps/com.belmoussaoui.ashpd.demo). If things
  regressed, you may run `G_MESSAGES_DEBUG=all
  /path/to/xdg-desktop-portal/libexec/xdg-desktop-portal` for ideas on which
  config file and which portals are chosen.

- `pass` now does not contain `password-store.el`. Users should get
  `password-store.el` from Emacs lisp package set `emacs.pkgs.password-store`.

- `services.knot` now supports `.settings` from RFC42.  The previous
  `.extraConfig` still works the same, but it displays a warning now.

- `services.invoiceplane` now supports `.settings` from RFC42. The previous
  `.extraConfig` still works the same way, but it displays a warning now.

- `mu` does not install `mu4e` files by default now. Users should get `mu4e`
  from Emacs lisp package set `emacs.pkgs.mu4e`.

- `mariadb` now defaults to `mariadb_1011` instead of `mariadb_106`, meaning
  the default version was upgraded from v10.6.x to v10.11.x. Refer to the
  [upgrade
  notes](https://mariadb.com/kb/en/upgrading-from-mariadb-10-6-to-mariadb-10-11/)
  for potential issues.

- `getent` has been moved from `glibc`'s `bin` output to its own dedicated
  output, reducing closure size for many dependents. Dependents using the
  `getent` alias should not be affected; others should move from using
  `glibc.bin` or `getBin glibc` to `getent` (which also improves compatibility
  with non-glibc platforms).

- `maintainers/scripts/update-luarocks-packages` is now a proper package
  `luarocks-packages-updater` that can be run to maintain out-of-tree luarocks
  packages.

- The `users.users.<name>.passwordFile` has been renamed to
  `users.users.<name>.hashedPasswordFile` to avoid possible confusions. The
  option is in fact the file-based version of `hashedPassword`, not `password`,
  and expects a file containing the {manpage}`crypt(3)` hash of the user
  password.

- `chromiumBeta` and `chromiumDev` have been removed due to the lack of
  maintenance in nixpkgs. Consider using `chromium` instead.

- `google-chrome-beta` and `google-chrome-dev` have been removed due to the
  lack of maintenance in nixpkgs. Consider using `google-chrome` instead.

- The `services.ananicy.extraRules` option now has the type of `listOf attrs`
  instead of `string`.

- `buildVimPluginFrom2Nix` has been renamed to `buildVimPlugin`, which now
  now skips `configurePhase` and `buildPhase`.

- JACK tools (`jack_*` except `jack_control`) have moved from the `jack2`
  package to `jack-example-tools`.

- The `waagent` service does provisioning now.

- The `matrix-synapse` package & module have undergone some significant
  internal changes, for most setups no intervention is needed, though:
  - The option
    [`services.matrix-synapse.package`](#opt-services.matrix-synapse.package)
    is read-only now. For modifying the package, use an overlay which modifies
    `matrix-synapse-unwrapped` instead. More on that below.
  - The `enableSystemd` & `enableRedis` arguments have been removed and
    `matrix-synapse` has been renamed to `matrix-synapse-unwrapped`. Also,
    several optional dependencies (such as `psycopg2` or `authlib`) have been
    removed.
  - These optional dependencies are automatically added via a wrapper
    (`pkgs.matrix-synapse.override { extras = ["redis"]; }` for `hiredis` &
    `txredisapi` for instance) if the relevant config section is declared in
    `services.matrix-synapse.settings`. For instance, if
    `services.matrix-synapse.settings.redis.enabled` is set to `true`,
    `"redis"` will be automatically added to the `extras` list of
    `pkgs.matrix-synapse`.
  - A list of all extras (and the extras enabled by default) can be found at
    the [option's reference for
    `services.matrix-synapse.extras`](#opt-services.matrix-synapse.extras).
  - In some cases (e.g. for running synapse workers) it was necessary to re-use
    the `PYTHONPATH` of `matrix-synapse.service`'s environment to have all
    plugins available. This isn't necessary anymore, instead
    `config.services.matrix-synapse.package` can be used as it points to the
    wrapper with properly configured `extras` and also all plugins defined via
    [`services.matrix-synapse.plugins`](#opt-services.matrix-synapse.plugins)
    available. This is also the reason for why the option is read-only now,
    it's supposed to be set by the module only.

- `netbox` was updated to v3.6. `services.netbox.package` still defaults
  to v3.5 if `stateVersion` is earlier than 23.11. Refer to upstream's breaking
  changes [for
  v3.6.0](https://github.com/netbox-community/netbox/releases/tag/v3.6.0) and
  upgrade NetBox by changing `services.netbox.package`. Database migrations
  will be run automatically.

- `etcd` has been updated to v3.5. Refer to upgrade guides for [v3.3 to
  v3.4](https://etcd.io/docs/v3.5/upgrades/upgrade_3_4/) and [v3.4 to
  v3.5](https://etcd.io/docs/v3.5/upgrades/upgrade_3_5/) for more details.

- `gitlab` installations created or updated between versions \[15.11.0,
  15.11.2] have an incorrect database schema. This will become a problem when
  upgrading to `gitlab` >=16.2.0. A workaround for affected users can be found
  in the [GitLab
  docs](https://docs.gitlab.com/ee/update/versions/gitlab_16_changes.html#undefined-column-error-upgrading-to-162-or-later).


- `consul` has been updated to v1.16.0. Refer to the [release
  note](https://github.com/hashicorp/consul/releases/tag/v1.16.0) for more
  details. Once a new Consul version has started and upgraded it's data
  directory, it generally cannot be downgraded to the previous version.

- `llvmPackages_rocm` has been moved to `rocmPackages.llvm`.

- `hip`, `rocm-opencl-runtime`, `rocm-opencl-icd`, and `rocclr` have been
  combined into `rocmPackages.clr`.

- `clang-ocl`, `clr`, `composable_kernel`, `hipblas`, `hipcc`, `hip-common`, `hipcub`,
  `hipfft`, `hipfort`, `hipify`, `hipsolver`, `hipsparse`, `migraphx`, `miopen`, `miopengemm`,
  `rccl`, `rdc`, `rocalution`, `rocblas`, `rocdgbapi`, `rocfft`, `rocgdb`, `rocm-cmake`,
  `rocm-comgr`, `rocm-core`, `rocm-device-libs`, `rocminfo`, `rocmlir`, `rocm-runtime`,
  `rocm-smi`, `rocm-thunk`, `rocprim`, `rocprofiler`, `rocrand`, `rocr-debug-agent`,
  `rocsolver`, `rocsparse`, `rocthrust`, `roctracer`, `rocwmma`, and `tensile`
  have been moved to `rocmPackages`.

- `himalaya` has been updated to v0.8.0, which drops the native TLS support
  (in favor of Rustls) and add OAuth 2.0 support. Refer to the [release
  note](https://github.com/soywod/himalaya/releases/tag/v0.8.0) for more
  details.


- `nix-prefetch-git` now ignores global and user git config, to improve
  reproducibility.

- The [services.caddy.acmeCA](#opt-services.caddy.acmeCA) option defaults
  to `null` instead of `"https://acme-v02.api.letsencrypt.org/directory"` now.
  To use all of Caddy's default ACME CAs and enable Caddy's automatic issuer
  fallback feature by default, as recommended by upstream.

- The default priorities of
  [`services.nextcloud.phpOptions`](#opt-services.nextcloud.phpOptions) have
  changed. This means that e.g.
  `services.nextcloud.phpOptions."opcache.interned_strings_buffer" = "23";`
  doesn't discard all of the other defaults from this option anymore. The
  attribute values of `phpOptions` are still defaults, these can be overridden
  as shown here.

  To override all of the options (including including `upload_max_filesize`,
  `post_max_size` and `memory_limit` which all point to
  [`services.nextcloud.maxUploadSize`](#opt-services.nextcloud.maxUploadSize)
  by default) can be done like this:

  ```nix
  {
    services.nextcloud.phpOptions = lib.mkForce {
      /* ... */
    };
  }
  ```

- `php80` is no longer supported due to upstream not supporting this version
  anymore.

- PHP defaults to PHP 8.2 now, updated from v8.1.

- GraalVM has been updated to the latest version, and this brings significant
  changes. Upstream don't release multiple versions targeting different JVMs
  anymore, so now we only have one GraalVM derivation (`graalvm-ce`). While at
  first glance the version may seem a downgrade (v22.3.1 -> v21.0.0), the major
  version is now following the JVM it targets (so this latest version targets
  JVM 21). Also some products like `llvm-installable-svm` and
  `native-image-svm` were incorporate to the main GraalVM derivation, so
  they're included by default.

- GraalPy (`graalCEPackages.graalpy`), TruffleRuby
  (`graalCEPackages.truffleruby`), GraalJS (`graalCEPackages.graaljs`) and
  GraalNodeJS (`grallCEPackages.graalnodejs`) are now independent from the main
  GraalVM derivation.

- The ISC DHCP package and corresponding module have been removed, because they
  are EOL upstream. Refer [to this
  post](https://www.isc.org/blogs/isc-dhcp-eol/) for details and switch to a
  different DHCP implementation like kea or dnsmasq.

- `prometheus-unbound-exporter` has been replaced by the Let's Encrypt
  maintained version, since the previous version was archived. This requires
  some changes to the module configuration, most notable `controlInterface`
  needs migration towards `unbound.host` and requires either the `tcp://` or
  `unix://` URI scheme.

- `odoo` defaults to v16 now, updated from v15.

- `varnish` was upgraded from v7.2.x to v7.4.x. Refer to upgrade guides vor
  [v7.3](https://varnish-cache.org/docs/7.3/whats-new/upgrading-7.3.html) and
  [v7.4](https://varnish-cache.org/docs/7.4/whats-new/upgrading-7.4.html). The
  current LTS version is still offered as `varnish60`.

- `util-linux` is now supported on Darwin and is no longer an alias to
  `unixtools`. Use the `unixtools.util-linux` package for access to the Apple
  variants of the utilities.

- `services.keyd` changed API. Now you can create multiple configuration files.

- `baloo`, the file indexer and search engine used by KDE now has a patch to
  prevent files from constantly being reindexed when the device IDs of the
  their underlying storage change. This happens frequently when using btrfs or
  LVM. The patch has not yet been accepted upstream but it provides a
  significantly improved experience. When upgrading, reset baloo to get a clean
  index: `balooctl disable ; balooctl purge ; balooctl enable`.

- The `vlock` program from the `kbd` package has been moved into its own
  package output and should now be referenced explicitly as `kbd.vlock` or
  replaced with an alternative such as the standalone `vlock` package or
  `physlock`.

- `fileSystems.<name>.autoFormat` now uses `systemd-makefs`, which does not
  accept formatting options. Therefore, `fileSystems.<name>.formatOptions` has
  been removed.

- `fileSystems.<name>.autoResize` uses `systemd-growfs` to resize the file
  system online in Stage 2 now. This means that `f2fs` and `ext2` can no longer
  be auto resized, while `xfs` and `btrfs` now can be.

- `fuse3` has been updated from v3.11.0 to v3.16.2. Refer to the
  [changelog](https://github.com/libfuse/libfuse/blob/fuse-3.16.2/ChangeLog.rst#libfuse-3162-2023-10-10)
  for an overview of the changes.

  Unsupported mount options are no longer silently accepted [(since
  3.15.0)](https://github.com/libfuse/libfuse/blob/fuse-3.16.2/ChangeLog.rst#libfuse-3150-2023-06-09).
  The [affected mount
  options](https://github.com/libfuse/libfuse/commit/dba6b3983af34f30de01cf532dff0b66f0ed6045)
  are: `atime`, `diratime`, `lazytime`, `nolazytime`, `relatime`, `norelatime`,
  `strictatime`.

  For example,

  ```bash
  $ sshfs 127.0.0.1:/home/test/testdir /home/test/sshfs_mnt -o atime
  ```

  would previously terminate successfully with the mount point established, now
  it outputs the error message ``fuse: unknown option(s): `-o atime'`` and
  terminates with exit status 1.

- `nixos-rebuild {switch,boot,test,dry-activate}` runs the system
  activation inside `systemd-run` now, creating an ephemeral systemd service
  and protecting the system switch against issues like network disconnections
  during remote (e.g. SSH) sessions. This has the side effect of running the
  switch in an isolated environment, that could possible break post-switch
  scripts that depends on things like environment variables being set. If you
  want to opt-out from this behavior for now, you may set the
  `NIXOS_SWITCH_USE_DIRTY_ENV` environment variable before running
  `nixos-rebuild`. However, keep in mind that this option will be removed in
  the future.

- The `services.vaultwarden.config` option default value was changed to make
  Vaultwarden only listen on localhost, following the [secure defaults for most
  NixOS services](https://github.com/NixOS/nixpkgs/issues/100192).

- `services.lemmy.settings.federation` was removed in v0.17.0 and no longer has
  any effect. To enable federation, the hostname must be set in the
  configuration file and then federation must be enabled in the admin web UI.
  Refer to the [release
  notes](https://github.com/LemmyNet/lemmy/blob/c32585b03429f0f76d1e4ff738786321a0a9df98/RELEASES.md#upgrade-instructions)
  for more details.

- `pict-rs` was upgraded from v0.3 to v0.4 and contains an incompatible database
  & configuration change. To upgrade on systems with `stateVersion = "23.05";`
  or older follow the migration steps from
  https://git.asonix.dog/asonix/pict-rs#user-content-0-3-to-0-4-migration-guide
  and set `services.pict-rs.package = pkgs.pict-rs;`.

- The following packages in `haskellPackages` have a separate bin output now:
  `cabal-fmt`, `calligraphy`, `eventlog2html`, `ghc-debug-brick`, `hindent`,
  `nixfmt`, `releaser`. This means you need to replace e.g.
  `"${pkgs.haskellPackages.nixfmt}/bin/nixfmt"` with `"${lib.getBin
  pkgs.haskellPackages.nixfmt}/bin/nixfmt"` or `"${lib.getExe
  pkgs.haskellPackages.nixfmt}"`. The binaries also won’t be in scope if you
  rely on them being installed e.g. via `ghcWithPackages`.
  `environment.packages` picks the `bin` output automatically, so for normal
  installation no intervention is required. Also, toplevel attributes like
  `pkgs.nixfmt` are not impacted negatively by this change.

- `spamassassin` no longer supports the `Hashcash` module. The module needs to
  be removed from the `loadplugin` list if it was copied over from the default
  `initPreConf` option.

- `nano` was removed from `environment.defaultPackages`. To not leave systems
  without a editor, now `programs.nano.enable` is enabled by default.

- `programs.nano.nanorc` and `programs.nano.syntaxHighlight` no longer have an
  effect unless `programs.nano.enable` is set to true which is the default.

- `services.outline.sequelizeArguments` has been removed, as `outline` no
  longer executes database migrations via the `sequelize` cli.

- The binary of the package `cloud-sql-proxy` has changed from
  `cloud_sql_proxy` to `cloud-sql-proxy`.

- The module `services.apache-kafka` was largely rewritten and has certain
  breaking changes. To be precise, this means that the following things have
  changed:
  - Most settings have been migrated to
    [services.apache-kafka.settings](#opt-services.apache-kafka.settings).
    - Care must be taken when adapting an existing cluster to these changes,
      see [](#module-services-apache-kafka-migrating-to-settings).
  - By virtue of being less opinionated, it is now possible to use the module
    to run Apache Kafka in KRaft mode instead of Zookeeper mode.
    - [A few options](#module-services-apache-kafka-kraft) have been added to
      assist in this mode.

- Garage has been upgraded to v0.9.x. `services.garage.package` needs to be
  explicitly set now, so version upgrades can be done in a controlled fashion.
  For this, we expose `garage_x_y` attributes which can be set here.

- `voms` and `xrootd` now moves the `$out/etc` content to the `$etc` output
  instead of `$out/etc.orig`, when input argument `externalEtc` is not `null`.

- The `woodpecker-*` CI packages have been updated to v1.0.0. This release is
  wildly incompatible with the v0.15.x versions that were previously packaged.
  Refer to [upstream's
  documentation](https://woodpecker-ci.org/docs/next/migrations#100) to learn
  how to update your CI configurations.

- Meilisearch was updated from v1.3.1 to v1.5.0. The update has breaking
  changes about backslashes and filtering. Refer to the [release
  announcement](https://blog.meilisearch.com/v1-4-release/) for more
  details.

- The Caddy module gained a new option named `services.caddy.enableReload`
  which is enabled by default. It allows reloading the service instead of
  restarting it, if only a config file has changed. This option must be
  disabled if you have turned off the [Caddy admin
  API](https://caddyserver.com/docs/caddyfile/options#admin). If you keep this
  option enabled, you should consider setting
  [`grace_period`](https://caddyserver.com/docs/caddyfile/options#grace-period)
  to a non-infinite value to prevent Caddy from delaying the reload
  indefinitely.

- mdraid support is optional now. This reduces initramfs size and prevents the
  potentially undesired automatic detection and activation of software RAID
  pools. It is disabled by default in new configurations (determined by
  `stateVersion`), but the appropriate settings will be generated by
  `nixos-generate-config` when installing to a software RAID device, so the
  standard installation procedure should be unaffected. If you have custom
  configs relying on mdraid, ensure that you use `stateVersion` correctly or
  set `boot.swraid.enable` manually. On systems with an updated `stateVersion`
  we now also emit warnings if `mdadm.conf` does not contain the minimum
  required configuration necessary to run the dynamically enabled monitoring
  daemons.

- The `go-ethereum` package has been updated to v1.12.0. This drops support for
  proof-of-work. Its GraphQL API now encodes all numeric values as hex strings
  and the GraphQL UI is updated to v2.0. The default database has changed from
  `leveldb` to `pebble` but `leveldb` can be forced with the
  --db.engine=leveldb flag. The `checkpoint-admin` command was [removed along
  with trusted
  checkpoints](https://github.com/ethereum/go-ethereum/pull/27147).

- The `aseprite-unfree` package has been upgraded from v1.2.16.3 to v1.2.40.
  The free version of aseprite has been dropped because it is EOL and the
  package attribute now points to the unfree version. A maintained fork of the
  last free version of Aseprite, named 'LibreSprite', is available in the
  `libresprite` package.

- The default `kops` version is v1.28.0 now and support for v1.25 and older have
  been dropped.

- `pharo` has been updated to latest stable v10.0.8, which is compatible with
  the latest stable and oldstable images (Pharo 10 and 11). The VM in question
  is the 64bit Spur. The 32bit version has been dropped due to lack of
  maintenance. The Cog VM has been deleted because it is severily outdated.
  Finally, the `pharo-launcher` package has been deleted because it was not
  compatible with the newer VM, and due to lack of maintenance.

- Emacs mainline v29 was introduced. This new version includes many major
  additions, most notably `tree-sitter` support (enabled by default) and
  the pgtk variant (useful for Wayland users), which is available under the
  attribute `emacs29-pgtk`.

- Emacs macport version 29 was introduced.

- The option `services.networking.networkmanager.enableFccUnlock` was removed
  in favor of `networking.networkmanager.fccUnlockScripts`, which allows
  specifying unlock scripts explicitly. The previous option enabled all unlock
  scripts bundled with ModemManager, which is risky, and didn't allow using
  vendor-provided unlock scripts at all.

- The `html-proofer` package has been updated from major version 3 to major
  version 5, which includes [breaking
  changes](https://github.com/gjtorikian/html-proofer/blob/v5.0.8/UPGRADING.md).

- `kratos` has been updated from v0.10.1 to the first stable v1.0.0, please
  read the [v0.10.1 to
  v0.11.0](https://github.com/ory/kratos/releases/tag/v0.11.0), [v0.11.0 to
  v0.11.1](https://github.com/ory/kratos/releases/tag/v0.11.1), [v0.11.1 to
  v0.13.0](https://github.com/ory/kratos/releases/tag/v0.13.0) and [v0.13.0 to
  v1.0.0](https://github.com/ory/kratos/releases/tag/v1.0.0) upgrade guides.
  The most notable breaking change is the introduction of one-time passwords
  (`code`) and update of the default recovery strategy from `link` to `code`.

- The `hail` module was removed, as `hail` was unmaintained since 2017.

- Package `noto-fonts-emoji` was renamed to `noto-fonts-color-emoji`. Refer to
  [PR #221181](https://github.com/NixOS/nixpkgs/issues/221181) for more
  details.

- Package `cloud-sql-proxy` was renamed to `google-cloud-sql-proxy` as it
  cannot be used with other cloud providers.

- Package `pash` was removed due to being archived upstream. Use `powershell`
  as an alternative.

- The option `services.plausible.releaseCookiePath` has been removed. Plausible
  does not use any distributed Erlang features, and does not plan to (refer to
  [discussion](https://github.com/NixOS/nixpkgs/pull/130297#issuecomment-1805851333)),
  Thus NixOS disables them now , and the Erlang cookie becomes unnecessary. You
  may delete the file that `releaseCookiePath` was set to.

- `security.sudo.extraRules` includes `root`'s default rule now, with ordering
  priority 400. This is functionally identical for users not specifying rule
  order, or relying on `mkBefore` and `mkAfter`, but may impact users calling
  `mkOrder n` with n ≤ 400.

- X keyboard extension (XKB) options have been reorganized into a single
  attribute set, `services.xserver.xkb`. Specifically,
  `services.xserver.layout` is `services.xserver.xkb.layout` now,
  `services.xserver.extraLayouts` is `services.xserver.xkb.extraLayouts` now,
  `services.xserver.xkbModel` is `services.xserver.xkb.model` now,
  `services.xserver.xkbOptions` is `services.xserver.xkb.options` now ,
  `services.xserver.xkbVariant` is `services.xserver.xkb.variant` now, and
  `services.xserver.xkbDir` is `services.xserver.xkb.dir` now.

- `networking.networkmanager.firewallBackend` was removed as NixOS is now using
  iptables-nftables-compat even when using iptables, therefore Networkmanager
  uses the nftables backend unconditionally now.

- `rome` was removed because it is no longer maintained and is succeeded by
  `biome`.

- The `prometheus-knot-exporter` was migrated to a version maintained by
  CZ.NIC. Various metric names have changed, so checking existing rules is
  recommended.

- The `services.mtr-exporter.target` has been removed in favor of
  `services.mtr-exporter.jobs` which allows specifying multiple targets.

- `blender-with-packages` has been deprecated in favor of
  `blender.withPackages`, for example `blender.withPackages (ps: [ps.bpycv])`.
  It behaves similarly to `python3.withPackages`.

- Setting `nixpkgs.config` options while providing an external `pkgs` instance
  will now raise an error instead of silently ignoring the options. NixOS
  modules no longer set `nixpkgs.config` to accommodate this. This specifically
  affects `services.locate`,
  `services.xserver.displayManager.lightdm.greeters.tiny` and
  `programs.firefox` NixOS modules. No manual intervention should be required
  in most cases, however, configurations relying on those modules affecting
  packages outside the system environment should switch to explicit overlays.

- `privacyidea` (and the corresponding `privacyidea-ldap-proxy`) has been
  removed from nixpkgs because it has severely outdated dependencies that
  became unmaintainable with nixpkgs' python package-set.

- `dagger` was removed because using a package called `dagger` and packaging it
  from source violates their trademark policy.

- `win-virtio` package was renamed to `virtio-win` to be consistent with the upstream package name.

- `ps3netsrv` has been replaced with the webman-mod fork, the executable has
  been renamed from `ps3netsrv++` to `ps3netsrv` and cli parameters have
  changed.

- `ssm-agent` package and module were renamed to `amazon-ssm-agent` to be
  consistent with the upstream package name.

- `services.kea.{ctrl-agent,dhcp-ddns,dhcp,dhcp6}` now use separate runtime
  directories instead of `/run/kea` to work around the runtime directory being
  cleared on service start.

- `mkDerivation` rejects MD5 hashes now.

- The `junicode` font package has been updated to [major
  v2](https://github.com/psb1558/Junicode-font/releases/tag/v2.001), which is
  a font family now. In particular, plain `Junicode.ttf` no longer exists. In
  addition, TrueType font files are now placed in `font/truetype` instead of
  `font/junicode-ttf`; this change does not affect use via `fonts.packages`
  option.

- The `prayer` package as well as `services.prayer` have been removed because
  it's been unmaintained for several years and the author's website has
  vanished.

- The `chrony` NixOS module now tracks the real-time clock drift from the
  system clock with `rtcfile` and automatically adjusts it with `rtcautotrim`
  when it exceeds the maximum error specified in
  `services.chrony.autotrimThreshold` (defaults to 30 seconds). If you enabled
  `rtcsync` in `extraConfig`, you should remove RTC related options from
  `extraConfig`. If you do not want chrony configured to keep the RTC in check,
  you can set `services.chrony.enableRTCTrimming = false;`.

- `trilium-desktop` and `trilium-server` have been updated to
  [v0.61](https://github.com/zadam/trilium/releases/tag/v0.61.12). For existing
  installations, upgrading to this version is supported only after running
  v0.60.x at least once. If you are still on an older version, make sure to
  update to v0.60 (available in NixOS 23.05) first and only then to v0.61
  (available in NixOS 23.11).

- Cassandra now defaults to v4.x, updated from v3.11.x.


- FoundationDB now defaults to major version 7.

- [glibc](https://www.gnu.org/software/libc/) has been updated from v2.37 to
  v2.38. Refer to the [the release
  notes](https://sourceware.org/glibc/wiki/Release/2.38) for more details.

- `linuxPackages_testing_bcachefs` is now soft-deprecated by
  `linuxPackages_testing`.
  - Please consider changing your NixOS configuration's `boot.kernelPackages`
    to `linuxPackages_testing` until a stable kernel with bcachefs support is
    released.

- PostgreSQL now defaults to major version 15.

- All [ROCm](https://rocm.docs.amd.com/en/latest/) packages have been updated
  to v5.7.0.
  - [ROCm](https://rocm.docs.amd.com/en/latest/) package attribute sets are
    versioned: `rocmPackages` -> `rocmPackages_5`.

- [systemd](https://systemd.io) has been updated from v253 to v254, refer to
  [the release
  notes](https://github.com/systemd/systemd/blob/v254/NEWS#L3-L659) for more
  details.
    - `boot.resumeDevice` **must be specified** when hibernating if not in EFI
      mode.
    - systemd may warn your system about the permissions of your ESP partition
      (often `/boot`), this warning can be ignored for now, we are looking into
      a satisfying solution regarding this problem.
    - Updating with `nixos-rebuild boot` and rebooting is recommended, since in
      some rare cases the `nixos-rebuild switch` into the new generation on a
      live system might fail due to missing mount units.

- If the user has a custom shell enabled via `users.users.${USERNAME}.shell =
  ${CUSTOMSHELL}`, the assertion will require them to also set
  `programs.${CUSTOMSHELL}.enable = true`. This is generally safe behavior, but
  for anyone needing to opt out from the check
  `users.users.${USERNAME}.ignoreShellProgramCheck = true` will do the job.

- `yarn-berry` has been updated to v4.0.1. This means that NodeJS versions less
  v18.12 are no longer supported by it. Refer to the [upstream
  changelog](https://github.com/yarnpkg/berry/blob/master/CHANGELOG.md) for
  more details.

- GNOME has been updated to v45. Refer to the [release
  notes](https://release.gnome.org/45/) for more details. Notably, Loupe has
  replaced Eye of GNOME as the default image viewer, Snapshot has replaced
  Cheese as the default camera application, and Photos will no longer be
  installed.

- The module [services.ankisyncd](#opt-services.ankisyncd.package) has been
  switched to
  [anki-sync-server-rs](https://github.com/ankicommunity/anki-sync-server-rs).
  The former version written in Python was difficult to update, did not receive
  updates in a while, and did not support recent versions of Anki.

  Unfortunately all servers supporting new clients do not support the older
  sync protocol that was used in the old server. This includes newer version of
  anki-sync-server, Anki's built in sync server and this new Rust package. Thus
  old clients will also need updating. In particular nixpkgs's Anki package is
  also being updated in this release.

  The module update takes care of the new config syntax. The data itself (i.e.
  user login and card information) is compatible. Thus users of the module will
  be able to simply log in again after updating both client and server without
  any extra action needed to be taken.

- The argument `vendorSha256` of `buildGoModule` is deprecated. Use
  `vendorHash` instead. Refer to [PR
  \#259999](https://github.com/NixOS/nixpkgs/pull/259999)) for more details.

- `go-modules` in `buildGoModule` attrs has been renamed to `goModules`.

- The package `cawbird` is dropped from nixpkgs. It broke by the Twitter API
  closing down and has been abandoned upstream.

- The Cinnamon module now enables XDG desktop integration by default. If you
  are experiencing collisions related to xdg-desktop-portal-gtk you can safely
  remove `xdg.portal.extraPortals = [ pkgs.xdg-desktop-portal-gtk ];` from your
  NixOS configuration.

- GNOME, Pantheon, Cinnamon modules no longer force Qt applications to use
  Adwaita style. This implemantion  was buggy and is no longer maintained
  upstream. Specifically, Cinnamon defaults to the gtk2 style instead now,
  following the default in Linux Mint). If you still want Adwaita used, you may
  add the following options to your configuration. Please be aware, that it
  will probably be removed eventually.

  ```nix
  {
    qt = {
      enable = true;
      platformTheme = "gnome";
      style = "adwaita";
    };
  }
  ```

- DocBook option documentation is no longer supported, all module documentation
  now uses Markdown.

- Docker defaults to v24 now, as 20.10 is stopping to receive security updates
  and bug fixes after [December 10,
  2023](https://github.com/moby/moby/discussions/45104).

- Elixir defaults to v1.15 now. Refer to their
  [changelog](https://elixir-lang.org/blog/2023/06/19/elixir-v1-15-0-released/)
  for more details.

- The `extend` function of `llvmPackages` has been removed due it coming from
  the `tools` attrset thus only extending the `tool` attrset. A possible
  replacement is to construct the set from `libraries` and `tools`, or patch
  nixpkgs.

- `ffmpeg` defaults to `ffmpeg_6` now, upgrading from `ffmpeg_5`.

- `fontconfig` defaults to using greyscale antialiasing now. Previously
  subpixel antialiasing was used because of a [recommendation from one of the
  downstreams](https://gitlab.freedesktop.org/fontconfig/fontconfig/-/issues/337).
  You can change this value by configuring
  [](#opt-fonts.fontconfig.subpixel.rgba) accordingly.

- The `fonts.fonts` and `fonts.enableDefaultFonts` options have been renamed to
  `fonts.packages` and `fonts.enableDefaultPackages` respectively.

- `services.hedgedoc` has been heavily refactored, reducing the amount of
  declared options in the module. Most of the options should still work without
  any changes to the configuration. Some options have been deprecated, as they
  no longer have any effect. Refer to [PR
  #244941](https://github.com/NixOS/nixpkgs/pull/244941) for more details.

- `jq` was updated to v1.7. This is its [first release in 5
  years](https://github.com/jqlang/jq/releases/tag/jq-1.7).

- [`lib.attrsets.foldlAttrs`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.attrsets.foldlAttrs)
  now always evaluates the initial accumulator argument first.

- [`lib.lists.foldl'`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.foldl-prime)
  now always evaluates the initial accumulator argument first. If you depend on
  the lazier behavior, consider using
  [`lib.lists.foldl`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.foldl)
  or
  [`builtins.foldl'`](https://nixos.org/manual/nix/stable/language/builtins.html#builtins-foldl')
  instead.

-  Now `magma` defaults to `magma-hip` instead of `magma-cuda`. It also
   respects the `config.cudaSupport` and `config.rocmSupport` options.

- The MariaDB C client library was upgraded from v3.2.x to v3.3.x. Refer to the
  [upstream release
  notes](https://mariadb.com/kb/en/mariadb-connector-c-33-release-notes/) for
  more details.

- Mattermost has been upgraded to extended support version 8.1 as the previously
  packaged extended support version 7.8 is [reaching end-of-life](https://docs.mattermost.com/upgrade/extended-support-release.html).
  Migration may take some time, refer to the [changelog](https://docs.mattermost.com/install/self-managed-changelog.html#release-v8-1-extended-support-release)
  and [important upgrade notes](https://docs.mattermost.com/upgrade/important-upgrade-notes.html).

- The `netdata` package disables cloud support by default now. To enable it use the `netdataCloud` package.

- `networking.nftables` is no longer flushing all rulesets on every reload.
  Use `networking.nftables.flushRuleset = true;` to enable the previous behaviour.

- Node.js v14, v16 has been removed as they were end of life. Any dependent packages that contributors were not able to reasonably upgrade were dropped after a month of notice to their maintainers, were **removed**.
  - This includes VSCode Server.
  - This includes Kibana 7 as the ELK stack is unmaintained in nixpkgs and is marked for slow removal.

- The application firewall `opensnitch` uses the process monitor method eBPF as
  default now. This is recommended by upstream. The method may be changed with
  the setting
  [services.opensnitch.settings.ProcMonitorMethod](#opt-services.opensnitch.settings.ProcMonitorMethod).

- `paperwork` is updated to v2.2. Documents scanned with this version will not
  be visible to previous versions if you downgrade. Refer to the [upstream
  announcement](https://forum.openpaper.work/t/paperwork-2-2-testing-phase/316#important-switch-from-jpeg-to-png-for-new-pages-2)
  for details and workarounds.

- The latest available version of Nextcloud is v27 (available as
  `pkgs.nextcloud27`). The installation logic is as follows:
  - If [`services.nextcloud.package`](#opt-services.nextcloud.package) is
    specified explicitly, this package will be installed (**recommended**)
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=23.11,
    `pkgs.nextcloud27` will be installed by default.
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=23.05,
    `pkgs.nextcloud26` will be installed by default.
  - Please note that an upgrade from v25 (or older) to v27 is not possible
    directly. Please upgrade to `nextcloud26` (or earlier) first. Nextcloud
    prohibits skipping major versions while upgrading. You may upgrade by
    declaring [`services.nextcloud.package =
    pkgs.nextcloud26;`](options.html#opt-services.nextcloud.package) inbetween.

- `postgresql_11` has been removed since it'll stop receiving fixes on November
  9th 2023.

- `programs.gnupg.agent.pinentryFlavor` is set in `/etc/gnupg/gpg-agent.conf`
  now. It will no longer take precedence over a `pinentry-program` set in
  `~/.gnupg/gpg-agent.conf`.

- `python3.pkgs.flitBuildHook` has been removed. Use `flit-core` and `format =
  "pyproject"` instead.

- Certificate generation via the `security.acme` limits the concurrent number
  of running certificate renewals and generation jobs now. This is to avoid
  spiking resource usage when processing many certificates at once. The limit
  defaults to *5* and can be adjusted via `maxConcurrentRenewals`. Setting the
  value to *0* disables the limits altogether.

- `services.borgmatic.settings.location` and
  `services.borgmatic.configurations.<name>.location` are deprecated, please
  move your options out of sections to the global scope.

- `services.fail2ban.jails` can be configured with attribute sets now, defining
  settings and filters instead of lines. The stringed options `daemonConfig`
  and `extraSettings` have respectively been replaced by `daemonSettings` and
  `jails.DEFAULT.settings`. Those  use attribute sets.

- The `services.mbpfan` module has the option `aggressive` enabled by default
  now. This is for better heat moderation. To get the upstream defaults you may
  disable this.

- Apptainer/Singularity defaults to using `"$out/var/lib"` for the
  `LOCALSTATEDIR` configuration option instead of the top-level `"/var/lib"`
  now. This change impacts the `SESSIONDIR` (container-run-time mount point)
  configuration, which is set to `$LOCALSTATEDIR/<apptainer or
  singularity>/mnt/session`. This detaches the packages from the top-level
  directory, rendering the NixOS module optional.

  The default behavior of the NixOS module `programs.singularity` stays
  unchanged. We add a new option
  `programs.singularity.enableExternalSysConfDir` (default to `true`) to
  specify whether to set the top-level `"/var/lib"` as `LOCALSTATEDIR` or not.

- The `services.sslh` module has been updated to follow [RFC
  0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md).
  As such, several options have been moved to the freeform attribute set
  [services.sslh.settings](#opt-services.sslh.settings), which allows to change
  any of the settings in {manpage}`sslh(8)`.

  In addition, the newly added option
  [services.sslh.method](#opt-services.sslh.method) allows to switch between
  the {manpage}`fork(2)`, {manpage}`select(2)` and `libev`-based connection
  handling method. Refer to the [sslh
  docs](https://github.com/yrutschle/sslh/blob/master/doc/INSTALL.md#binaries)
  for a comparison.

- Suricata was upgraded from v6.0 to v7.0 and no longer considers HTTP/2
  support as experimental. Refer to [upstream release
  notes](https://forum.suricata.io/t/suricata-7-0-0-released/3715) for more
  details.

- `teleport` has been upgraded from major version 12 to major version 14.
  Refer to upstream [upgrade
  instructions](https://goteleport.com/docs/management/operations/upgrading/)
  and release notes for
  [v13](https://goteleport.com/docs/changelog/#1300-050823) and
  [v14](https://goteleport.com/docs/changelog/#1400-092023). Note that Teleport
  does not officially support upgrades across more than one major version at a
  time. If you're running Teleport server components, it is recommended to
  first upgrade to an intermediate v13.x version by setting
  `services.teleport.package = pkgs.teleport_13`. Afterwards, this option can
  be removed to upgrade to the default version (14).

- `zfs` was updated from v2.1.x to v2.2.0, [enabling newer kernel support and
  adding new features](https://github.com/openzfs/zfs/releases/tag/zfs-2.2.0).

- The use of `sourceRoot = "source";`, `sourceRoot = "source/subdir";`, and
  similar lines in package derivations using the default `unpackPhase` is
  deprecated as it requires `unpackPhase` to always produce a directory named
  "source". Use `sourceRoot = src.name`, `sourceRoot = "${src.name}/subdir";`,
  or `setSourceRoot = "sourceRoot=$(echo */subdir)";` or similar instead.

- The `django` alias in the python package set was upgraded to Django v4.x.
  Applications that consume Django should always pin their python environment
  to a compatible major version, so they can move at their own pace.

  ```nix
  {
    python = python3.override {
      packageOverrides = self: super: {
        django = super.django_3;
      };
    };
  }
  ```

- The `qemu-vm.nix` module by default now identifies block devices via
  persistent names available in `/dev/disk/by-*`. Because the rootDevice is
  identified by its filesystem label, it needs to be formatted before the VM is
  started. The functionality of automatically formatting the rootDevice in the
  initrd is removed from the QEMU module. However, for tests that depend on
  this functionality, a test utility for the scripted initrd is added
  (`nixos/tests/common/auto-format-root-device.nix`). To use this in a NixOS
  test, import the module, e.g. `imports = [
  ./common/auto-format-root-device.nix ];` When you use the systemd initrd, you
  can automatically format the root device by setting
  `virtualisation.fileSystems."/".autoFormat = true;`.

- The `electron` packages places its application files in
  `$out/libexec/electron` instead of `$out/lib/electron` now. Packages using
  electron-builder will fail to build and need to be adjusted by changing `lib`
  to `libexec`.

### New Services {#sec-release-23.11-nixos-new-services}

- [MCHPRS](https://github.com/MCHPR/MCHPRS), a multithreaded Minecraft server
  built for redstone. Available as
  [services.mchprs](#opt-services.mchprs.enable).

- [acme-dns](https://github.com/joohoi/acme-dns), a limited DNS server to
  handle ACME DNS challenges easily and securely. Available as
  [services.acme-dns](#opt-services.acme-dns.enable).

- [frp](https://github.com/fatedier/frp), a fast reverse proxy to help you
  expose a local server behind a NAT or firewall to the Internet. Available as
  [services.frp](#opt-services.frp.enable).

- [river](https://github.com/riverwm/river), A dynamic tiling wayland
  compositor. Available as [programs.river](#opt-programs.river.enable).

- [wayfire](https://wayfire.org), a modular and extensible wayland compositor.
  Available as [programs.wayfire](#opt-programs.wayfire.enable).

- [mautrix-whatsapp](https://docs.mau.fi/bridges/go/whatsapp/index.html), a
  Matrix-WhatsApp puppeting bridge. Available as
  [services.mautrix-whatsapp](#opt-services.mautrix-whatsapp.enable).

- [hddfancontrol](https://github.com/desbma/hddfancontrol), a service to
  regulate fan speeds based on hard drive temperature. Available as
  [services.hddfancontrol](#opt-services.hddfancontrol.enable).

- [seatd](https://sr.ht/~kennylevinsen/seatd/), A minimal seat management
  daemon. Available as [services.seatd](#opt-services.seatd.enable).

- [GoToSocial](https://gotosocial.org/), an ActivityPub social network server
  written in Golang. Available as
  [services.gotosocial](#opt-services.gotosocial.enable).

- [Castopod](https://castopod.org/), an open-source hosting platform made for
  podcasters who want to engage and interact with their audience. Available as
  [services.castopod](#opt-services.castopod.enable).

- [Typesense](https://github.com/typesense/typesense), a fast, typo-tolerant
  search engine for building delightful search experiences. Available as
  [services.typesense](#opt-services.typesense.enable).

* [NS-USBLoader](https://github.com/developersu/ns-usbloader/), an all-in-one
  tool for managing Nintendo Switch homebrew. Available as
  [programs.ns-usbloader](#opt-programs.ns-usbloader.enable).

- [athens](https://github.com/gomods/athens), a Go module datastore and proxy. Available as [services.athens](#opt-services.athens.enable).

- [Mobilizon](https://joinmobilizon.org/), a Fediverse platform for publishing
  events. Available as [services.mobilizon](#opt-services.mobilizon.enable).

- [Anuko Time Tracker](https://github.com/anuko/timetracker), a simple, easy to
  use, open source time tracking system. Available as
  [services.anuko-time-tracker](#opt-services.anuko-time-tracker.enable).

- [Prometheus MySQL exporter](https://github.com/prometheus/mysqld_exporter), a
  MySQL server exporter for Prometheus. Available as
  [services.prometheus.exporters.mysqld](#opt-services.prometheus.exporters.mysqld.enable).

- [LibreNMS](https://www.librenms.org), a auto-discovering PHP/MySQL/SNMP based
  network monitoring. Available as
  [services.librenms](#opt-services.librenms.enable).

- [Livebook](https://livebook.dev/), an interactive notebook with support for
  Elixir, graphs, machine learning, and more. Available as
  [services.livebook](#opt-services.livebook.enableUserService).

- [sitespeed-io](https://sitespeed.io), a tool that can generate metrics such
  as timings and diagnostics for websites. Available as
  [services.sitespeed-io](#opt-services.sitespeed-io.enable).

- [stalwart-mail](https://stalw.art), an all-in-one email server (SMTP, IMAP,
  JMAP). Available as
  [services.stalwart-mail](#opt-services.stalwart-mail.enable).


- [tang](https://github.com/latchset/tang), a server for binding data to
  network presence. Available as [services.tang](#opt-services.tang.enable).

- [Jool](https://nicmx.github.io/Jool/en/index.html), a kernelspace NAT64 and
  SIIT implementation providing translation between IPv4 and IPv6. Available as
  [networking.jool.enable](#opt-networking.jool.enable).

- [Home Assistant
  Satellite](https://github.com/synesthesiam/homeassistant-satellite), a
  streaming audio satellite for Home Assistant voice pipelines, where you can
  reuse existing mic and speaker hardware. Available as
  `services.homeassistant-satellite`.

- [Apache Guacamole](https://guacamole.apache.org/), a cross-platform,
  clientless remote desktop gateway. Available as
  [services.guacamole-server](#opt-services.guacamole-server.enable) and
  [services.guacamole-client](#opt-services.guacamole-client.enable) services.

- [pgBouncer](https://www.pgbouncer.org), a PostgreSQL connection pooler.
  Available as [services.pgbouncer](#opt-services.pgbouncer.enable).

- [Goss](https://goss.rocks/), a YAML based serverspec alternative tool for
  validating a server's configuration. Available as
  [services.goss](#opt-services.goss.enable).

- [trust-dns](https://trust-dns.org/), a Rust based DNS server built to be safe
  and secure from the ground up. Available as
  [services.trust-dns](#opt-services.trust-dns.enable).

- [osquery](https://www.osquery.io/), a SQL powered operating system
  instrumentation, monitoring, and analytics. Available as
  [services.osquery](#opt-services.osquery.enable).

- [ebusd](https://ebusd.eu), a daemon for handling communication with eBUS
  devices connected to a 2-wire bus system ("energy bus" used by numerous
  heating systems). Available as [services.ebusd](#opt-services.ebusd.enable).

- [systemd-sysupdate](https://www.freedesktop.org/software/systemd/man/systemd-sysupdate.html),
  atomically updates the host OS, container images, portable service images or
  other sources. Available as [systemd.sysupdate](opt-systemd.sysupdate).

- [eris-server](https://codeberg.org/eris/eris-go), an implementation of the
  Encoding for Robust Immutable Storage (ERIS). Available as
  [services.eris-server](#opt-services.eris-server.enable).

- [forgejo](https://forgejo.org/), a git forge and drop-in replacement for
  Gitea. Available as [services.forgejo](#opt-services.forgejo.enable).

- `hardware/infiniband.nix` adds infiniband subnet manager support using an
  [opensm](https://github.com/linux-rdma/opensm) systemd-template service,
  instantiated on card guids. The module also adds kernel modules and cli
  tooling to help administrators debug and measure performance. Available as
  [hardware.infiniband.enable](#opt-hardware.infiniband.enable).

- [zwave-js](https://github.com/zwave-js/zwave-js-server), a small server
  wrapper around Z-Wave JS to access it via a WebSocket. Available as
  [services.zwave-js](#opt-services.zwave-js.enable).

- [Honk](https://humungus.tedunangst.com/r/honk), a complete ActivityPub server
  with minimal setup and support costs. Available as
  [services.honk](#opt-services.honk.enable).

- [ferretdb](https://www.ferretdb.io/), an open-source proxy, converting the
  MongoDB 6.0+ wire protocol queries to PostgreSQL or SQLite. Available as
  [services.ferretdb](options.html#opt-services.ferretdb.enable).

- [MicroBin](https://microbin.eu/), a feature rich, performant and secure text
  and file sharing web application, a "paste bin". Available as
  [services.microbin](#opt-services.microbin.enable).

- [NNCP](http://www.nncpgo.org/), nncp-daemon and nncp-caller services.
  Available as [programs.nncp.settings](#opt-programs.nncp.settings) and
  [services.nncp](#opt-services.nncp.caller.enable).

- [FastNetMon Advanced](https://fastnetmon.com/product-overview/), a commercial
  high performance DDoS detector and sensor. Available as
  [services.fastnetmon-advanced](#opt-services.fastnetmon-advanced.enable).

- [tuxedo-rs](https://github.com/AaronErhardt/tuxedo-rs), Rust utilities for
  interacting with hardware from TUXEDO Computers. Available as
  [hardware.tuxedo-rs](#opt-hardware.tuxedo-rs.enable).

- [certspotter](https://github.com/SSLMate/certspotter), a certificate
  transparency log monitor. Available as
  [services.certspotter](#opt-services.certspotter.enable).

- [audiobookshelf](https://github.com/advplyr/audiobookshelf/), a self-hosted
  audiobook and podcast server. Available as
  [services.audiobookshelf](#opt-services.audiobookshelf.enable).

- [ZITADEL](https://zitadel.com), a turnkey identity and access management
  platform. Available as [services.zitadel](#opt-services.zitadel.enable).

- [exportarr](https://github.com/onedr0p/exportarr), Prometheus Exporters for
  Bazarr, Lidarr, Prowlarr, Radarr, Readarr, and Sonarr. Available as
  [services.prometheus.exporters.exportarr-bazarr](#opt-services.prometheus.exporters.exportarr-bazarr.enable)/[services.prometheus.exporters.exportarr-lidarr](#opt-services.prometheus.exporters.exportarr-lidarr.enable)/[services.prometheus.exporters.exportarr-prowlarr](#opt-services.prometheus.exporters.exportarr-prowlarr.enable)/[services.prometheus.exporters.exportarr-radarr](#opt-services.prometheus.exporters.exportarr-radarr.enable)/[services.prometheus.exporters.exportarr-readarr](#opt-services.prometheus.exporters.exportarr-readarr.enable)/[services.prometheus.exporters.exportarr-sonarr](#opt-services.prometheus.exporters.exportarr-sonarr.enable).

- [netclient](https://github.com/gravitl/netclient), an automated WireGuard
  Management Client. Available as
  [services.netclient](#opt-services.netclient.enable).

- [trunk-ng](https://github.com/ctron/trunk), A fork of `trunk`: Build, bundle
  & ship your Rust WASM application to the web

- [virt-manager](https://virt-manager.org/), an UI for managing virtual
  machines in libvirt. Available as
  [programs.virt-manager](#opt-programs.virt-manager.enable).

- [Soft Serve](https://github.com/charmbracelet/soft-serve), a tasty,
  self-hostable Git server for the command line. Available as
  [services.soft-serve](#opt-services.soft-serve.enable).

- [Rosenpass](https://rosenpass.eu/), a service for post-quantum-secure VPNs
  with WireGuard. Available as
  [services.rosenpass](#opt-services.rosenpass.enable).

- [c2FmZQ](https://github.com/c2FmZQ/c2FmZQ/), an application that can securely
  encrypt, store, and share files, including but not limited to pictures and
  videos. Available as
  [services.c2fmzq-server](#opt-services.c2fmzq-server.enable).

- [preload](http://sourceforge.net/projects/preload), a service that makes
  applications run faster by prefetching binaries and shared objects.
  Available as [services.preload](#opt-services.preload.enable).

### Other Notable Changes {#sec-release-23.11-nixos-notable-changes}

- The new option `system.switch.enable` was added. It is enabled by default.
  Disabling it makes the system unable to be reconfigured via `nixos-rebuild`.
  This is of advantage for image based appliances where updates are handled
  outside the image.

- `services.searx` receives new options for better SearXNG support. This
  includes options for the built-in rate limiter, bot protection and
  automatically configuring a local Redis server.

- The iptables firewall module installs the `nixos-firewall-tool` now which
  allows the user to easily temporarily open ports through the firewall.

- A new option was added to the virtualisation module that enables specifying
  explicitly named network interfaces in QEMU VMs. The existing
  `virtualisation.vlans` is still supported for cases where the name of the
  network interface is irrelevant.

- `services.outline` can be configured to use local filesystem storage now.
  Previously ony S3 storage was possible. This may be set using
  [services.outline.storage.storageType](#opt-services.outline.storage.storageType).

- `pkgs.openvpn3` optionally supports systemd-resolved now. `programs.openvpn3`
  will automatically enable systemd-resolved support if
  [services.resolved.enable](#opt-services.resolved.enable) is set to true.

- The
  [services.woodpecker-server.environmentFile](#opt-services.woodpecker-server.environmentFile)
  type was changed to list of paths to be more consistent to the
  woodpecker-agent module

- `services.matrix-synapse` has new options to configure worker processes for
  matrix-synapse using
  [`services.matrix-synapse.workers`](#opt-services.matrix-synapse.workers).
  Configuring a local redis server using
  [`services.matrix-synapse.configureRedisLocally`](#opt-services.matrix-synapse.configureRedisLocally)
  is also possible now.

- The `services.nginx` module gained a `defaultListen` option at server-level
  with support for PROXY protocol listeners. Also `proxyProtocol` is exposed in
  the `services.nginx.virtualHosts.<name>.listen` option now. This it is
  possible to run PROXY listeners and non-PROXY listeners at a server-level.
  Refer to [PR #213510](https://github.com/NixOS/nixpkgs/pull/213510/) for more
  details.

- `services.restic.backups` adds wrapper scripts to your system path now. This
  wrapper script sets the same environment variables as the service, so restic
  operations can easily be run from the command line. This behavior can be
  disabled by setting `createWrapper` to `false`, for each backup
  configuration.

- `services.prometheus.exporters` has a new exporter to monitor electrical
  power consumption based on PowercapRAPL sensor called
  [Scaphandre](https://github.com/hubblo-org/scaphandre). Refer to [PR
  #239803](https://github.com/NixOS/nixpkgs/pull/239803) for more details.

- The `services.calibre-server` module has new options to configure the `host`,
  `port`, `auth.enable`, `auth.mode` and `auth.userDb` path. Refer to [PR
  #216497](https://github.com/NixOS/nixpkgs/pull/216497/) for more details.

- `services.prometheus.exporters` has a new
  [exporter](https://github.com/hipages/php-fpm_exporter) to monitor PHP-FPM
  processes. Refer to [PR
  #240394](https://github.com/NixOS/nixpkgs/pull/240394) for more details.

- `services.github-runner` and `services.github-runners.<name>` gained the
  option `nodeRuntimes`. This option defaults to `[ "node20" ]`.  I.e., the
  service supports Node.js 20 GitHub Actions only. The list of Node.js versions
  accepted by `nodeRuntimes` tracks the versions the upstream GitHub Actions
  runner supports. Refer to [PR
  #249103](https://github.com/NixOS/nixpkgs/pull/249103) for details.

- `programs.gnupg` has the option `agent.settings` now. This allows setting
  verbatim config values in `/etc/gnupg/gpg-agent.conf`.

- `dockerTools.buildImage`, `dockerTools.buildLayeredImage` and
  `dockerTools.streamLayeredImage` use `lib.makeOverridable` now . This allows
  `dockerTools`-based images to be customized more efficiently at the Nix
  level.

- `services.influxdb2` supports doing an automatic initial setup and
  provisioning of users, organizations, buckets and authentication tokens now.
  Refer to [PR #249502](https://github.com/NixOS/nixpkgs/pull/249502) for more
  details.

- `wrapHelm` exposes `passthru.pluginsDir` now which can be passed to
  `helmfile`. For convenience, a top-level package `helmfile-wrapped` has been
  added, which inherits `passthru.pluginsDir` from `kubernetes-helm-wrapped`.
  Refer to [PR #217768](https://github.com/NixOS/nixpkgs/issues/217768) for
  more details.

- The `boot.initrd.network.udhcp.enable` option allows control over DHCP during
  Stage 1 regardless of what `networking.useDHCP` is set to.

- `networking.nftables` has the option `networking.nftables.table.<table>` now. This creates tables
  and have them be updated atomically, instead of flushing the ruleset.

- `hardware.nvidia` gained `datacenter` options for enabling NVIDIA Data Center
  drivers and configuration of NVLink/NVSwitch topologies through
  `nv-fabricmanager`.

- The new `boot.bcache.enable` option allows completely removing `bcache`
  mount support. It is enabled by default.

- `security.sudo` provides two extra options now, while not changing the
  module's default behaviour:
  - `defaultOptions` controls the options used for the default rules;
  - `keepTerminfo` controls whether `TERMINFO` and `TERMINFO_DIRS` are preserved
    for `root` and the `wheel` group.

- `virtualisation.googleComputeImage` provides a `efi` option to support UEFI
  booting now.

- CoreDNS may be built with external plugins now. This may be done by
  overriding `externalPlugins` and `vendorHash` arguments like this:

  ```nix
  {
    services.coredns = {
      enable = true;
      package = pkgs.coredns.override {
        externalPlugins = [
          {name = "fanout"; repo = "github.com/networkservicemesh/fanout"; version = "v1.9.1";}
        ];
        vendorHash = "<SRI hash>";
      };
    };
  }
  ```

  To get the necessary SRI hash, set `vendorHash = "";`. The build will fail
  and produce the correct `vendorHash` in the error message.

  If you use this feature, updates to CoreDNS may require updating `vendorHash`
  by following these steps again.

- Using `fusuma` enables the following plugins now:
  [appmatcher](https://github.com/iberianpig/fusuma-plugin-appmatcher),
  [keypress](https://github.com/iberianpig/fusuma-plugin-keypress),
  [sendkey](https://github.com/iberianpig/fusuma-plugin-sendkey),
  [tap](https://github.com/iberianpig/fusuma-plugin-tap) and
  [wmctrl](https://github.com/iberianpig/fusuma-plugin-wmctrl).

- The Home Assistant module offers support for installing custom components and
  lovelace modules now. Available at
  [`services.home-assistant.customComponents`](#opt-services.home-assistant.customComponents)
  and
  [`services.home-assistant.customLovelaceModules`](#opt-services.home-assistant.customLovelaceModules).

- TeX Live environments can now be built with the new `texlive.withPackages`.
  The procedure for creating custom TeX packages has been changed. Refer to the
  [Nixpkgs
  manual](https://nixos.org/manual/nixpkgs/stable/#sec-language-texlive-custom-packages)
  for more details.

- In `wxGTK32`, the webkit module `wxWebView` has been enabled on all builds.
  Prior releases only enabled this on Darwin.

- Support for WiFi6 (IEEE 802.11ax) and WPA3-SAE-PK was enabled in the
  `hostapd` package, along with a significant rework of the hostapd module.

- LXD supports virtual machine instances now to complement the existing
  container support.

- The `nixos-rebuild` command has been given a `list-generations` subcommand.
  Refer to `man nixos-rebuild` for more details.

- [`sudo-rs`], a reimplementation of `sudo` in Rust, is now supported.
  An experimental new module `security.sudo-rs` was added.
  Switching to it (via ` security.sudo-rs.enable = true;`) introduces
  slight changes in sudo behaviour, due to `sudo-rs`' current limitations:
  - terminfo-related environment variables aren't preserved for `root` and `wheel`;
  - `root` and `wheel` are not given the ability to set (or preserve)
    arbitrary environment variables.

  **Note:** The `sudo-rs` module only takes configuration through `security.sudo-rs`,
  and in particular does not automatically use previously-set rules; this could be
  achieved with `security.sudo-rs.extraRules = security.sudo.extraRules;` for instance.

[`sudo-rs`]: https://github.com/memorysafety/sudo-rs/

- There is a new NixOS option when writing NixOS tests
  `testing.initrdBackdoor`, that enables `backdoor.service` in initrd. Requires
  `boot.initrd.systemd.enable` to be enabled. Boot will pause in Stage 1 at
  `initrd.target`, and will listen for commands from the `Machine` python
  interface, just like Stage 2 normally does. This enables commands to be sent
  to test and debug Stage 1. Use `machine.switch_root()` to leave Stage 1 and
  proceed to Stage 2.

- The Linux kernel module `msr` (refer to
  [`msr(4)`](https://man7.org/linux/man-pages/man4/msr.4.html)), which provides
  an interface to read and write the model-specific registers (MSRs) of an x86
  CPU, can now be configured via `hardware.cpu.x86.msr`.

- The `qemu-vm.nix` module now supports disabling overriding `fileSystems` with
  `virtualisation.fileSystems`. This enables the user to boot VMs from
  "external" disk images not created by the qemu-vm module. You can stop the
  qemu-vm module from overriding `fileSystems` by setting
  `virtualisation.fileSystems = lib.mkForce { };`.

- When using [split parity files](https://www.snapraid.it/manual#7.1) in `snapraid`,
  the snapraid-sync systemd service will no longer fail to run.

- `wpa_supplicant`'s configuration file cannot be read by non-root users, and
  secrets (such as Pre-Shared Keys) can safely be passed via
  `networking.wireless.environmentFile`.

  The configuration file could previously be read, when `userControlled.enable` (non-default),
  by users who are in both `wheel` and `userControlled.group` (defaults to `wheel`)


## Nixpkgs Library {#sec-release-23.11-nixpkgs-lib}

### Breaking Changes {#sec-release-23.11-lib-breaking}

- [`lib.lists.foldl'`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.foldl-prime)
  now always evaluates the initial accumulator argument first. If you depend on
  the lazier behavior, consider using
  [`lib.lists.foldl`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.foldl)
  or
  [`builtins.foldl'`](https://nixos.org/manual/nix/stable/language/builtins.html#builtins-foldl')
  instead.
- [`lib.attrsets.foldlAttrs`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.attrsets.foldlAttrs)
  now always evaluates the initial accumulator argument first.
- Now that the internal NixOS transition to Markdown documentation is complete,
  `lib.options.literalDocBook` has been removed after deprecation in 22.11.
- `lib.types.string` is now fully deprecated and gives a warning when used.

### Additions and Improvements {#sec-release-23.11-lib-additions-improvements}

- [`lib.fileset`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-fileset):
  A new sub-library to select local files to use for sources, designed to be
  easy and safe to use.

  This aims to be a replacement for `lib.sources`-based filtering. To learn
  more about it, see [the blog
  post](https://www.tweag.io/blog/2023-11-28-file-sets/) or [the
  tutorial](https://nix.dev/tutorials/file-sets).

- [`lib.gvariant`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-gvariant):
  A partial and basic implementation of GVariant formatted strings. See
  [GVariant Format
  Strings](https://docs.gtk.org/glib/gvariant-format-strings.html) for details.

  :::{.warning}
  This API is not considered fully stable and it might therefore
  change in backwards incompatible ways without prior notice.
  :::

- [`lib.asserts`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-asserts):
  New function:
  [`assertEachOneOf`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.asserts.assertEachOneOf).
- [`lib.attrsets`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-attrsets):
  New function:
  [`attrsToList`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.attrsets.attrsToList).
- [`lib.customisation`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-customisation):
  New function:
  [`makeScopeWithSplicing'`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.customisation.makeScopeWithSplicing-prime).
- [`lib.fixedPoints`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-fixedPoints):
  Documentation improvements for
  [`lib.fixedPoints.fix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.fixedPoints.fix).
- `lib.generators`: New functions:
  [`mkDconfKeyValue`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.generators.mkDconfKeyValue),
  [`toDconfINI`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.generators.toDconfINI).

  `lib.generators.toKeyValue` now supports the `indent` attribute in its first
  argument.
- [`lib.lists`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-lists):
  New functions:
  [`findFirstIndex`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.findFirstIndex),
  [`hasPrefix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.hasPrefix),
  [`removePrefix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.removePrefix),
  [`commonPrefix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.commonPrefix),
  [`allUnique`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.allUnique).

  Documentation improvements for
  [`lib.lists.foldl'`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.lists.foldl-prime).
- [`lib.meta`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-meta):
  Documentation of functions now gets rendered
- [`lib.path`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-path):
  New functions:
  [`hasPrefix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.path.hasPrefix),
  [`removePrefix`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.path.removePrefix),
  [`splitRoot`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.path.splitRoot),
  [`subpath.components`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.path.subpath.components).
- [`lib.strings`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-strings):
  New functions:
  [`replicate`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.strings.replicate),
  [`cmakeOptionType`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.strings.cmakeOptionType),
  [`cmakeBool`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.strings.cmakeBool),
  [`cmakeFeature`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.strings.cmakeFeature).
- [`lib.trivial`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-trivial):
  New function:
  [`mirrorFunctionArgs`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.trivial.mirrorFunctionArgs).
- `lib.systems`: New function:
  [`equals`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.systems.equals).
- [`lib.options`](https://nixos.org/manual/nixpkgs/stable#sec-functions-library-options):
  Improved documentation for
  [`mkPackageOption`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.options.mkPackageOption).

  [`mkPackageOption`](https://nixos.org/manual/nixpkgs/stable#function-library-lib.options.mkPackageOption).
  now also supports the `pkgsText` attribute.

Module system:
- Options in the `options` module argument now have the `declarationPositions`
  attribute containing the position where the option was declared:
  ```
  $ nix-repl -f '<nixpkgs/nixos>' [...]
  nix-repl> :p options.environment.systemPackages.declarationPositions
  [ {
    column = 7;
    file = "/nix/store/vm9zf9wvfd628cchj0hdij1g4hzjrcz9-source/nixos/modules/config/system-path.nix";
    line = 62;
  } ]
  ```

  Not to be confused with `definitionsWithLocations`, which is the same but for option _definitions_.
- Improved error message for option declarations missing `mkOption`

### Deprecations {#sec-release-23.11-lib-deprecations}

- `lib.meta.getExe pkg` (also available as `lib.getExe`) now gives a warning if
  `pkg.meta.mainProgram` is not set, but it continues to default to the
  derivation name. Nixpkgs accepts PRs that set `meta.mainProgram` on packages
  where it makes sense. Use `lib.getExe' pkg "some-command"` to avoid the
  warning and/or select a different executable.
