{
  lib,
  buildPythonPackage,
  fetchPypi,
  cryptography,
}:

buildPythonPackage rec {
  pname = "types-pyopenssl";
  version = "24.1.0.20240425";
  format = "setuptools";

  src = fetchPypi {
    pname = "types-pyOpenSSL";
    inherit version;
    hash = "sha256-Cn6CYmwZg9yNxZKSvyBlSlHDw4gby7mzN8HabjLwIE4=";
  };

  propagatedBuildInputs = [ cryptography ];

  # Module doesn't have tests
  doCheck = false;

  pythonImportsCheck = [ "OpenSSL-stubs" ];

  meta = with lib; {
    description = "Typing stubs for pyopenssl";
    homepage = "https://github.com/python/typeshed";
    license = licenses.asl20;
    maintainers = with maintainers; [ gador ];
  };
}
