{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  poetry-core,
  requests-mock,
  pythonOlder,
  pytest-asyncio,
  pytestCheckHook,
  python-dateutil,
  requests,
}:

buildPythonPackage rec {
  pname = "flipr-api";
  version = "1.5.1";
  pyproject = true;

  disabled = pythonOlder "3.9";

  src = fetchFromGitHub {
    owner = "cnico";
    repo = "flipr-api";
    rev = "refs/tags/${version}";
    hash = "sha256-xgLi2lH+EPPNlMixqOzdBGVLuoJh5dhZ2tHZ0UH+lOk=";
  };

  nativeBuildInputs = [ poetry-core ];

  propagatedBuildInputs = [
    python-dateutil
    requests
  ];

  nativeCheckInputs = [
    requests-mock
    pytest-asyncio
    pytestCheckHook
  ];

  pythonImportsCheck = [ "flipr_api" ];

  meta = with lib; {
    description = "Python client for Flipr API";
    mainProgram = "flipr-api";
    homepage = "https://github.com/cnico/flipr-api";
    changelog = "https://github.com/cnico/flipr-api/releases/tag/${version}";
    license = licenses.mit;
    maintainers = with maintainers; [ fab ];
  };
}
