# Release 18.03 ("Impala", 2018/04/04) {#sec-release-18.03}

## Highlights {#sec-release-18.03-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- End of support is planned for end of October 2018, handing over to 18.09.

- Platform support: x86_64-linux and x86_64-darwin since release time (the latter isn't NixOS, really). Binaries for aarch64-linux are available, but no channel exists yet, as it's waiting for some test fixes, etc.

- Nix now defaults to 2.0; see its [release notes](https://nixos.org/nix/manual/#ssec-relnotes-2.0).

- Core version changes: linux: 4.9 -\> 4.14, glibc: 2.25 -\> 2.26, gcc: 6 -\> 7, systemd: 234 -\> 237.

- Desktop version changes: gnome: 3.24 -\> 3.26, (KDE) plasma-desktop: 5.10 -\> 5.12.

- MariaDB 10.2, updated from 10.1, is now the default MySQL implementation. While upgrading a few changes have been made to the infrastructure involved:

  - `libmysql` has been deprecated, please use `mysql.connector-c` instead, a compatibility passthru has been added to the MySQL packages.

  - The `mysql57` package has a new `static` output containing the static libraries including `libmysqld.a`

- PHP now defaults to PHP 7.2, updated from 7.1.

## New Services {#sec-release-18.03-new-services}

The following new services were added since the last release:

- `./config/krb5/default.nix`

- `./hardware/digitalbitbox.nix`

- `./misc/label.nix`

- `./programs/ccache.nix`

- `./programs/criu.nix`

- `./programs/digitalbitbox/default.nix`

- `./programs/less.nix`

- `./programs/npm.nix`

- `./programs/plotinus.nix`

- `./programs/rootston.nix`

- `./programs/systemtap.nix`

- `./programs/sway.nix`

- `./programs/udevil.nix`

- `./programs/way-cooler.nix`

- `./programs/yabar.nix`

- `./programs/zsh/zsh-autoenv.nix`

- `./services/backup/borgbackup.nix`

- `./services/backup/crashplan-small-business.nix`

- `./services/desktops/dleyna-renderer.nix`

- `./services/desktops/dleyna-server.nix`

- `./services/desktops/pipewire.nix`

- `./services/desktops/gnome3/chrome-gnome-shell.nix`

- `./services/desktops/gnome3/tracker-miners.nix`

- `./services/hardware/fwupd.nix`

- `./services/hardware/interception-tools.nix`

- `./services/hardware/u2f.nix`

- `./services/hardware/usbmuxd.nix`

- `./services/mail/clamsmtp.nix`

- `./services/mail/dkimproxy-out.nix`

- `./services/mail/pfix-srsd.nix`

- `./services/misc/gitea.nix`

- `./services/misc/home-assistant.nix`

- `./services/misc/ihaskell.nix`

- `./services/misc/logkeys.nix`

- `./services/misc/novacomd.nix`

- `./services/misc/osrm.nix`

- `./services/misc/plexpy.nix`

- `./services/misc/pykms.nix`

- `./services/misc/tzupdate.nix`

- `./services/monitoring/fusion-inventory.nix`

- `./services/monitoring/prometheus/exporters.nix`

- `./services/network-filesystems/beegfs.nix`

- `./services/network-filesystems/davfs2.nix`

- `./services/network-filesystems/openafs/client.nix`

- `./services/network-filesystems/openafs/server.nix`

- `./services/network-filesystems/ceph.nix`

- `./services/networking/aria2.nix`

- `./services/networking/monero.nix`

- `./services/networking/nghttpx/default.nix`

- `./services/networking/nixops-dns.nix`

- `./services/networking/rxe.nix`

- `./services/networking/stunnel.nix`

- `./services/web-apps/matomo.nix`

- `./services/web-apps/restya-board.nix`

- `./services/web-servers/mighttpd2.nix`

- `./services/x11/fractalart.nix`

- `./system/boot/binfmt.nix`

- `./system/boot/grow-partition.nix`

- `./tasks/filesystems/ecryptfs.nix`

- `./virtualisation/hyperv-guest.nix`

## Backward Incompatibilities {#sec-release-18.03-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- `sound.enable` now defaults to false.

- Dollar signs in options under `services.postfix` are passed verbatim to Postfix, which will interpret them as the beginning of a parameter expression. This was already true for string-valued options in the previous release, but not for list-valued options. If you need to pass literal dollar signs through Postfix, double them.

- The `postage` package (for web-based PostgreSQL administration) has been renamed to `pgmanage`. The corresponding module has also been renamed. To migrate please rename all `services.postage` options to `services.pgmanage`.

- Package attributes starting with a digit have been prefixed with an underscore sign. This is to avoid quoting in the configuration and other issues with command-line tools like `nix-env`. The change affects the following packages:

  - `2048-in-terminal` → `_2048-in-terminal`

  - `90secondportraits` → `_90secondportraits`

  - `2bwm` → `_2bwm`

  - `389-ds-base` → `_389-ds-base`

- **The OpenSSH service no longer enables support for DSA keys by default, which could cause a system lock out. Update your keys or, unfavorably, re-enable DSA support manually.**

  DSA support was [deprecated in OpenSSH 7.0](https://www.openssh.com/legacy.html), due to it being too weak. To re-enable support, add `PubkeyAcceptedKeyTypes +ssh-dss` to the end of your `services.openssh.extraConfig`.

  After updating the keys to be stronger, anyone still on a pre-17.03 version is safe to jump to 17.03, as vetted [here](https://search.nix.gsc.io/?q=stateVersion).

- The `openssh` package now includes Kerberos support by default; the `openssh_with_kerberos` package is now a deprecated alias. If you do not want Kerberos support, you can do `openssh.override { withKerberos = false; }`. Note, this also applies to the `openssh_hpn` package.

- `cc-wrapper` has been split in two; there is now also a `bintools-wrapper`. The most commonly used files in `nix-support` are now split between the two wrappers. Some commonly used ones, like `nix-support/dynamic-linker`, are duplicated for backwards compatibility, even though they rightly belong only in `bintools-wrapper`. Other more obscure ones are just moved.

- The propagation logic has been changed. The new logic, along with new types of dependencies that go with, is thoroughly documented in the "Specifying dependencies" section of the "Standard Environment" chapter of the nixpkgs manual. The old logic isn't but is easy to describe: dependencies were propagated as the same type of dependency no matter what. In practice, that means that many `propagatedNativeBuildInputs` should instead be `propagatedBuildInputs`. Thankfully, that was and is the least used type of dependency. Also, it means that some `propagatedBuildInputs` should instead be `depsTargetTargetPropagated`. Other types dependencies should be unaffected.

- `lib.addPassthru drv passthru` is removed. Use `lib.extendDerivation true passthru drv` instead.

- The `memcached` service no longer accept dynamic socket paths via `services.memcached.socket`. Unix sockets can be still enabled by `services.memcached.enableUnixSocket` and will be accessible at `/run/memcached/memcached.sock`.

- The `hardware.amdHybridGraphics.disable` option was removed for lack of a maintainer. If you still need this module, you may wish to include a copy of it from an older version of nixos in your imports.

- The merging of config options for `services.postfix.config` was buggy. Previously, if other options in the Postfix module like `services.postfix.useSrs` were set and the user set config options that were also set by such options, the resulting config wouldn't include all options that were needed. They are now merged correctly. If config options need to be overridden, `lib.mkForce` or `lib.mkOverride` can be used.

- The following changes apply if the `stateVersion` is changed to 18.03 or higher. For `stateVersion = "17.09"` or lower the old behavior is preserved.

  - `matrix-synapse` uses postgresql by default instead of sqlite. Migration instructions can be found [ here ](https://github.com/matrix-org/synapse/blob/master/docs/postgres.rst#porting-from-sqlite).

- The `jid` package has been removed, due to maintenance overhead of a go package having non-versioned dependencies.

- When using `services.xserver.libinput` (enabled by default in GNOME), it now handles all input devices, not just touchpads. As a result, you might need to re-evaluate any custom Xorg configuration. In particular, `Option "XkbRules" "base"` may result in broken keyboard layout.

- The `attic` package was removed. A maintained fork called [Borg](https://www.borgbackup.org/) should be used instead. Migration instructions can be found [here](http://borgbackup.readthedocs.io/en/stable/usage/upgrade.html#attic-and-borg-0-xx-to-borg-1-x).

- The Piwik analytics software was renamed to Matomo:

  - The package `pkgs.piwik` was renamed to `pkgs.matomo`.

  - The service `services.piwik` was renamed to `services.matomo`.

  - The data directory `/var/lib/piwik` was renamed to `/var/lib/matomo`. All files will be moved automatically on first startup, but you might need to adjust your backup scripts.

  - The default `serverName` for the nginx configuration changed from `piwik.${config.networking.hostName}` to `matomo.${config.networking.hostName}.${config.networking.domain}` if `config.networking.domain` is set, `matomo.${config.networking.hostName}` if it is not set. If you change your `serverName`, remember you'll need to update the `trustedHosts[]` array in `/var/lib/matomo/config/config.ini.php` as well.

  - The `piwik` user was renamed to `matomo`. The service will adjust ownership automatically for files in the data directory. If you use unix socket authentication, remember to give the new `matomo` user access to the database and to change the `username` to `matomo` in the `[database]` section of `/var/lib/matomo/config/config.ini.php`.

  - If you named your database \`piwik\`, you might want to rename it to \`matomo\` to keep things clean, but this is neither enforced nor required.

- `nodejs-4_x` is end-of-life. `nodejs-4_x`, `nodejs-slim-4_x` and `nodePackages_4_x` are removed.

- The `pump.io` NixOS module was removed. It is now maintained as an [external module](https://github.com/rvl/pump.io-nixos).

- The Prosody XMPP server has received a major update. The following modules were renamed:

  - `services.prosody.modules.httpserver` is now `services.prosody.modules.http_files`

  - `services.prosody.modules.console` is now `services.prosody.modules.admin_telnet`

  Many new modules are now core modules, most notably `services.prosody.modules.carbons` and `services.prosody.modules.mam`.

  The better-performing `libevent` backend is now enabled by default.

  `withCommunityModules` now passes through the modules to `services.prosody.extraModules`. Use `withOnlyInstalledCommunityModules` for modules that should not be enabled directly, e.g `lib_ldap`.

- All prometheus exporter modules are now defined as submodules. The exporters are configured using `services.prometheus.exporters`.

## Other Notable Changes {#sec-release-18.03-notable-changes}

- ZNC option `services.znc.mutable` now defaults to `true`. That means that old configuration is not overwritten by default when update to the znc options are made.

- The option `networking.wireless.networks.<name>.auth` has been added for wireless networks with WPA-Enterprise authentication. There is also a new `extraConfig` option to directly configure `wpa_supplicant` and `hidden` to connect to hidden networks.

- In the module `networking.interfaces.<name>` the following options have been removed:

  - `ipAddress`

  - `ipv6Address`

  - `prefixLength`

  - `ipv6PrefixLength`

  - `subnetMask`

  To assign static addresses to an interface the options `ipv4.addresses` and `ipv6.addresses` should be used instead. The options `ip4` and `ip6` have been renamed to `ipv4.addresses` `ipv6.addresses` respectively. The new options `ipv4.routes` and `ipv6.routes` have been added to set up static routing.

- The option `services.logstash.listenAddress` is now `127.0.0.1` by default. Previously the default behaviour was to listen on all interfaces.

- `services.btrfs.autoScrub` has been added, to periodically check btrfs filesystems for data corruption. If there's a correct copy available, it will automatically repair corrupted blocks.

- `displayManager.lightdm.greeters.gtk.clock-format.` has been added, the clock format string (as expected by strftime, e.g. `%H:%M`) to use with the lightdm gtk greeter panel.

  If set to null the default clock format is used.

- `displayManager.lightdm.greeters.gtk.indicators` has been added, a list of allowed indicator modules to use with the lightdm gtk greeter panel.

  Built-in indicators include `~a11y`, `~language`, `~session`, `~power`, `~clock`, `~host`, `~spacer`. Unity indicators can be represented by short name (e.g. `sound`, `power`), service file name, or absolute path.

  If set to `null` the default indicators are used.

  In order to have the previous default configuration add

  ```nix
  {
    services.xserver.displayManager.lightdm.greeters.gtk.indicators = [
      "~host" "~spacer"
      "~clock" "~spacer"
      "~session"
      "~language"
      "~a11y"
      "~power"
    ];
  }
  ```

  to your `configuration.nix`.

- The NixOS test driver supports user services declared by `systemd.user.services`. The methods `waitForUnit`, `getUnitInfo`, `startJob` and `stopJob` provide an optional `$user` argument for that purpose.

- Enabling bash completion on NixOS, `programs.bash.enableCompletion`, will now also enable completion for the Nix command line tools by installing the [nix-bash-completions](https://github.com/hedning/nix-bash-completions) package.

- The vim/kakoune plugin updater now reads from a CSV file: check `pkgs/applications/editors/vim/plugins/vim-plugin-names` out to see the new format
