{ lib
, buildGoModule
, fetchFromGitHub
, nixosTests
}:

buildGoModule rec {
  pname = "fastly-exporter";
  version = "8.0.0";

  src = fetchFromGitHub {
    owner = "fastly";
    repo = "fastly-exporter";
    rev = "v${version}";
    hash = "sha256-3XIw9Sq7aQ6bs7kY0fYP3UGfJeq80gB2vXX69EEOtl4=";
  };

  vendorHash = "sha256-kiP9nL/fVnekIf1ABAbSNebszcrj/xkFw9NcuBr/wKQ=";

  passthru.tests = {
    inherit (nixosTests.prometheus-exporters) fastly;
  };

  meta = with lib; {
    description = "Prometheus exporter for the Fastly Real-time Analytics API";
    homepage = "https://github.com/fastly/fastly-exporter";
    license = licenses.asl20;
    maintainers = teams.deshaw.members;
    mainProgram = "fastly-exporter";
  };
}
