{
  lib,
  buildPythonPackage,
  fetchPypi,
  flit-core,
  django,
  djangorestframework,
  pytestCheckHook,
  pytest-django,
}:

buildPythonPackage rec {
  pname = "django-filter";
  version = "24.2";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-SOX8HaPM1soNX5u1UJc1GM6Xek7d6dKooVSn9PC5+W4=";
  };

  build-system = [ flit-core ];

  dependencies = [ django ];

  pythonImportsCheck = [ "django_filters" ];

  nativeCheckInputs = [
    djangorestframework
    pytestCheckHook
    pytest-django
  ];

  env.DJANGO_SETTINGS_MODULE = "tests.settings";

  meta = with lib; {
    description = "Reusable Django application for allowing users to filter querysets dynamically";
    homepage = "https://github.com/carltongibson/django-filter";
    changelog = "https://github.com/carltongibson/django-filter/blob/${version}/CHANGES.rst";
    license = licenses.bsd3;
    maintainers = with maintainers; [ mmai ];
  };
}
