{
  buildPecl,
  lib,
  fetchFromGitHub,
}:

let
  version = "1.1.1";
in
buildPecl {
  inherit version;
  pname = "ast";

  src = fetchFromGitHub {
    owner = "nikic";
    repo = "php-ast";
    rev = "v${version}";
    sha256 = "sha256-ulMLufhLf9E11Z6+rVBZ14CY3ILp/NrhMjRXmrUHnBA=";
  };

  meta = with lib; {
    changelog = "https://github.com/nikic/php-ast/releases/tag/v${version}";
    description = "Exposes the abstract syntax tree generated by PHP";
    license = licenses.bsd3;
    homepage = "https://pecl.php.net/package/ast";
    maintainers = teams.php.members;
  };
}
