{ lib, fetchFromGitLab, buildDunePackage }:

buildDunePackage rec {
  pname = "menhirLib";
  version = "20231231";
  minimalOCamlVersion = "4.03";

  src = fetchFromGitLab {
    domain = "gitlab.inria.fr";
    owner = "fpottier";
    repo = "menhir";
    rev = version;
    hash = "sha256-veB0ORHp6jdRwCyDDAfc7a7ov8sOeHUmiELdOFf/QYk=";
  };

  meta = with lib; {
    homepage = "http://pauillac.inria.fr/~fpottier/menhir/";
    description = "Runtime support library for parsers generated by Menhir";
    longDescription = ''
      Menhir is a LR(1) parser generator for the Objective Caml programming
      language.  That is, Menhir compiles LR(1) grammar specifications down
      to OCaml code.  Menhir was designed and implemented by François Pottier
      and Yann Régis-Gianas.
    '';
    license = with licenses; [ lgpl2Only ];
    maintainers = with maintainers; [ vbgl ];
  };
}
