{ pname
, version
, src
, patches ? [ ]
, meta
}:

# Note: this package is used for bootstrapping fetchurl, and thus cannot use
# fetchpatch! All mutable patches (generated by GitHub or cgit) that are needed
# here should be included directly in Nixpkgs as files.

{ lib
, stdenv
, fetchurl
, lzip
}:

stdenv.mkDerivation {
  inherit pname version src patches;

  nativeBuildInputs = [ lzip ];

  configureFlags = [
    "CC=${stdenv.cc.targetPrefix}cc"
  ];

  doCheck = true;

  inherit meta;
}
